/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.BelljarHandler.IPlantHandler;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.HashMap;

public class AttainedDropsHelper extends IECompatModule
{
	@Override
	public void preInit()
	{
	}

	static HashMap<ComparableItemStack, ItemStack[]> soilOutputMap = new HashMap<>();
	static HashMap<ComparableItemStack, IBlockState> bulbMap = new HashMap<>();

	@Override
	public void init()
	{
		Block blockPlant = Block.field_149771_c.func_82594_a(new ResourceLocation("attaineddrops:plant"));
		final Item itemSeed = Item.field_150901_e.func_82594_a(new ResourceLocation("attaineddrops:itemseed"));
		if(blockPlant==null||itemSeed==null)
			return;
		final IBlockState blockstatePlant = blockPlant.func_176223_P();
		IProperty propertyAge = null;
		for(IProperty prop : blockstatePlant.func_177227_a())
			if("age".equals(prop.func_177701_a()) && prop instanceof PropertyInteger)
				propertyAge = prop;
		final IProperty propertyAge_final = propertyAge;

		addType("slimeball", new ItemStack(Items.field_151123_aH));
		addType("bone", new ItemStack(Items.field_151103_aS));
		addType("string", new ItemStack(Items.field_151007_F));
		addType("rottenflesh", new ItemStack(Items.field_151078_bh));
		addType("ghasttear", new ItemStack(Items.field_151073_bk));
		addType("spidereye", new ItemStack(Items.field_151070_bp));
		addType("prismarine", new ItemStack(Items.field_179562_cC));
		addType("blaze", new ItemStack(Items.field_151072_bj));
		addType("gunpowder", new ItemStack(Items.field_151016_H));
		addType("witherskull", new ItemStack(Items.field_151144_bL,1,1));
		addType("enderpearl", new ItemStack(Items.field_151079_bi));
		BelljarHandler.registerHandler(new IPlantHandler()
		{
			@Override
			public boolean isCorrectSoil(ItemStack seed, ItemStack soil)
			{
				return !soil.func_190926_b()&&soilOutputMap.containsKey(new ComparableItemStack(soil));
			}
			@Override
			public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render)
			{
				return (growth<.5?.003125f:.0015625f)*fertilizer;
			}
			@Override
			public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render)
			{
				return .5f;
			}
			@Override
			public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile)
			{
				ItemStack[] out = soilOutputMap.get(new ComparableItemStack(soil));
				if(out==null)
					return new ItemStack[0];
				return out;
			}
			@Override
			public boolean isValid(ItemStack seed)
			{
				return !seed.func_190926_b() && seed.func_77973_b()==itemSeed;
			}

			@Override
			@SideOnly(Side.CLIENT)
			public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile)
			{
				return new IBlockState[0];
			}
			@Override
			@SideOnly(Side.CLIENT)
			public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile)
			{
				return .875f;
			}
			@Override
			@SideOnly(Side.CLIENT)
			public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer)
			{
				IBlockState state = blockstatePlant.func_177226_a(propertyAge_final, growth>=.5?7:Math.min(7,Math.round(7*growth*2)));
				IBakedModel model = blockRenderer.func_184389_a(state);
				GlStateManager.func_179094_E();
				blockRenderer.func_175019_b().func_178266_a(model, state, 1, true);
				GlStateManager.func_179121_F();
				if(growth>=.5)
				{
					state = bulbMap.get(new ComparableItemStack(soil));
					model = blockRenderer.func_184389_a(state);
					GlStateManager.func_179094_E();
					float scale = (growth-.5f)*2f;
					GlStateManager.func_179137_b(.5-scale/2, 1, -.5+scale/2);
					GlStateManager.func_179152_a(scale, scale, scale);
					blockRenderer.func_175019_b().func_178266_a(model, state, 1, true);
					GlStateManager.func_179121_F();
				}
				return true;
			}
		});
	}

	static void addType(String type, ItemStack out)
	{
		Block soilBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("attaineddrops:"+type+"_soil"));
		Block bulbBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("attaineddrops:"+type+"_bulb"));
		if(soilBlock!=null && bulbBlock!=null)
		{
			ComparableItemStack comp = new ComparableItemStack(new ItemStack(soilBlock));
			soilOutputMap.put(comp, new ItemStack[]{out});
			bulbMap.put(comp, bulbBlock.func_176223_P());
		}
	}

	@Override
	public void postInit()
	{
	}
}
