/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ActuallyAdditionsHelper extends IECompatModule
{
	@Override
	public void preInit()
	{
	}

	@Override
	public void init()
	{
	}

	@Override
	public void postInit()
	{
		Fluid canolaOil = FluidRegistry.getFluid("canolaoil");
		if(canolaOil!=null)
			SqueezerRecipe.addRecipe(new FluidStack(canolaOil,80), ItemStack.field_190927_a, "cropCanola", 6400);

		Item coffeeSeeds = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_coffee_seed"));
		Item coffeeBeans = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_coffee_beans"));
		Block coffeeBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("actuallyadditions","block_coffee"));
		if(coffeeSeeds!=null && coffeeBeans!=null && coffeeBlock!=null)
			BelljarHandler.cropHandler.register(new ItemStack(coffeeSeeds), new ItemStack[]{new ItemStack(coffeeBeans,3), new ItemStack(coffeeSeeds)}, new ItemStack(Blocks.field_150346_d), coffeeBlock.func_176223_P());

		Item riceSeeds = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_rice_seed"));
		Item food = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_food"));
		Block riceBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("actuallyadditions","block_rice"));
		if(riceSeeds!=null && food!=null && riceBlock!=null)
			BelljarHandler.cropHandler.register(new ItemStack(riceSeeds), new ItemStack[]{new ItemStack(food,2,16), new ItemStack(riceSeeds)}, new ItemStack(Blocks.field_150346_d), riceBlock.func_176223_P());

		Item canolaSeeds = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_canola_seed"));
		Item misc = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_misc"));
		Block canolaBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("actuallyadditions","block_canola"));
		if(canolaSeeds!=null && misc!=null && canolaBlock!=null)
			BelljarHandler.cropHandler.register(new ItemStack(canolaSeeds), new ItemStack[]{new ItemStack(misc,3,13), new ItemStack(canolaSeeds)}, new ItemStack(Blocks.field_150346_d), canolaBlock.func_176223_P());

		Item flaxSeeds = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_flax_seed"));
		Block flaxBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("actuallyadditions","block_flax"));
		if(flaxSeeds!=null && flaxBlock!=null)
			BelljarHandler.cropHandler.register(new ItemStack(flaxSeeds), new ItemStack[]{new ItemStack(Items.field_151007_F,4), new ItemStack(flaxSeeds)}, new ItemStack(Blocks.field_150346_d), flaxBlock.func_176223_P());

		Item fertilizer = Item.field_150901_e.func_82594_a(new ResourceLocation("actuallyadditions","item_fertilizer"));
		if(fertilizer!=null)
			BelljarHandler.registerBasicItemFertilizer(new ItemStack(fertilizer), 1.25f);
	}
}
