/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler.IESubCommand;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentTranslation;

import java.util.ArrayList;
import java.util.Locale;

public class CommandShaders extends IESubCommand
{
	@Override
	public String getIdent()
	{
		return "shaders";
	}

	@Override
	public void perform(CommandHandler h, MinecraftServer server, ICommandSender sender, String[] args)
	{
		if(args.length>1)
		{
			switch(args[1])
			{
			case "clear":
				String player = args.length>2?args[2].trim():sender.func_70005_c_();
				if(ShaderRegistry.receivedShaders.containsKey(player))
					ShaderRegistry.receivedShaders.get(player).clear();
				ShaderRegistry.recalculatePlayerTotalWeight(player);
				sender.func_145747_a(new TextComponentTranslation(Lib.CHAT_COMMAND+getIdent()+".clear.sucess",player));
				break;
			default:
				sender.func_145747_a(new TextComponentTranslation(getHelp("")));
				break;
			}
		}
		else
			sender.func_145747_a(new TextComponentTranslation(getHelp("")));

	}

	@Override
	public ArrayList<String> getSubCommands(CommandHandler h, MinecraftServer server, ICommandSender sender, String[] args)
	{
		ArrayList<String> list = new ArrayList<String>();
		if(args.length>1)
		{
			switch (args[0])
			{
				case "clear":
					if(args.length>2)
						break;
					list.addAll(CommandBase.func_71530_a(args, server.func_71213_z()));
					break;
			}
			return list;
		}
		
		for(String s : new String[]{"clear"})
		{
			if(args.length==0)
				list.add(s);
			else if(s.toLowerCase(Locale.ENGLISH).startsWith(args[0].toLowerCase(Locale.ENGLISH)))
				list.add(s);
		}
		return list;
	}

	@Override
	public int getPermissionLevel()
	{
		return 4;
	}
}
