/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util;


import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;

import java.util.Map;
import java.util.Set;

import static blusunrize.immersiveengineering.api.ApiUtils.getConnectionCatenary;

public class SkylineHelper
{
	public static EntitySkylineHook spawnHook(EntityPlayer player, TileEntity start, Connection connection)
	{
		BlockPos cc0 = connection.end==Utils.toCC(start)?connection.start:connection.end;
		BlockPos cc1 = connection.end==Utils.toCC(start)?connection.end:connection.start;
		IImmersiveConnectable iicStart = ApiUtils.toIIC(cc1, player.field_70170_p);
		IImmersiveConnectable iicEnd = ApiUtils.toIIC(cc0, player.field_70170_p);
		Vec3d vStart = new Vec3d(cc1);
		Vec3d vEnd = new Vec3d(cc0);

		if(iicStart!=null)
			vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
		if(iicEnd!=null)
			vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));


		/* Reasoning for the formula for pos (below): pos should be the point on the catenary (horizontally) closest to the player position
		A conn start, B conn across, C player pos
		A+tB
		C
		C-A=:D
		D**2=(Cx-Ax-tBx)**2+(Cz-Az-tBz)**2=(Dx-tBx)**2+(Dz-tBz)**2
		=Dx**2-2tDxBx+t**2Bx**2+Dz**2-2tDzBz+t**2Bz**2
		=t**2(Bx**2+Bz**2)-(2DxBx+2DzBz)t+Dz**2+Dx**2

		D**2'=(2Bx**2+2Bz**2)*t-2DxBx+2DzBz=0
		t=(DxBx+DzBz)/(Bx^2+Bz^2)
		 */
		Vec3d pos = player.func_174824_e(0);
		Vec3d delta = pos.func_178788_d(vStart);
		Vec3d across = new Vec3d(vEnd.field_72450_a-vStart.field_72450_a, 0, vEnd.field_72449_c-vStart.field_72449_c);
		double t = (delta.field_72450_a*across.field_72450_a+delta.field_72449_c*across.field_72449_c)/(across.field_72450_a*across.field_72450_a+across.field_72449_c*across.field_72449_c);
		pos = connection.getVecAt(t, vStart, across, across.func_72433_c());
		int tInt = MathHelper.func_76125_a(0, (int)(t*16), 15);

		Vec3d[] steps = getConnectionCatenary(connection, vStart, vEnd);
		EntitySkylineHook hook = new EntitySkylineHook(player.field_70170_p, pos.field_72450_a,pos.field_72448_b,pos.field_72449_c, connection, cc0, steps, tInt+1);
		float speed = 1;
		if(!player.func_184607_cu().func_190926_b()&&player.func_184607_cu().func_77973_b() instanceof ItemSkyhook)
			speed = ((ItemSkyhook)player.func_184607_cu().func_77973_b()).getSkylineSpeed(player.func_184607_cu());
		Vec3d moveVec = getSubMovementVector(steps[tInt], steps[tInt+1], speed);
		hook.field_70159_w = moveVec.field_72450_a;//*speed;
		hook.field_70181_x = moveVec.field_72448_b;//*speed;
		hook.field_70179_y = moveVec.field_72449_c;//*speed;
		//		hook.motionX = (steps[0].x-cc1.posX)*.5f;
		//		hook.motionY = (steps[0].y-cc1.posY)*.5f;
		//		hook.motionZ = (steps[0].z-cc1.posZ)*.5f;

		//		for(Vec3 v : steps)
		//			living.world.spawnParticle("smoke", v.x,v.y,v.z, 0,0,0 );

		if(!player.field_70170_p.field_72995_K)
			player.field_70170_p.func_72838_d(hook);
		ItemSkyhook.existingHooks.put(player.func_70005_c_(), hook);
		player.func_184220_m(hook);
		return hook;
	}

	public static Vec3d getSubMovementVector(Vec3d start, Vec3d target, float speed)
	{
		Vec3d movementVec = new Vec3d(target.field_72450_a-start.field_72450_a, target.field_72448_b-start.field_72448_b, target.field_72449_c-start.field_72449_c);
		int lPixel = (int)Math.max(1, (movementVec.func_72433_c()/(.125*speed)));
		return new Vec3d(movementVec.field_72450_a/lPixel, movementVec.field_72448_b/lPixel, movementVec.field_72449_c/lPixel);
	}
	public static boolean isInBlock(EntityPlayer player, World w)
	{
		BlockPos init = player.func_180425_c();
		AxisAlignedBB hitbox = player.func_174813_aQ();
		hitbox = new AxisAlignedBB(hitbox.field_72340_a-1, hitbox.field_72338_b-1, hitbox.field_72339_c-1, hitbox.field_72336_d, hitbox.field_72337_e, hitbox.field_72334_f);
		
		for (int xOff = 0;xOff<2;xOff++)
			for (int yOff = 0;yOff<3;yOff++)
				for (int zOff = 0;zOff<2;zOff++)
				{
					Vec3d v = new Vec3d(init.func_177958_n()+xOff, init.func_177956_o()+yOff, init.func_177952_p()+zOff);
					if (hitbox.func_72318_a(v)&&!w.func_175623_d(new BlockPos(v)))
						return true;
				}
		return false;
	}

	public static Connection getTargetConnection(World world, EntityPlayer player, Connection ignored)
	{
		double py = player.field_70163_u + player.func_70047_e();
		BlockPos head = new BlockPos(player.field_70165_t, py, player.field_70161_v);
		Connection ret = null;
			Map<BlockPos, ImmersiveNetHandler.BlockWireInfo> inDim = ImmersiveNetHandler.INSTANCE.blockWireMap
					.func_76041_a(player.field_71093_bK);
			if (inDim != null && inDim.containsKey(head))
			{
				ImmersiveNetHandler.BlockWireInfo info = inDim.get(head);
				for (int i = 0;i<2;i++)
				{
					Set<Triple<Connection, Vec3d, Vec3d>> conns = i==0?info.in:info.near;
					for (Triple<Connection, Vec3d, Vec3d> conn : conns)
					{
						Connection c = conn.getLeft();
						if (ignored == null || !c.hasSameConnectors(ignored))
						{
							ret = c;
							break;
						}
					}
				}
			}
		if (ret!=null)
		{
			Vec3d across = new Vec3d(ret.end).func_178788_d(new Vec3d(ret.start));
			if (across.func_72430_b(player.func_70040_Z())<0)
			{
				ret = ImmersiveNetHandler.INSTANCE.getReverseConnection(world.field_73011_w.getDimension(), ret);
			}
		}
		return ret;
	}
}
