/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IEContent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IEPotions
{
	public static Potion flammable;
	public static Potion slippery;
	public static Potion conductive;
	public static Potion sticky;
	public static Potion stunned;
	public static Potion concreteFeet;
	public static Potion flashed;

	public static void init()
	{
		flammable = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "flammable"), true,0x8f3f1f,0, false,0, true,true).func_76390_b("immersiveengineering.potion.flammable");
		slippery = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "slippery"), true,0x171003,0, false,1, true,true).func_76390_b("immersiveengineering.potion.slippery");
		conductive = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "conductive"), true,0x690000,0, false,2, true,true).func_76390_b("immersiveengineering.potion.conductive");
		sticky = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "sticky"), true,0x9c6800,0, false,3, true,true).func_76390_b("immersiveengineering.potion.sticky").func_111184_a(SharedMonsterAttributes.field_111263_d, Utils.generateNewUUID().toString(), -0.50000000298023224D, 2);
		stunned = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "stunned"), true,0x624a98,0, false,4, true,true).func_76390_b("immersiveengineering.potion.stunned");
		concreteFeet = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "concreteFeet"), true,0x624a98,0, false,5, true,true).func_76390_b("immersiveengineering.potion.concreteFeet").func_111184_a(SharedMonsterAttributes.field_111263_d, Utils.generateNewUUID().toString(), -2D, 2);
		flashed = new IEPotion(new ResourceLocation(ImmersiveEngineering.MODID, "flashed"), true,0x624a98,0, false,6, true,true).func_76390_b("immersiveengineering.potion.flashed").func_111184_a(SharedMonsterAttributes.field_111263_d, Utils.generateNewUUID().toString(), -0.15000000596046448D, 2);

		IEApi.potions = new Potion[]{flammable,slippery,conductive,sticky,stunned,concreteFeet,flashed};
	}

	public static class IEPotion extends Potion
	{
		static ResourceLocation tex = new ResourceLocation("immersiveengineering","textures/gui/potioneffects.png");
		final int tickrate;
		final boolean halfTickRateWIthAmplifier;
		boolean showInInventory = true;
		boolean showInHud = true;
		public IEPotion(ResourceLocation resource, boolean isBad, int colour, int tick, boolean halveTick, int icon, boolean showInInventory, boolean showInHud)
		{
			super(isBad, colour);
			this.func_76390_b("potion." + resource.func_110623_a());
			this.showInInventory = showInInventory;
			this.showInHud = showInHud;
			this.tickrate = tick;
			this.halfTickRateWIthAmplifier = halveTick;
			this.func_76399_b(icon%8, icon/8);

			ForgeRegistries.POTIONS.register(this.setRegistryName(resource));
		}

		@Override
		public boolean shouldRender(PotionEffect effect)
		{
			return showInInventory;
		}
		@Override
		public boolean shouldRenderInvText(PotionEffect effect)
		{
			return showInInventory;
		}
		@Override
		public boolean shouldRenderHUD(PotionEffect effect)
		{
			return showInHud;
		}

		@Override
		public int func_76392_e()
		{
			Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
			return super.func_76392_e();
		}
		@Override
		public boolean func_76397_a(int duration, int amplifier)
		{
			if(tickrate<0)
				return false;
			int k = tickrate >> amplifier;
			return k <= 0 || duration % k == 0;
		}
		@Override
		public void func_76394_a(EntityLivingBase living, int amplifier)
		{
			if(this==IEPotions.slippery)
			{
				if(living.field_70122_E)
					living.func_191958_b(0,0,1, 0.005F);
				EntityEquipmentSlot hand = living.func_70681_au().nextBoolean()?EntityEquipmentSlot.MAINHAND:EntityEquipmentSlot.OFFHAND;
				if(!living.field_70170_p.field_72995_K && living.func_70681_au().nextInt(300)==0 && !living.func_184582_a(hand).func_190926_b())
				{
					EntityItem dropped = living.func_70099_a(living.func_184582_a(hand).func_77946_l(), 1);
					dropped.func_174867_a(20);
					living.func_184201_a(hand, ItemStack.field_190927_a);
				}
			}
			else if(this==IEPotions.concreteFeet && !living.field_70170_p.field_72995_K)
			{
				IBlockState state = living.field_70170_p.func_180495_p(living.func_180425_c());
				if(state.func_177230_c()!=IEContent.blockStoneDecoration && state.func_177230_c()!=IEContent.blockStoneDecorationSlabs && state.func_177230_c()!=IEContent.blockStoneDevice)
				{
					PotionEffect effect = living.func_70660_b(this);
					if(effect!=null)
						effect.field_76460_b = 0;
				}
			}
		}
	}
}
