/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

import static java.lang.Math.min;

/**
 * @author BluSunrize - 22.07.2016
 */
public class IELootEntry extends LootEntryItem
{
	public static LootFunction blueprintRename;
	static{
		NBTTagCompound tag = new NBTTagCompound();
		tag.func_74782_a("display", new NBTTagCompound());
		tag.func_74775_l("display").func_74778_a("name", "Super Special BluPrintz");
		NBTTagList list = new NBTTagList();
		list.func_74742_a(new NBTTagString("Congratulations!"));
		list.func_74742_a(new NBTTagString("You have found an easter egg!"));
		tag.func_74775_l("display").func_74782_a("Lore", list);
		blueprintRename = new SetNBT(new LootCondition[]{new RandomChance(.125f)}, tag);
	}

	ItemStack stack;

	public IELootEntry(String entryName, @Nonnull ItemStack stack, int weight, int quality, LootFunction... functions)
	{
		super(stack.func_77973_b(), weight, quality, buildFunctions(stack, functions), new LootCondition[0], entryName);
		this.stack = stack;
	}

	static LootFunction[] buildFunctions(ItemStack stack, LootFunction[] functions)
	{
		List<LootFunction> totalFunctions = new ArrayList();
		for(LootFunction f : functions)
			totalFunctions.add(f);
		if(stack.func_77960_j()!=0)
			totalFunctions.add(new SetMetadata(new LootCondition[0], new RandomValueRange(stack.func_77960_j(),stack.func_77960_j())));
		if(stack.func_190916_E() > 1)
			totalFunctions.add(new SetCount(new LootCondition[0], new RandomValueRange(stack.func_77960_j(),stack.func_77960_j())));
		if(stack.func_77978_p()!=null)
			totalFunctions.add(new SetNBT(new LootCondition[0], stack.func_77978_p()));
		return totalFunctions.toArray(new LootFunction[totalFunctions.size()]);
	}

	@Override
	public void func_186363_a(Collection<ItemStack> stacks, Random rand, LootContext context)
	{
		ItemStack itemstack = stack.func_77946_l();
		int i = 0;
		if(itemstack.func_190916_E() > 0)
		{
			if(itemstack.func_190916_E() < this.stack.func_77973_b().getItemStackLimit(itemstack))
				stacks.add(itemstack);
			else
			{
				i = itemstack.func_190916_E();
				while(i > 0)
				{
					ItemStack itemstack1 = itemstack.func_77946_l();
					itemstack1.func_190920_e(min(itemstack.func_77976_d(), i));
					i -= itemstack1.func_190916_E();
					stacks.add(itemstack1);
				}
			}
		}
	}
}
