/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util;

import com.google.common.base.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.io.IOException;
import java.util.List;

/**
 * @author BluSunrize - 22.02.2017
 */
public class IEFluid extends Fluid
{
	public IEFluid(String fluidName, ResourceLocation still, ResourceLocation flowing)
	{
		super(fluidName, still, flowing);
	}

	@SideOnly(Side.CLIENT)
	public void addTooltipInfo(FluidStack fluidStack, @Nullable EntityPlayer player, List<String> tooltip)
	{
	}

	public static class FluidPotion extends IEFluid
	{
		public FluidPotion(String fluidName, ResourceLocation still, ResourceLocation flowing)
		{
			super(fluidName, still, flowing);
		}

		@Override
		@SideOnly(Side.CLIENT)
		public void addTooltipInfo(FluidStack fluidStack, @Nullable EntityPlayer player, List<String> tooltip)
		{
			if(fluidStack!=null && fluidStack.tag!=null)
			{
				List<PotionEffect> effects = PotionUtils.func_185185_a(fluidStack.tag);
				if(effects.isEmpty())
					tooltip.add(TextFormatting.GRAY+I18n.func_74838_a("effect.none").trim());
				else
				{
					for(PotionEffect potioneffect : effects)
					{
						String s1 = I18n.func_74838_a(potioneffect.func_76453_d()).trim();
						Potion potion = potioneffect.func_188419_a();

						if(potioneffect.func_76458_c()>0)
							s1 = s1+" "+I18n.func_74838_a("potion.potency."+potioneffect.func_76458_c()).trim();

						if(potioneffect.func_76459_b()>20)
							s1 = s1+" ("+Potion.func_188410_a(potioneffect, 1)+")";

						if(potion.func_76398_f())
							tooltip.add(TextFormatting.RED+s1);
						else
							tooltip.add(TextFormatting.BLUE+s1);
					}
				}
			}
		}

		@Override
		public String getLocalizedName(FluidStack stack)
		{
			if(stack==null || stack.tag==null)
				return super.getLocalizedName(stack);
			return I18n.func_74838_a(PotionUtils.func_185187_c(stack.tag).func_185174_b("potion.effect."));
		}

		@Override
		public int getColor(FluidStack stack)
		{
			if(stack==null || stack.tag!=null)
				return 0xff000000 | PotionUtils.func_185181_a(PotionUtils.func_185185_a(stack.tag));
			return 0xff0000ff;
		}
	}

	public static final DataSerializer<Optional<FluidStack>> OPTIONAL_FLUID_STACK = new DataSerializer<Optional<FluidStack>>()
	{
		@Override
		public void func_187160_a(PacketBuffer buf, Optional<FluidStack> value)
		{
			buf.writeBoolean(value.isPresent());
			FluidStack fs = value.orNull();
			if(fs!=null)
				buf.func_150786_a(fs.writeToNBT(new NBTTagCompound()));
		}
		@Override
		public Optional<FluidStack> func_187159_a(PacketBuffer buf) throws IOException
		{
			FluidStack fs = !buf.readBoolean()?null : FluidStack.loadFluidStackFromNBT(buf.func_150793_b());
			return Optional.fromNullable(fs);
		}
		@Override
		public DataParameter<Optional<FluidStack>> func_187161_a(int id)
		{
			return new DataParameter(id, this);
		}

		@Override
		public Optional<FluidStack> func_192717_a(Optional<FluidStack> value)
		{
			return value.isPresent()?Optional.of(value.get().copy()):Optional.absent();
		}
	};
}
