/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


public class ItemWireCoil extends ItemIEBase implements IWireCoil
{
	public ItemWireCoil()
	{
		super("wirecoil", 64, "copper", "electrum", "hv", "rope", "structural", "redstone",
				"insulated_copper", "insulated_electrum");
	}

	@Override
	public WireType getWireType(ItemStack stack)
	{
		switch(stack.func_77952_i())
		{
			case 0:
			default:
				return WireType.COPPER;
			case 1:
				return WireType.ELECTRUM;
			case 2:
				return WireType.STEEL;
			case 3:
				return WireType.STRUCTURE_ROPE;
			case 4:
				return WireType.STRUCTURE_STEEL;
			case 5:
				return WireType.REDSTONE;
			case 6:
				return WireType.COPPER_INSULATED;
			case 7:
				return WireType.ELECTRUM_INSULATED;
		}
	}

	@Override
	public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag)
	{
		if(stack.func_77952_i() == 5)
		{
			list.add(I18n.func_135052_a(Lib.DESC_FLAVOUR + "coil.redstone"));
			list.add(I18n.func_135052_a(Lib.DESC_FLAVOUR + "coil.construction1"));
		} else if(stack.func_77952_i()%6 > 2)
		{
			list.add(I18n.func_135052_a(Lib.DESC_FLAVOUR+"coil.construction0"));
			list.add(I18n.func_135052_a(Lib.DESC_FLAVOUR+"coil.construction1"));
		}
		if(stack.func_77978_p()!=null && stack.func_77978_p().func_74764_b("linkingPos"))
		{
			int[] link = stack.func_77978_p().func_74759_k("linkingPos");
			if(link!=null&&link.length>3)
				list.add(I18n.func_135052_a(Lib.DESC_INFO+"attachedToDim", link[1],link[2],link[3],link[0]));
		}
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
//	public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand)
	{
			TileEntity tileEntity = world.func_175625_s(pos);
			if(tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect())
			{
				ItemStack stack = player.func_184586_b(hand);
				TargetingInfo target = new TargetingInfo(side, hitX,hitY,hitZ);
				WireType wire = getWireType(stack);
				BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, target);
				Vec3i offset = pos.func_177973_b(masterPos);
				tileEntity = world.func_175625_s(masterPos);
				if( !(tileEntity instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect())
					return EnumActionResult.PASS;

				if( !((IImmersiveConnectable)tileEntity).canConnectCable(wire, target, offset))
				{
					if (!world.field_72995_K)
						player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"wrongCable"));
					return EnumActionResult.FAIL;
				}

				if(!world.field_72995_K)
					if(!ItemNBTHelper.hasKey(stack, "linkingPos"))
					{
						ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.getDimension(),masterPos.func_177958_n(),masterPos.func_177956_o(),masterPos.func_177952_p(),
								offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()});
						NBTTagCompound targetNbt = new NBTTagCompound();
						target.writeToNBT(targetNbt);
						ItemNBTHelper.setTagCompound(stack, "targettingInfo", targetNbt);
					}
					else
					{
						int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
						BlockPos linkPos = new BlockPos(array[1],array[2],array[3]);
						Vec3i offsetLink = BlockPos.field_177959_e;
						if (array.length==7)
							offsetLink = new Vec3i(array[4], array[5], array[6]);
						TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
						int distanceSq = (int) Math.ceil( linkPos.func_177951_i(masterPos) );
						if(array[0]!=world.field_73011_w.getDimension())
							player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"wrongDimension"));
						else if(linkPos.equals(masterPos))
							player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"sameConnection"));
						else if( distanceSq > (wire.getMaxLength()*wire.getMaxLength()))
							player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"tooFar"));
						else
						{
							TargetingInfo targetLink = TargetingInfo.readFromNBT(ItemNBTHelper.getTagCompound(stack, "targettingInfo"));
							if(!(tileEntityLinkingPos instanceof IImmersiveConnectable)||!((IImmersiveConnectable) tileEntityLinkingPos).canConnectCable(wire, targetLink, offset))
								player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"invalidPoint"));
							else
							{
								IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
								IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
								boolean connectionExists = false;
								Set<Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC(nodeHere));
								if(outputs!=null)
									for(Connection con : outputs)
									{
										if(con.end.equals(Utils.toCC(nodeLink)))
											connectionExists = true;
									}
								if(connectionExists)
									player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"connectionExists"));
								else
								{
									Set<BlockPos> ignore = new HashSet<>();
									ignore.addAll(nodeHere.getIgnored(nodeLink));
									ignore.addAll(nodeLink.getIgnored(nodeHere));
									Connection tmpConn = new Connection(Utils.toCC(nodeHere), Utils.toCC(nodeLink), wire,
											(int)Math.sqrt(distanceSq));
									Vec3d start = nodeHere.getConnectionOffset(tmpConn, target, pos.func_177973_b(masterPos));
									Vec3d end = nodeLink.getConnectionOffset(tmpConn, targetLink, offsetLink).func_72441_c(linkPos.func_177958_n()-masterPos.func_177958_n(),
											linkPos.func_177956_o()-masterPos.func_177956_o(),
											linkPos.func_177952_p()-masterPos.func_177952_p());
									boolean canSee = ApiUtils.raytraceAlongCatenaryRelative(tmpConn, (p)->{
										if (ignore.contains(p.getLeft()))
											return false;
										IBlockState state = world.func_180495_p(p.getLeft());
										return ApiUtils.preventsConnection(world, p.getLeft(), state, p.getMiddle(), p.getRight());
									}, (p)->{}, start, end);
									if(canSee)
									{
										Connection conn = ImmersiveNetHandler.INSTANCE.addAndGetConnection(world, Utils.toCC(nodeHere), Utils.toCC(nodeLink),
												(int)Math.sqrt(distanceSq), wire);


										nodeHere.connectCable(wire, target, nodeLink, offset);
										nodeLink.connectCable(wire, targetLink, nodeHere, offsetLink);
										ImmersiveNetHandler.INSTANCE.addBlockData(world, conn);
										IESaveData.setDirty(world.field_73011_w.getDimension());
										Utils.unlockIEAdvancement(player, "main/connect_wire");

										if(!player.field_71075_bZ.field_75098_d)
											stack.func_190918_g(1);
										((TileEntity)nodeHere).func_70296_d();
										world.func_175641_c(masterPos, ((TileEntity) nodeHere).func_145838_q(), -1, 0);
										IBlockState state = world.func_180495_p(masterPos);
										world.func_184138_a(masterPos, state,state, 3);
										((TileEntity)nodeLink).func_70296_d();
										world.func_175641_c(linkPos, ((TileEntity) nodeLink).func_145838_q(), -1, 0);
										state = world.func_180495_p(linkPos);
										world.func_184138_a(linkPos, state,state, 3);
									}
									else
										player.func_145747_a(new TextComponentTranslation(Lib.CHAT_WARN+"cantSee"));
								}
							}
						}
						ItemNBTHelper.remove(stack, "linkingPos");
						ItemNBTHelper.remove(stack, "targettingInfo");
					}
				return EnumActionResult.SUCCESS;
			}
		return EnumActionResult.PASS;
	}
}
