/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShaderBag extends ItemIEBase
{
	public ItemShaderBag()
	{
		super("shader_bag", 64);
	}

	//	@Override
//	@SideOnly(Side.CLIENT)
//	public int getColorFromItemStack(ItemStack stack, int pass)
//	{
//		EnumRarity rarity = this.getRarity(stack);
//		return ClientUtils.getFormattingColour(rarity.rarityColor);
//	}
	@Override
	public boolean hasCustomItemColours()
	{
		return true;
	}
	@Override
	public int getColourForIEItem(ItemStack stack, int pass)
	{
		return ClientUtils.getFormattingColour(this.func_77613_e(stack).field_77937_e);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list)
	{
		if(this.func_194125_a(tab))
			for(int i=ShaderRegistry.sortedRarityMap.size()-1; i>=0; i--)
			{
				EnumRarity rarity = ShaderRegistry.sortedRarityMap.get(i);
				ItemStack s = new ItemStack(this);
				ItemNBTHelper.setString(s, "rarity", rarity.toString());
				list.add(s);
			}
	}

	@Override
	public String func_77653_i(ItemStack stack)
	{
		return func_77613_e(stack).field_77934_f +" "+ super.func_77653_i(stack);
	}

	@Override
	public EnumRarity func_77613_e(ItemStack stack)
	{
		String r = ItemNBTHelper.getString(stack, "rarity");
		for(EnumRarity rarity : EnumRarity.values())
			if(rarity.toString().equalsIgnoreCase(r))
				return rarity;
		return EnumRarity.COMMON;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand)
	{
		ItemStack stack = player.func_184586_b(hand);
		if(!world.field_72995_K)
			if(ShaderRegistry.totalWeight.containsKey(stack.func_77953_t()))
			{
				String shader = ShaderRegistry.getRandomShader(player.func_70005_c_(), player.func_70681_au(), stack.func_77953_t(), true);
				if(shader==null || shader.isEmpty())
					return new ActionResult(EnumActionResult.FAIL, stack);
				ItemStack shaderItem = new ItemStack(IEContent.itemShader);
				ItemNBTHelper.setString(shaderItem, "shader_name", shader);
				if(ShaderRegistry.sortedRarityMap.indexOf(ShaderRegistry.shaderRegistry.get(shader).getRarity())<=ShaderRegistry.sortedRarityMap.indexOf(EnumRarity.EPIC) && ShaderRegistry.sortedRarityMap.indexOf(stack.func_77953_t())>=ShaderRegistry.sortedRarityMap.indexOf(EnumRarity.COMMON))
					Utils.unlockIEAdvancement(player, "main/secret_luckofthedraw");
				stack.func_190918_g(1);
				if(stack.func_190916_E()<=0)
					return new ActionResult(EnumActionResult.SUCCESS, shaderItem);
				if(!player.field_71071_by.func_70441_a(shaderItem))
					player.func_146097_a(shaderItem, false, true);
			}
		return new ActionResult(EnumActionResult.PASS, stack);
	}
}
