/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper_Item;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler.IZoomTool;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IIEEnergyItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms.TransformType;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class ItemRailgun extends ItemUpgradeableTool implements IIEEnergyItem, IZoomTool, ITool, IOBJModelCallback<ItemStack>
{
	public ItemRailgun()
	{
		super("railgun", 1, "RAILGUN");
	}

	@Override
	public int getSlotCount(ItemStack stack)
	{
		return 2+1;
	}
	@Override
	public Slot[] getWorkbenchSlots(Container container, ItemStack stack)
	{
		IItemHandler inv = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
		return new Slot[]
				{
						new IESlot.Upgrades(container, inv,0, 80,32, "RAILGUN", stack, true),
						new IESlot.Upgrades(container, inv,1,100,32, "RAILGUN", stack, true)
				};
	}
	@Override
	public boolean canModify(ItemStack stack)
	{
		return true;
	}
	@Override
	public void recalculateUpgrades(ItemStack stack)
	{
		super.recalculateUpgrades(stack);
		if(this.getEnergyStored(stack)>this.getMaxEnergyStored(stack))
			ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
	}
	@Override
	public void clearUpgrades(ItemStack stack)
	{
		super.clearUpgrades(stack);
		if(this.getEnergyStored(stack)>this.getMaxEnergyStored(stack))
			ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
	}

	@Override
	public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged)
	{
		if(slotChanged)
			return true;
		if(oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY,null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY,null))
		{
			ShaderWrapper wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY,null);
			ShaderWrapper wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY,null);
			if(!ItemStack.func_77989_b(wrapperOld.getShaderItem(), wrapperNew.getShaderItem()))
				return true;
		}
		return super.shouldCauseReequipAnimation(oldStack,newStack,slotChanged);
	}

	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt)
	{
		if (!stack.func_190926_b())
			return new IEItemStackHandler(stack)
			{
				final EnergyHelper.ItemEnergyStorage energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
				final ShaderWrapper_Item shaders = new ShaderWrapper_Item("immersiveengineering:railgun", stack);

				@Override
				public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing)
				{
					return capability == CapabilityEnergy.ENERGY ||
							capability == CapabilityShader.SHADER_CAPABILITY ||
							super.hasCapability(capability, facing);
				}

				@Override
				public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing)
				{
					if (capability == CapabilityEnergy.ENERGY)
						return (T) energyStorage;
					if (capability == CapabilityShader.SHADER_CAPABILITY)
						return (T) shaders;
					return super.getCapability(capability, facing);
				}
			};
		return null;
	}

	@Override
	public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag)
	{
		String stored = this.getEnergyStored(stack)+"/"+this.getMaxEnergyStored(stack);
		list.add(I18n.func_135052_a(Lib.DESC+"info.energyStored", stored));
	}
	@Override
	public String func_77667_c(ItemStack stack)
	{
		//		if(stack.getItemDamage()!=1)
		//		{
		//			String tag = getRevolverDisplayTag(stack);
		//			if(!tag.isEmpty())
		//				return this.getUnlocalizedName()+"."+tag;
		//		}
		return super.func_77667_c(stack);
	}
	@Override
	public boolean func_77662_d()
	{
		return true;
	}

	//	@Override
	//	public Multimap getAttributeModifiers(ItemStack stack)
	//	{
	//		Multimap multimap = super.getAttributeModifiers(stack);
	//		double melee = getUpgrades(stack).getDouble("melee");
	//		if(melee!=0)
	//			multimap.put(SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), new AttributeModifier(field_111210_e, "Weapon modifier", melee, 0));
	//		double speed = getUpgrades(stack).getDouble("speed");
	//		if(speed!=0)
	//			multimap.put(SharedMonsterAttributes.movementSpeed.getAttributeUnlocalizedName(), new AttributeModifier(field_111210_e, "Weapon modifier", speed, 1));
	//		return multimap;
	//	}

	@Override
	public EnumAction func_77661_b(ItemStack p_77661_1_)
	{
		return EnumAction.NONE;
	}

	@Override
	public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand)
	{
		super.func_77663_a(stack, world, ent, slot, inHand);
		//		if(!world.isRemote && stack.getItemDamage()!=1 && ent!=null && ItemNBTHelper.hasKey(stack, "blocked"))
		//		{
		//			int l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "casings", ent);
		//			if(l==0)
		//				ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderFill", "tile.piston.in",.3f,3, 1,6,1);
		//			l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderFill", ent);
		//			if(l==0)
		//				ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderClose", "fire.ignite",.6f,5, 1,6,1);
		//			l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderClose", ent);
		//			if(l==0)
		//				ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderSpin", "note.hat",.1f,5, 5,8,1);
		//			l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderSpin", ent);
		//			if(l==0)
		//				ItemNBTHelper.remove(stack, "blocked");
		//		}
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand)
	{
		ItemStack stack = player.func_184586_b(hand);
		int energy = IEConfig.Tools.railgun_consumption;
		float energyMod = 1 + this.getUpgrades(stack).func_74760_g("consumption");
		energy = (int)(energy*energyMod);
		if(this.extractEnergy(stack, energy, true)==energy && !findAmmo(player).func_190926_b())
		{
			player.func_184598_c(hand);
			player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, getChargeTime(stack) <= 20 ? IESounds.chargeFast : IESounds.chargeSlow, SoundCategory.PLAYERS, 1.5f, 1f);
			return new ActionResult(EnumActionResult.SUCCESS, stack);
		}
		return new ActionResult<>(EnumActionResult.PASS, stack);
	}
	@Override
	public void onUsingTick(ItemStack stack, EntityLivingBase user, int count)
	{
		int inUse = this.func_77626_a(stack)-count;
		if(inUse>getChargeTime(stack) && inUse%20 == user.func_70681_au().nextInt(20))
			user.field_70170_p.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, IESounds.spark, SoundCategory.PLAYERS, .8f+(.2f*user.func_70681_au().nextFloat()), .5f+(.5f*user.func_70681_au().nextFloat()));
	}
	@Override
	public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft)
	{
		if(user instanceof EntityPlayer)
		{
			int inUse = this.func_77626_a(stack) - timeLeft;
			ItemNBTHelper.remove(stack, "inUse");
			if (inUse < getChargeTime(stack))
				return;
			int energy = IEConfig.Tools.railgun_consumption;
			float energyMod = 1 + this.getUpgrades(stack).func_74760_g("consumption");
			energy = (int) (energy * energyMod);
			if (this.extractEnergy(stack, energy, true) == energy)
			{
				ItemStack ammo = findAmmo((EntityPlayer)user);
				if(!ammo.func_190926_b())
				{
					Vec3d vec = user.func_70040_Z();
					float speed = 20;
					EntityRailgunShot shot = new EntityRailgunShot(user.field_70170_p, user, vec.field_72450_a * speed, vec.field_72448_b * speed, vec.field_72449_c * speed, Utils.copyStackWithAmount(ammo, 1));
					ammo.func_190918_g(1);
					if(ammo.func_190916_E()<=0)
						((EntityPlayer)user).field_71071_by.func_184437_d(ammo);
					user.field_70170_p.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, IESounds.railgunFire, SoundCategory.PLAYERS,1, .5f + (.5f * user.func_70681_au().nextFloat()));
					this.extractEnergy(stack, energy, false);
					if (!world.field_72995_K)
						user.field_70170_p.func_72838_d(shot);
				}
			}
		}
	}

	public static ItemStack findAmmo(EntityPlayer player)
	{
		if(isAmmo(player.func_184586_b(EnumHand.OFF_HAND)))
			return player.func_184586_b(EnumHand.OFF_HAND);
		else if(isAmmo(player.func_184586_b(EnumHand.MAIN_HAND)))
			return player.func_184586_b(EnumHand.MAIN_HAND);
		else
			for(int i=0; i<player.field_71071_by.func_70302_i_(); i++)
			{
				ItemStack itemstack = player.field_71071_by.func_70301_a(i);
				if(isAmmo(itemstack))
					return itemstack;
			}
		return ItemStack.field_190927_a;
	}
	public static boolean isAmmo(ItemStack stack)
	{
		if(stack.func_190926_b())
			return false;
		RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(stack);
		return prop!=null;
	}

	public int getChargeTime(ItemStack railgun)
	{
		return (int)(40/(1+this.getUpgrades(railgun).func_74760_g("speed")));
	}

	@Override
	public int func_77626_a(ItemStack stack)
	{
		return 72000;
	}

	@Override
	public void removeFromWorkbench(EntityPlayer player, ItemStack stack)
	{
//		ToDo: Make an Upgrade Advancement?
//		if(contents[18]!=null&&contents[19]!=null)
//			Utils.unlockIEAdvancement(player, "upgrade_railgun");
	}

	@Override
	public int getMaxEnergyStored(ItemStack container)
	{
		return 1600;
	}


	public String[] compileRender(ItemStack stack)
	{
		HashSet<String> render = new HashSet<String>();
		render.add("frame");
		render.add("barrel");
		render.add("grip");
		render.add("capacitors");
		render.add("sled");
		render.add("wires");
		NBTTagCompound upgrades = this.getUpgrades(stack);
		if(upgrades.func_74769_h("speed")>0)
			render.add("upgrade_speed");
		if(upgrades.func_74767_n("scope"))
			render.add("upgrade_scope");
		return render.toArray(new String[render.size()]);
	}

	@Override
	public boolean canZoom(ItemStack stack, EntityPlayer player)
	{
		return this.getUpgrades(stack).func_74767_n("scope");
	}
	float[] zoomSteps = new float[]{.1f,.15625f,.2f,.25f, .3125f, .4f, .5f,.625f};
	@Override
	public float[] getZoomSteps(ItemStack stack, EntityPlayer player)
	{
		return zoomSteps;
	}

	@Override
	public boolean isTool(ItemStack item)
	{
		return true;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean shouldRenderGroup(ItemStack stack, String group)
	{
		if (group.equals("upgrade_scope"))
			return getUpgrades(stack).func_74767_n("scope");
		if (group.equals("upgrade_speed"))
			return getUpgrades(stack).func_74769_h("speed")>0;
		return true;
	}
	@SideOnly(Side.CLIENT)
	@Override
	public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform)
	{
		//		if(transform.isPresent())
		//		{
		//			NBTTagCompound upgrades = this.getUpgrades(stack);
		//			Matrix4 mat = new Matrix4(transform.get().getMatrix());
		////			mat.translate(.41f,2,0);
		//			return Optional.of(new TRSRTransformation(mat.toMatrix4f()));
		//		}
		return transform;
	}
	@SideOnly(Side.CLIENT)
	@Override
	public Matrix4 handlePerspective(ItemStack stack, TransformType cameraTransformType, Matrix4 perspective, EntityLivingBase entity)
	{
		//		if(stack.)
//		if(ItemNBTHelper.getBoolean(stack, "inUse"))
//		{
//			if (cameraTransformType==TransformType.FIRST_PERSON_RIGHT_HAND)
//				perspective = perspective.translate(-.75, -2, -.5).rotate(Math.toRadians(-78), 0, 0, 1);
//			else
//				perspective = perspective.translate(0, -.5, -.375).rotate(Math.toRadians(8), 0, 1, 0).rotate(Math.toRadians(-12), 1, 0, 0).rotate(Math.toRadians(8), 0, 0, 1);
//		}
		return perspective;
	}
}
