/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

import javax.annotation.Nullable;

public abstract class ItemInternalStorage extends ItemIEBase
{

	public ItemInternalStorage(String name, int stackSize, String... subNames)
	{
		super(name, stackSize, subNames);
	}

	public abstract int getSlotCount(ItemStack stack);

	@Nullable
	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt)
	{
		if (!stack.func_190926_b())
			return new IEItemStackHandler(stack);
		return null;
	}

	public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory)
	{
		IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
		if (handler instanceof IItemHandlerModifiable)
		{
			if (inventory.size()!=handler.getSlots())
				throw new IllegalArgumentException("Parameter inventory has "+inventory.size()+" slots, capability inventory has "+handler.getSlots());
			for (int i = 0; i < handler.getSlots(); i++)
				((IItemHandlerModifiable) handler).setStackInSlot(i, inventory.get(i));
		}
		else
			IELogger.warn("No valid inventory handler found for "+stack);
	}

	public NonNullList<ItemStack> getContainedItems(ItemStack stack)
	{
		IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
		if (handler instanceof IEItemStackHandler)
			return ((IEItemStackHandler)handler).getContainedItems();
		else if (handler != null)
		{
			IELogger.warn("Inefficiently getting contained items. Why does "+stack+" have a non-IE IItemHandler?");
			NonNullList<ItemStack> inv = NonNullList.func_191197_a(handler.getSlots(), ItemStack.field_190927_a);
			for (int i = 0; i < handler.getSlots(); i++)
				inv.set(i, handler.getStackInSlot(i));
			return inv;
		}
		else
			IELogger.info("No valid inventory handler found for "+stack);
		return NonNullList.func_191196_a();
	}

	@Override
	public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected)
	{
		super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
		//Update old inventories to caps
		if (ItemNBTHelper.hasKey(stack, "Inv"))
		{
			NBTTagList list = ItemNBTHelper.getTag(stack).func_150295_c("Inv", 10);
			setContainedItems(stack, Utils.readInventory(list, getSlotCount(stack)));
			ItemNBTHelper.remove(stack, "Inv");
			//Sync the changes
			if (entityIn instanceof EntityPlayerMP && !worldIn.field_72995_K)
				((EntityPlayerMP) entityIn).field_71135_a.func_147359_a(new SPacketSetSlot(-2, itemSlot, stack));
		}
	}
}
