/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemIESeed extends ItemIEBase implements IPlantable
{
    private Block cropBlock;
	public ItemIESeed(Block cropBlock, String... subNames)
	{
		super("seed", 64, subNames);
		this.cropBlock = cropBlock;
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		ItemStack stack = player.func_184586_b(hand);
		if(side != EnumFacing.UP)
			return EnumActionResult.PASS;
		else if (player.func_175151_a(pos, side, stack) && player.func_175151_a(pos.func_177982_a(0,1,0), side, stack))
		{
			IBlockState state = world.func_180495_p(pos);
			if(state.func_177230_c().canSustainPlant(state, world, pos, EnumFacing.UP, this) && world.func_175623_d(pos.func_177982_a(0,1,0)))
			{
				world.func_175656_a(pos.func_177982_a(0,1,0), this.cropBlock.func_176223_P());
				stack.func_190918_g(1);
				return EnumActionResult.SUCCESS;
			}
			else
				return EnumActionResult.PASS;
		}
		else
			return EnumActionResult.PASS;
	}

	@Override
	public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos)
	{
		return ((IPlantable)cropBlock).getPlantType(world, pos);
	}

	@Override
	public IBlockState getPlant(IBlockAccess world, BlockPos pos)
	{
		return cropBlock.func_176223_P();
	}
}
