/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool.ToolConfig.ToolConfigBoolean;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool.ToolConfig.ToolConfigFloat;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.entities.EntityFluorescentTube;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.List;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool.ToolConfig;

public class ItemFluorescentTube extends ItemIEBase implements IConfigurableTool
{

	public ItemFluorescentTube()
	{
		super("fluorescent_tube", 1);
	}
	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		if(side==EnumFacing.UP)
		{
			if(!world.field_72995_K)
			{
				ItemStack stack = player.func_184586_b(hand);
				Vec3d look = player.func_70040_Z();
				float angle = (float) Math.toDegrees(Math.atan2(look.field_72450_a, look.field_72449_c));
				EntityFluorescentTube tube = new EntityFluorescentTube(world, stack.func_77946_l(), angle);
				tube.func_70107_b(pos.func_177958_n()+hitX, pos.func_177956_o()+1.5, pos.func_177952_p()+hitZ);
				world.func_72838_d(tube);
				stack.func_77979_a(1);
				if (stack.func_190916_E()>0)
					player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
				else
					player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
			}
			return EnumActionResult.SUCCESS;
		}
		return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
	}
	public static float[] getRGB(ItemStack s)
	{
		if (ItemNBTHelper.hasKey(s, "rgb"))
		{
			NBTTagCompound nbt = ItemNBTHelper.getTagCompound(s, "rgb");
			return new float[]{nbt.func_74760_g("r"), nbt.func_74760_g("g"), nbt.func_74760_g("b")};
		}
		return new float[]{1, 1, 1};
	}
	public static void setRGB(ItemStack s, float[] rgb)
	{
		NBTTagCompound nbt = new NBTTagCompound();
		nbt.func_74776_a("r", rgb[0]);
		nbt.func_74776_a("g", rgb[1]);
		nbt.func_74776_a("b", rgb[2]);
		ItemNBTHelper.setTagCompound(s, "rgb", nbt);
	}
	@Override
	public boolean canConfigure(ItemStack stack)
	{
		return true;
	}
	@Override
	public ToolConfigBoolean[] getBooleanOptions(ItemStack stack)
	{
		return new ToolConfigBoolean[0];
	}
	@Override
	public ToolConfigFloat[] getFloatOptions(ItemStack stack)
	{
		ToolConfigFloat[] ret = new ToolConfigFloat[3];
		float[] rgb = getRGB(stack);
		ret[0] = new ToolConfigFloat("red", 60, 20, rgb[0]);
		ret[1] = new ToolConfigFloat("green", 60, 40, rgb[1]);
		ret[2] = new ToolConfigFloat("blue", 60, 60, rgb[2]);
		return ret;
	}
	@Override
	public void applyConfigOption(ItemStack stack, String key, Object value)
	{
		int id = key.equals("red")?0:(key.equals("green")?1:2);
		float[] rgb = getRGB(stack);
		rgb[id] = (float) value;
		setRGB(stack, rgb);
	}
	@Override
	public String fomatConfigName(ItemStack stack, ToolConfig config)
	{
		return config.name;
	}
	@Override
	public String fomatConfigDescription(ItemStack stack, ToolConfig config)
	{
		return config.name;
	}
	@SideOnly(Side.CLIENT)
	@Override
	public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag)
	{
		list.add(I18n.func_135052_a(Lib.DESC_INFO+"colour", "#"+hexColorString(stack)));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public FontRenderer getFontRenderer(ItemStack stack)
	{
		return ClientProxy.itemFont;
	}
	@Override
	public boolean hasCustomItemColours()
	{
		return true;
	}
	@Override
	public int getColourForIEItem(ItemStack stack, int pass)
	{
		if(pass==0)
			return getRGBInt(stack);
		return super.getColourForIEItem(stack, pass);
	}
	public static int getRGBInt(ItemStack stack)
	{
		float[] fRGB = getRGB(stack);
		return (((int)(fRGB[0]*255)<<16)+((int)(fRGB[1]*255)<<8)+(int)(fRGB[2]*255));
	}
	public static String hexColorString(ItemStack stack)
	{
		String hexCol = Integer.toHexString(getRGBInt(stack));
		while (hexCol.length()<6)
			hexCol = "0"+hexCol;
		return hexCol;
	}
}
