/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Locale;

public class ItemCoresample extends ItemIEBase
{
	public ItemCoresample()
	{
		super("coresample", 1);
	}
	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag)
	{
		if(ItemNBTHelper.hasKey(stack, "coords"))
		{
			if(ItemNBTHelper.hasKey(stack, "mineral"))
			{
				String mineral = ItemNBTHelper.getString(stack, "mineral");
				String unloc = Lib.DESC_INFO+"mineral."+mineral;
				String loc = I18n.func_135052_a(unloc);
				list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.mineral", (unloc.equals(loc)?mineral:loc)));
			}
			else
				list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.noMineral"));
			int[] coords = ItemNBTHelper.getIntArray(stack, "coords");
			boolean singleplayer = Minecraft.func_71410_x().func_71356_B();
			if (world==null || world.field_73011_w.getDimension()!=0)
			{
				World clientWorld = Minecraft.func_71410_x().field_71441_e;
				if (clientWorld!=null&&clientWorld.field_73011_w.getDimension()==coords[0])
					world = clientWorld;
			}
			String s0 = (coords[1]*16)+", "+(coords[2]*16);
			String s1 = (coords[1]*16+16)+", "+(coords[2]*16+16);
			String s2;
			if(world!=null && world.field_73011_w!=null)
			{
				String name = world.field_73011_w.func_186058_p().func_186065_b();
				if(name.toLowerCase(Locale.ENGLISH).startsWith("the "))
					name = name.substring(4);
				s2 = name;
			}
			else
				s2 = "Dimension "+coords[0];
			list.add(s2);
			list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.pos", s0,s1,""));

			if(ItemNBTHelper.hasKey(stack, "infinite"))
				list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.infinite"));
			else if(ItemNBTHelper.hasKey(stack, "depletion"))
				list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.yield", ExcavatorHandler.mineralVeinCapacity-ItemNBTHelper.getInt(stack, "depletion")));

			boolean hasStamp = ItemNBTHelper.hasKey(stack, "timestamp");
			if(hasStamp && world!=null)
			{
				long timestamp = ItemNBTHelper.getLong(stack, "timestamp");
				long dist = world.func_82737_E()-timestamp;
				if(dist<0)
					list.add("Somehow this sample is dated in the future...are you a time traveller?!");
				else
					list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.timestamp", ClientUtils.fomatTimestamp(dist, ClientUtils.TimestampFormat.DHM)));
			}
			else if (hasStamp)
				list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.timezone"));
			else
				list.add(I18n.func_135052_a(Lib.CHAT_INFO+"coresample.noTimestamp"));
		}
	}


	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		ItemStack stack = player.func_184586_b(hand);
		if(player.func_70093_af())
		{
			IBlockState state = world.func_180495_p(pos);
			Block block = state.func_177230_c();
			if(!block.func_176200_f(world, pos))
				pos = pos.func_177972_a(side);

			if(!stack.func_190926_b() && player.func_175151_a(pos, side, stack) && world.func_190527_a(IEContent.blockStoneDevice, pos, false, side, null))
			{
				IBlockState toolbox = IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CORESAMPLE.getMeta());
				if(world.func_180501_a(pos, toolbox, 3))
				{
					IEContent.blockStoneDevice.onIEBlockPlacedBy(world, pos, toolbox, side, hitX,hitY,hitZ, player, stack);
					SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, player);
					world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
					stack.func_190918_g(1);
				}
				return EnumActionResult.SUCCESS;
			}
			else
				return EnumActionResult.FAIL;
		}
		return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
	}

}
