/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryTile implements IInventory
{
	TileEntity tile;
	IIEInventory inv;
	String name;

	public InventoryTile(TileEntity tile)
	{
		this.tile = tile;
		this.inv = (IIEInventory)tile;
		this.name = tile.getClass().getName();
		this.name = "IE"+(name.substring(name.lastIndexOf("TileEntity")+"TileEntity".length()));
	}

	@Override
	public String func_70005_c_()
	{
		return this.name;
	}

	@Override
	public boolean func_145818_k_()
	{
		return false;
	}
	@Override
	public ITextComponent func_145748_c_()
	{
		return new TextComponentString(this.name);
	}

	@Override
	public int func_70302_i_()
	{
		return inv.getInventory().size();
	}

	@Override
	public boolean func_191420_l() {
		for (ItemStack stack : inv.getInventory()) {
			if (!stack.func_190926_b()) {
				return false;
			}
		}
		return true;
	}

	@Override
	public ItemStack func_70301_a(int index)
	{
		return inv.getInventory().get(index);
	}

	@Override
	public ItemStack func_70298_a(int index, int count)
	{
		ItemStack stack = inv.getInventory().get(index);
		if(!stack.func_190926_b())
			if(stack.func_190916_E()<=count)
				inv.getInventory().set(index, ItemStack.field_190927_a);
			else
			{
				stack = stack.func_77979_a(count);
				if(stack.func_190916_E()==0)
					inv.getInventory().set(index, ItemStack.field_190927_a);
			}
		return stack;
	}

	@Override
	public ItemStack func_70304_b(int index)
	{
		ItemStack ret = inv.getInventory().get(index).func_77946_l();
		inv.getInventory().set(index, ItemStack.field_190927_a);
		return ret;
	}

	@Override
	public void func_70299_a(int index, ItemStack stack)
	{
		inv.getInventory().set(index, stack);
	}

	@Override
	public int func_70297_j_()
	{
		return 64;
	}

	@Override
	public void func_70296_d()
	{
		tile.func_70296_d();
	}

	@Override
	public boolean func_70300_a(EntityPlayer player)
	{
		return !tile.func_145837_r() && tile.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v)<64;
	}

	@Override
	public void func_174889_b(EntityPlayer player)
	{
	}

	@Override
	public void func_174886_c(EntityPlayer player)
	{
		for(int i=0; i<func_70302_i_(); i++)
			inv.doGraphicalUpdates(i);
	}

	@Override
	public boolean func_94041_b(int index, ItemStack stack)
	{
		return inv.isStackValid(index, stack);
	}

	@Override
	public int func_174887_a_(int id)
	{
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value)
	{
	}

	@Override
	public int func_174890_g()
	{
		return 0;
	}

	@Override
	public void func_174888_l()
	{
		for(int i=0; i<inv.getInventory().size(); i++)
			inv.getInventory().set(i, ItemStack.field_190927_a);
	}

}
