/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

import javax.annotation.Nonnull;

public class InventoryShader implements IInventory
{
	private ShaderWrapper wrapper;
	private Container container;
	@Nonnull
	public ItemStack shader;
	private String name;

	public InventoryShader(Container par1Container, ShaderWrapper wrapper)
	{
		this.container = par1Container;
		this.wrapper = wrapper;
		this.shader = wrapper.getShaderItem();
		this.name = wrapper.getShaderType();
	}


	@Override
	public int func_70302_i_()
	{
		return 1;
	}

	@Override
	public boolean func_191420_l() {
		return this.shader.func_190926_b();
	}

	@Override
	public ItemStack func_70301_a(int i)
	{
		return this.shader;
	}

	@Override
	public ItemStack func_70304_b(int i)
	{
		if(!this.shader.func_190926_b())
		{
			ItemStack itemstack = this.shader.func_77946_l();
			this.shader = ItemStack.field_190927_a;
			return itemstack;
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70298_a(int i, int j)
	{
		if(!this.shader.func_190926_b())
		{
			ItemStack itemstack;
			if(shader.func_190916_E()<=j)
			{
				itemstack = this.shader.func_77946_l();
				this.shader = ItemStack.field_190927_a;
				this.func_70296_d();
				this.container.func_75130_a(this);
				return itemstack;
			}
			itemstack = this.shader.func_77979_a(j);

			if(shader.func_190916_E()==0)
				this.shader = ItemStack.field_190927_a;
			this.container.func_75130_a(this);
			return itemstack;
		}
		return ItemStack.field_190927_a;
	}


	@Override
	public void func_70299_a(int i, ItemStack stack)
	{
		this.shader = stack;
		if(!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_())
			stack.func_190920_e(this.func_70297_j_());
		this.container.func_75130_a(this);
	}

	@Override
	public String func_70005_c_()
	{
		return "container."+name;
	}
	@Override
	public boolean func_145818_k_()
	{
		return false;
	}
	@Override
	public ITextComponent func_145748_c_()
	{
		return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_());
	}

	@Override
	public int func_70297_j_()
	{
		return 64;
	}

	@Override
	public void func_70296_d()
	{
		if(wrapper!=null)
			wrapper.setShaderItem(shader);
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer) {
		return true;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {}

	@Override
	public void func_174886_c(EntityPlayer player) {}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack) {
		return true;
	}


	@Override
	public int func_174887_a_(int id)
	{
		return 0;
	}
	@Override
	public void func_174885_b(int id, int value)
	{
	}
	@Override
	public int func_174890_g()
	{
		return 0;
	}
	@Override
	public void func_174888_l()
	{
	}
}
