/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.*;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.oredict.OreDictionary;

import javax.annotation.Nonnull;

public abstract class IESlot extends Slot
{
	final Container container;
	public IESlot(Container container, IInventory inv, int id, int x, int y)
	{
		super(inv, id, x, y);
		this.container=container;
	}

	@Override
	public boolean func_75214_a(ItemStack itemStack)
	{
		return true;
	}

	public static class Output extends IESlot
	{
		public Output(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return false;
		}
	}
	public static class FluidContainer extends IESlot
	{
		boolean empty;
		public FluidContainer(Container container, IInventory inv, int id, int x, int y, boolean empty)
		{
			super(container, inv, id, x, y);
			this.empty=empty;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			IFluidHandler handler = FluidUtil.getFluidHandler(itemStack);
			if(handler == null || handler.getTankProperties() == null)
				return false;
			IFluidTankProperties[] tank = handler.getTankProperties();
			if(tank == null || tank.length < 1 || tank[0] == null)
				return false;
			if(empty)
				return tank[0].getContents() == null;
			else
				return tank[0].getContents() != null;
		}
	}
	public static class BlastFuel extends IESlot
	{
		public BlastFuel(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return BlastFurnaceRecipe.isValidBlastFuel(itemStack);
		}
	}
	public static class Bullet extends SlotItemHandler
	{
		int limit;
		public Bullet(IItemHandler inv, int id, int x, int y, int limit)
		{
			super(inv, id, x, y);
			this.limit=limit;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBullet;
		}
		@Override
		public int func_75219_a()
		{
			return limit;
		}

		@Override
		public int func_178170_b(@Nonnull ItemStack stack)
		{
			return limit;
		}
	}
	public static class DrillHead extends SlotItemHandler
	{
		public DrillHead(IItemHandler inv, int id, int x, int y)
		{
			super(inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IDrillHead;
		}
		@Override
		public int func_75219_a()
		{
			return 1;
		}
	}
	public static class Upgrades extends SlotItemHandler
	{
		ItemStack upgradeableTool;
		String type;
		boolean preventDoubles;
		Container container;
		public Upgrades(Container container, IItemHandler inv, int id, int x, int y, String type, ItemStack upgradeableTool, boolean preventDoubles)
		{
			super(inv, id, x, y);
			this.container = container;
			this.type = type;
			this.upgradeableTool = upgradeableTool;
			this.preventDoubles = preventDoubles;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			if(preventDoubles)
				for(Slot slot : container.field_75151_b)
					if(slot instanceof Upgrades && ((Upgrades)slot).preventDoubles && OreDictionary.itemMatches(slot.func_75211_c(), itemStack, true))
						return false;
			return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IUpgrade && ((IUpgrade)itemStack.func_77973_b()).getUpgradeTypes(itemStack).contains(type) && ((IUpgrade)itemStack.func_77973_b()).canApplyUpgrades(upgradeableTool, itemStack);
		}
		@Override
		public int func_75219_a()
		{
			return 64;
		}

		@Override
		public void func_75218_e()
		{
			((IUpgradeableTool)upgradeableTool.func_77973_b()).recalculateUpgrades(upgradeableTool);
		}
	}
	public static class Shader extends IESlot
	{
		ItemStack tool;
		public Shader(Container container, IInventory inv, int id, int x, int y, ItemStack tool)
		{
			super(container, inv, id, x, y);
			this.tool = tool;
			if(FMLCommonHandler.instance().getEffectiveSide()==Side.CLIENT)
				this.setBackgroundName("immersiveengineering:items/shader_slot");
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			if(itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IShaderItem) || tool.func_190926_b() || !tool.hasCapability(CapabilityShader.SHADER_CAPABILITY,null))
				return false;
			ShaderWrapper wrapper = tool.getCapability(CapabilityShader.SHADER_CAPABILITY,null);
			if(wrapper==null)
				return false;
			return ((IShaderItem)itemStack.func_77973_b()).getShaderCase(itemStack, tool, wrapper.getShaderType())!=null;
		}
		@Override
		public int func_75219_a()
		{
			return 1;
		}
	}
	public static class UpgradeableItem extends IESlot
	{
		int size;
		public UpgradeableItem(Container container, IInventory inv, int id, int x, int y, int size)
		{
			super(container, inv, id, x, y);
			this.size = size;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			if(itemStack.func_190926_b())
				return false;
			if(itemStack.func_77973_b() instanceof IUpgradeableTool)
				return ((IUpgradeableTool)itemStack.func_77973_b()).canModify(itemStack);
			if(itemStack.func_77973_b() instanceof IConfigurableTool)
				return ((IConfigurableTool)itemStack.func_77973_b()).canConfigure(itemStack);
			return false;
		}
		@Override
		public int func_75219_a()
		{
			return size;
		}
		@Override
		public void func_75218_e()
		{
			super.func_75218_e();
			if(container instanceof ContainerModWorkbench)
				((ContainerModWorkbench)container).rebindSlots();
		}
		@Override
		public boolean func_82869_a(EntityPlayer player)
		{
			return !(!this.func_75211_c().func_190926_b() && func_75211_c().func_77973_b() instanceof IUpgradeableTool && !((IUpgradeableTool) func_75211_c().func_77973_b()).canTakeFromWorkbench(func_75211_c()));
		}
		@Override
		public ItemStack func_190901_a(EntityPlayer player, ItemStack stack)
		{
			ItemStack result = super.func_190901_a(player, stack);
			if (!stack.func_190926_b() && stack.func_77973_b() instanceof IUpgradeableTool)
				((IUpgradeableTool) stack.func_77973_b()).removeFromWorkbench(player, stack);
			IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
			if (handler instanceof IEItemStackHandler)
				((IEItemStackHandler) handler).setTile(null);
			return result;
		}
	}
	public static class AutoBlueprint extends IESlot
	{
		public AutoBlueprint(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemEngineersBlueprint;
		}
		@Override
		public int func_75219_a()
		{
			return 1;
		}
		@Override
		public void func_75218_e()
		{
			super.func_75218_e();
			if(container instanceof ContainerAutoWorkbench)
				ImmersiveEngineering.proxy.reInitGui();
//				((ContainerAutoWorkbench)container).rebindSlots();
		}
	}
	public static class Ghost extends IESlot
	{
		public Ghost(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}

		@Override
		public void func_75215_d(ItemStack itemStack)
		{
			super.func_75215_d(itemStack);
		}
		@Override
		public boolean func_82869_a(EntityPlayer player)
		{
			return false;
		}
		@Override
		public int func_75219_a()
		{
			return 1;
		}
	}
	public static class ItemDisplay extends IESlot
	{
		public ItemDisplay(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return false;
		}
		@Override
		public boolean func_82869_a(EntityPlayer player)
		{
			return false;
		}
	}

	public static class BlueprintInput extends SlotItemHandler
	{
		ItemStack upgradeableTool;
		Container container;
		public BlueprintInput(Container container, IItemHandler inv, int id, int x, int y, ItemStack upgradeableTool)
		{
			super(inv, id, x, y);
			this.upgradeableTool = upgradeableTool;
		}
		@Override
		public void func_75218_e()
		{
			if(!upgradeableTool.func_190926_b() && upgradeableTool.func_77973_b() instanceof ItemEngineersBlueprint)
				((ItemEngineersBlueprint)upgradeableTool.func_77973_b()).updateOutputs(upgradeableTool);
			if(container instanceof ContainerModWorkbench)
				((ContainerModWorkbench)container).rebindSlots();
			super.func_75218_e();
		}
		@Override
		public int func_75219_a()
		{
			return 64;
		}
	}
	public static class BlueprintOutput extends SlotItemHandler
	{
		public BlueprintCraftingRecipe recipe;
		ItemStack upgradeableTool;
		Container container;
		public BlueprintOutput(Container container, IItemHandler inv, int id, int x, int y, ItemStack upgradeableTool, BlueprintCraftingRecipe recipe)
		{
			super(inv, id, x, y);
			this.container = container;
			this.upgradeableTool = upgradeableTool;
			this.recipe = recipe;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return false;
		}


		@Override
		@SideOnly(Side.CLIENT)
		public boolean func_111238_b()
		{
			return this.func_75216_d();
		}

		@Override
		public ItemStack func_190901_a(EntityPlayer player, ItemStack stack)
		{
			if(!upgradeableTool.func_190926_b() && upgradeableTool.func_77973_b() instanceof ItemEngineersBlueprint)
			{
				((ItemEngineersBlueprint)upgradeableTool.func_77973_b()).reduceInputs(recipe, upgradeableTool, stack, this.container);
				((ItemEngineersBlueprint)upgradeableTool.func_77973_b()).updateOutputs(upgradeableTool);
			}
			this.field_75224_c.func_70296_d();
			return super.func_190901_a(player, stack);
		}
	}

	public static class ArcInput extends IESlot
	{
		public ArcInput(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && ArcFurnaceRecipe.isValidRecipeInput(itemStack);
		}
	}
	public static class ArcAdditive extends IESlot
	{
		public ArcAdditive(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && ArcFurnaceRecipe.isValidRecipeAdditive(itemStack);
		}
	}
	public static class ArcElectrode extends IESlot
	{
		public ArcElectrode(Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
		}

		@Override
		public int func_75219_a()
		{
			return 1;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && IEContent.itemGraphiteElectrode.equals(itemStack.func_77973_b());
		}
	}

	public static class Belljar extends IESlot
	{
		int type = 0;
		public Belljar(int type, Container container, IInventory inv, int id, int x, int y)
		{
			super(container, inv, id, x, y);
			this.type = type;
		}

		@Override
		public int func_75219_a()
		{
			return type<2?1:64;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			return !itemStack.func_190926_b() && (type==1?BelljarHandler.getHandler(itemStack)!=null: type!=2||BelljarHandler.getItemFertilizerHandler(itemStack)!=null);
		}
	}

	public static class ContainerCallback extends SlotItemHandler
	{
		Container container;
		public ContainerCallback(Container container, IItemHandler inv, int id, int x, int y)
		{
			super(inv, id, x, y);
			this.container = container;
		}
		@Override
		public boolean func_75214_a(ItemStack itemStack)
		{
			if(this.container instanceof ICallbackContainer)
				return ((ICallbackContainer)this.container).canInsert(itemStack, field_75222_d, this);
			return true;
		}
		@Override
		public boolean func_82869_a(EntityPlayer player)
		{
			if(this.container instanceof ICallbackContainer)
				return ((ICallbackContainer)this.container).canTake(this.func_75211_c(), field_75222_d, this);
			return true;
		}
	}
	public interface ICallbackContainer
	{
		boolean canInsert(ItemStack stack, int slotNumer, Slot slotObject);
		boolean canTake(ItemStack stack, int slotNumer, Slot slotObject);
	}
}
