/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.wooden.TileEntitySorter;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerSorter extends Container
{
	TileEntitySorter tile;
	int slotCount;
	public ContainerSorter(InventoryPlayer inventoryPlayer, TileEntitySorter tile)
	{
		this.tile=tile;
		for(int side=0; side<6; side++)
			for(int i=0; i<TileEntitySorter.filterSlotsPerSide; i++)
			{
				int x = 4+ (side/2)*58 + (i<3?i*18: i>4?(i-5)*18: i==3?0: 36);
				int y = 22+ (side%2)*76 + (i<3?0: i>4?36: 18);
				int id = side*TileEntitySorter.filterSlotsPerSide+i;
				this.func_75146_a(new IESlot.Ghost(this, tile.filter, id, x, y));
			}
		slotCount=6*TileEntitySorter.filterSlotsPerSide;

		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 9; j++)
				func_75146_a(new Slot(inventoryPlayer, j+i*9+9, 8+j*18, 163+i*18));
		for (int i = 0; i < 9; i++)
			func_75146_a(new Slot(inventoryPlayer, i, 8+i*18, 221));
	}

	@Override
	public boolean func_75145_c(EntityPlayer player)
	{
	     return tile!=null && tile.func_145831_w().func_175625_s(tile.func_174877_v())==tile && player.func_70092_e(tile.func_174877_v().func_177958_n()+.5, tile.func_174877_v().func_177956_o()+.5, tile.func_174877_v().func_177952_p()+.5)<=64;
	}

	@Override
	public ItemStack func_184996_a(int id, int button, ClickType modifier, EntityPlayer player)
	{
		Slot slot = id<0?null: this.field_75151_b.get(id);
		if(!(slot instanceof IESlot.Ghost))
			return super.func_184996_a(id, button, modifier, player);

		ItemStack stack = ItemStack.field_190927_a;
		ItemStack stackSlot = slot.func_75211_c();
		if(!stackSlot.func_190926_b())
			stack = stackSlot.func_77946_l();

		if (button==2)
			slot.func_75215_d(ItemStack.field_190927_a);
		else if(button==0||button==1)
		{
			InventoryPlayer playerInv = player.field_71071_by;
			ItemStack stackHeld = playerInv.func_70445_o();
			if (stackSlot.func_190926_b())
			{
				if(!stackHeld.func_190926_b() && slot.func_75214_a(stackHeld))
				{
					slot.func_75215_d(Utils.copyStackWithAmount(stackHeld, 1));
				}
			}
			else if (stackHeld.func_190926_b())
			{
				slot.func_75215_d(ItemStack.field_190927_a);
			}
			else if (slot.func_75214_a(stackHeld))
			{
				slot.func_75215_d(Utils.copyStackWithAmount(stackHeld, 1));
			}
		}
		else if (button == 5)
		{
			InventoryPlayer playerInv = player.field_71071_by;
			ItemStack stackHeld = playerInv.func_70445_o();
			if (!slot.func_75216_d())
			{
				slot.func_75215_d(Utils.copyStackWithAmount(stackHeld, 1));
			}
		}
		return stack;
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slot)
	{
		return ItemStack.field_190927_a;
		//		ItemStack stack = null;
		//		Slot slotObject = (Slot) inventorySlots.get(slot);
		//
		//		if (slotObject != null && slotObject.getHasStack())
		//		{
		//			ItemStack stackInSlot = slotObject.getStack();
		//			stack = stackInSlot.copy();
		//
		//			if (slot < slotCount)
		//			{
		//				if(!this.mergeItemStack(stackInSlot, slotCount, (slotCount + 36), true))
		//					return null;
		//			}
		//			else
		//			{
		//				if(!this.mergeItemStack(stackInSlot, 0,9, false))
		//					return null;
		//			}
		//
		//			if (stackInSlot.stackSize == 0)
		//				slotObject.putStack(null);
		//			else
		//				slotObject.onSlotChanged();
		//
		//			if (stackInSlot.stackSize == stack.stackSize)
		//				return null;
		//			slotObject.onTake(player, stackInSlot);
		//		}
		//		return stack;
	}
}
