/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces.IBulletContainer;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ContainerRevolver extends ContainerInternalStorageItem
{
	public static int[][][] slotPositions = {
			{
					{ 48, 11},
					{ 56, 30}
			},
			{
					{ 48, 11},
					{ 68,  3},
					{ 78, 22},
					{ 88,  3},
					{ 98, 22},
					{108,  3},
					{118, 22},
					{ 56, 30}
			},
			{
					{ 48,  3},
					{ 67,  3},
					{ 86,  3},
					{105,  3},
					{124, 11},
					{132, 30},
					{124, 49},
					{105, 57},
					{ 86, 49},
					{ 86, 30},
					{ 67, 30},
					{ 48, 30},
			}
	};

	private EntityEquipmentSlot secondHand;
	public ItemStack secondRevolver;//NonNull after addSlots is called in the super constructor
	private int offset = 0;

	public ContainerRevolver(InventoryPlayer iinventory, World world, EntityEquipmentSlot slot, ItemStack revolver)
	{
		super(iinventory, world, slot, revolver);
	}

	@Override
	int addSlots(InventoryPlayer iinventory)
	{
		if(this.equipmentSlot==EntityEquipmentSlot.MAINHAND||this.equipmentSlot==EntityEquipmentSlot.OFFHAND)
		{
			int bullets0 = ((IBulletContainer)(heldItem).func_77973_b()).getBulletCount(heldItem);

			this.secondHand = this.equipmentSlot==EntityEquipmentSlot.MAINHAND?EntityEquipmentSlot.OFFHAND:EntityEquipmentSlot.MAINHAND;
			this.secondRevolver = iinventory.field_70458_d.func_184582_a(this.secondHand);
			if(!secondRevolver.func_190926_b() && secondRevolver.func_77973_b() instanceof IBulletContainer)
			{
				int bullets1 = ((IBulletContainer)secondRevolver.func_77973_b()).getBulletCount(secondRevolver);
				this.offset = ((bullets0>=18?150:bullets0>8?136:74)+(bullets1>=18?150:bullets1>8?136:74)+4-176)/2;
			}
			else
			{
				this.secondRevolver = ItemStack.field_190927_a;
				this.secondHand = null;
				this.offset = ((bullets0>=18?150:bullets0>8?136:74)-176)/2;
			}
		}

		int total = 0;
		int off = (offset<0?-offset:0);
		for(int hand = 0; hand<(this.secondHand!=null?2:1); hand++)
		{
			int i = 0;
			ItemStack held = this.secondHand==null?heldItem: (hand==0)==(player.func_184591_cq()==EnumHandSide.RIGHT)?secondRevolver:heldItem;
			IItemHandler secondRevolverInventory = secondRevolver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
			IItemHandler inv = this.secondHand==null?this.inv: (hand==0)==(player.func_184591_cq()==EnumHandSide.RIGHT)?secondRevolverInventory:this.inv;
			int revolverSlots = ((IBulletContainer)(held).func_77973_b()).getBulletCount(held);

			if (inv instanceof IEItemStackHandler)
				((IEItemStackHandler) inv).setInventoryForUpdate(iinventory);
			this.func_75146_a(new IESlot.Bullet(inv, i++, off+29, 3, 1));
			int slots = revolverSlots >= 18?2: revolverSlots > 8?1: 0;
			for(int[] slot : slotPositions[slots])
				this.func_75146_a(new IESlot.Bullet(inv, i++, off+slot[0], slot[1], 1));
			this.func_75146_a(new IESlot.Bullet(inv, i++,off+48, 49, 1));
			this.func_75146_a(new IESlot.Bullet(inv, i++,off+29, 57, 1));
			this.func_75146_a(new IESlot.Bullet(inv, i++,off+10, 49, 1));
			this.func_75146_a(new IESlot.Bullet(inv, i++,off+2, 30, 1));
			this.func_75146_a(new IESlot.Bullet(inv, i++,off+10, 11, 1));
			off += (revolverSlots>=18?150: revolverSlots>8?136: 74)+4;
			total += i;
		}

		this.bindPlayerInventory(iinventory);
		return total;
	}
	protected void bindPlayerInventory(InventoryPlayer inventoryPlayer)
	{
		int off = (offset>0?offset:0);
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 9; j++)
				this.func_75146_a(new Slot(inventoryPlayer, j+i*9+9, off+8+j*18, 85+i*18));

		for (int i = 0; i < 9; i++)
			this.func_75146_a(new Slot(inventoryPlayer, i, off+8+i*18, 143));
	}


	@Override
	protected boolean allowShiftclicking()
	{
		return false;
	}


	@Override
	protected void updatePlayerItem()
	{
		super.updatePlayerItem();
		/*if(this.secondRevolver!=null)
		{
			((IInternalStorageItem)this.secondRevolver.getItem()).setContainedItems(this.secondRevolver, this.secondRevolverInventory.stackList);
			ItemStack hand = player.getItemStackFromSlot(this.secondHand);
			if(!hand.isEmpty()&&!hand.equals(secondRevolver))
				player.setItemStackToSlot(this.secondHand, this.secondRevolver);
		}*/
	}

	@Override
	public void func_75134_a(EntityPlayer par1EntityPlayer)
	{
		super.func_75134_a(par1EntityPlayer);

		for(int hand = 0; hand<(this.secondHand!=null?2:1); hand++)
		{
			IItemHandler secondRevolverInventory = secondRevolver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
			IItemHandler inv = this.secondHand == null ? this.inv : (hand == 0) == (player.func_184591_cq() == EnumHandSide.RIGHT) ? secondRevolverInventory : this.inv;
			if (inv instanceof IEItemStackHandler)
				((IEItemStackHandler) inv).setInventoryForUpdate(null);
		}
	}
}
