/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ContainerModWorkbench extends ContainerIEBase<TileEntityModWorkbench>
{
	public InventoryShader shaderInv;
	public InventoryPlayer inventoryPlayer;

	public ContainerModWorkbench(InventoryPlayer inventoryPlayer, TileEntityModWorkbench tile)
	{
		super(inventoryPlayer, tile);

		this.inventoryPlayer = inventoryPlayer;
		rebindSlots();
	}

	private void bindPlayerInv(InventoryPlayer inventoryPlayer)
	{
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 9; j++)
				func_75146_a(new Slot(inventoryPlayer, j+i*9+9, 8+j*18, 87+i*18));
		for (int i = 0; i < 9; i++)
			func_75146_a(new Slot(inventoryPlayer, i, 8+i*18, 145));
	}

	public void rebindSlots()
	{
		//Don't rebind if the tool didn't change
		if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT)
			for (Slot slot:field_75151_b)
				if (slot instanceof IESlot.Upgrades)
					if (ItemStack.func_179545_c(((IESlot.Upgrades) slot).upgradeableTool, inv.func_70301_a(0)))
						return;
		this.field_75151_b.clear();
		this.field_75153_a.clear();
		this.func_75146_a(new IESlot.UpgradeableItem(this, this.inv, 0, 24, 22, 1));
		slotCount = 1;

		ItemStack tool = this.func_75139_a(0).func_75211_c();
		if (tool.func_77973_b() instanceof IUpgradeableTool)
		{
			if (tool.func_77973_b() instanceof ItemEngineersBlueprint)
				((ItemEngineersBlueprint) tool.func_77973_b()).updateOutputs(tool);
			IItemHandler handler = tool.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
			if (handler instanceof IEItemStackHandler)
				((IEItemStackHandler) handler).setTile(tile);
			Slot[] slots = ((IUpgradeableTool) tool.func_77973_b()).getWorkbenchSlots(this, tool);
			if (slots != null)
				for (Slot s : slots)
				{
					this.func_75146_a(s);
					slotCount++;
				}
		}
		if (tool.hasCapability(CapabilityShader.SHADER_CAPABILITY, null))
		{
			ShaderWrapper wrapper = tool.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
			if (wrapper != null)
			{
				this.shaderInv = new InventoryShader(this, wrapper);
				this.func_75146_a(new IESlot.Shader(this, shaderInv, 0, 130, 32, tool));
				slotCount++;
				this.shaderInv.shader = wrapper.getShaderItem();
			}
		}
		bindPlayerInv(inventoryPlayer);
		ImmersiveEngineering.proxy.reInitGui();
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slot)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot slotObject = field_75151_b.get(slot);

		if (slotObject != null && slotObject.func_75216_d())
		{
			ItemStack stackInSlot = slotObject.func_75211_c();
			stack = stackInSlot.func_77946_l();

			if (slot < slotCount)
			{
				if(!this.func_75135_a(stackInSlot, slotCount, (slotCount + 36), true))
					return ItemStack.field_190927_a;
			}
			else if(!stackInSlot.func_190926_b())
			{
				if(stackInSlot.func_77973_b() instanceof IUpgradeableTool && ((IUpgradeableTool)stackInSlot.func_77973_b()).canModify(stackInSlot))
				{
					if(!this.func_75135_a(stackInSlot, 0, 1, true))
						return ItemStack.field_190927_a;
				}
				else if(stackInSlot.func_77973_b() instanceof IConfigurableTool && ((IConfigurableTool)stackInSlot.func_77973_b()).canConfigure(stackInSlot))
				{
					if(!this.func_75135_a(stackInSlot, 0, 1, true))
						return ItemStack.field_190927_a;
				}
				else if(slotCount>1)
				{
					boolean b = true;
					for(int i=1; i<slotCount; i++)
					{
						Slot s = field_75151_b.get(i);
						if(s!=null && s.func_75214_a(stackInSlot))
							if(this.func_75135_a(stackInSlot, i, i+1, true))
							{
								b = false;
								break;
							}
							else
								continue;
					}
					if(b)
						return ItemStack.field_190927_a;
				}
			}

			if (stackInSlot.func_190916_E() == 0)
				slotObject.func_75215_d(ItemStack.field_190927_a);
			else
				slotObject.func_75218_e();

			if (stackInSlot.func_190916_E() == stack.func_190916_E())
				return ItemStack.field_190927_a;
			slotObject.func_190901_a(player, stack);
		}
		return stack;
	}

	@Override
	public ItemStack func_184996_a(int id, int button, ClickType clickType, EntityPlayer player)
	{
		ItemStack ret = super.func_184996_a(id, button, clickType, player);
		tile.markContainingBlockForUpdate(null);
		if (FMLCommonHandler.instance().getEffectiveSide().isServer())
			func_75142_b();
		return ret;
	}

	@Override
	public void func_75130_a(IInventory p_75130_1_)
	{
		super.func_75130_a(p_75130_1_);
		tile.markContainingBlockForUpdate(null);
	}
}
