/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAutoWorkbench;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAutoWorkbench extends ContainerIEBase<TileEntityAutoWorkbench>
{
	public InventoryPlayer inventoryPlayer;

	public ContainerAutoWorkbench(InventoryPlayer inventoryPlayer, TileEntityAutoWorkbench tile)
	{
		super(inventoryPlayer, tile);

		this.inventoryPlayer = inventoryPlayer;
		this.func_75146_a(new IESlot.AutoBlueprint(this, this.inv, 0, 102, 69));

		for(int i=0; i<16; i++)
			this.func_75146_a(new Slot(this.inv, 1+i, 7+(i%4)*18, 24+(i/4)*18));
		slotCount=17;

		bindPlayerInv(inventoryPlayer);
	}

	private void bindPlayerInv(InventoryPlayer inventoryPlayer)
	{
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 9; j++)
				func_75146_a(new Slot(inventoryPlayer, j+i*9+9, 8+j*18, 103+i*18));
		for (int i = 0; i < 9; i++)
			func_75146_a(new Slot(inventoryPlayer, i, 8+i*18, 161));
	}

//	public void rebindSlots()
//	{
//
//		ImmersiveEngineering.proxy.reInitGui();
//	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slot)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot slotObject = field_75151_b.get(slot);

		if (slotObject != null && slotObject.func_75216_d())
		{
			ItemStack stackInSlot = slotObject.func_75211_c();
			stack = stackInSlot.func_77946_l();

			if (slot < slotCount)
			{
				if(!this.func_75135_a(stackInSlot, slotCount, (slotCount + 36), true))
					return ItemStack.field_190927_a;
			}
			else if(!stackInSlot.func_190926_b())
			{
				if(stackInSlot.func_77973_b() instanceof ItemEngineersBlueprint)
				{
					if(!this.func_75135_a(stackInSlot, 0, 1, true))
						return ItemStack.field_190927_a;
				}
				else
				{
					boolean b = true;
					for(int i=1; i<slotCount; i++)
					{
						Slot s = field_75151_b.get(i);
						if(s!=null && s.func_75214_a(stackInSlot))
							if(this.func_75135_a(stackInSlot, i, i+1, true))
							{
								b = false;
								break;
							}
							else
								continue;
					}
					if(b)
						return ItemStack.field_190927_a;
				}
			}

			if (stackInSlot.func_190916_E() == 0)
				slotObject.func_75215_d(ItemStack.field_190927_a);
			else
				slotObject.func_75218_e();

			if (stackInSlot.func_190916_E() == stack.func_190916_E())
				return ItemStack.field_190927_a;
			slotObject.func_190901_a(player, stack);
		}
		return stack;
	}
	@Override
	public void func_75130_a(IInventory p_75130_1_)
	{
		super.func_75130_a(p_75130_1_);
		tile.markContainingBlockForUpdate(null);
	}
}
