/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAssembler extends ContainerIEBase<TileEntityAssembler>
{
	public ContainerAssembler(InventoryPlayer inventoryPlayer, TileEntityAssembler tile)
	{
		super(inventoryPlayer, tile);
		this.tile=tile;
		for(int i=0; i<tile.patterns.length; i++)
		{
			this.tile.patterns[i].recalculateOutput();
			for(int j=0; j<9; j++)
			{
				int x = 9+ i*58 + (j%3)*18;
				int y = 7+ (j/3)*18;
				this.func_75146_a(new IESlot.Ghost(this, tile.patterns[i], j, x, y));
			}
			this.func_75146_a(new IESlot.Output(this, this.inv, 18+i, 27+i*58, 64));
		}
		for(int i=0; i<18; i++)
			this.func_75146_a(new Slot(this.inv, i, 13+(i%9)*18, 87+(i/9)*18));
		slotCount=21;
		
		for(int i=0; i<3; i++)
			for(int j=0; j<9; j++)
				func_75146_a(new Slot(inventoryPlayer, j+i*9+9, 13+j*18, 137+i*18));
		for(int i=0; i<9; i++)
			func_75146_a(new Slot(inventoryPlayer, i, 13+i*18, 195));
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slot)
	{
		ItemStack stack = ItemStack.field_190927_a;
		Slot slotObject = field_75151_b.get(slot);

		if(slotObject != null && slotObject.func_75216_d() && !(slotObject instanceof IESlot.Ghost))
		{
			ItemStack stackInSlot = slotObject.func_75211_c();
			stack = stackInSlot.func_77946_l();
			if(slot<48)
			{
				if(!this.func_75135_a(stackInSlot, 48,(48+36), true))
					return ItemStack.field_190927_a;
			}
			else
			{
				if(!this.func_75135_a(stackInSlot, 30,48, false))
					return ItemStack.field_190927_a;
			}

			if (stackInSlot.func_190916_E() == 0)
				slotObject.func_75215_d(ItemStack.field_190927_a);
			else
				slotObject.func_75218_e();

			if (stackInSlot.func_190916_E() == stack.func_190916_E())
				return ItemStack.field_190927_a;
			slotObject.func_190901_a(player, stackInSlot);
		}
		return stack;
	}
}
