/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageSkyhookSync;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.List;

public class EntitySkylineHook extends Entity
{
	public Connection connection;
	public BlockPos target;
	public Vec3d[] subPoints;
	public int targetPoint;
	public EntitySkylineHook(World world)
	{
		super(world);
		this.func_70105_a(.125f,.125f);
		//		this.noClip=true;
	}
	public EntitySkylineHook(World world, double x, double y, double z, Connection connection, BlockPos target,
							 Vec3d[] subPoints, int next)
	{
		super(world);
		targetPoint = next;
		//		this.noClip=true;
		this.func_70105_a(0.125F, 0.125F);
		this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
		this.func_70107_b(x, y, z);
		this.connection = connection;
		this.target = target;
		this.subPoints = subPoints;

		float f1 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
		this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0D / Math.PI) + 90.0F;

		for (this.field_70125_A = (float)(Math.atan2((double)f1, this.field_70181_x) * 180.0D / Math.PI) - 90.0F; this.field_70125_A - this.field_70127_C < -180.0F; this.field_70127_C -= 360.0F);

		while (this.field_70125_A - this.field_70127_C >= 180.0F)
			this.field_70127_C += 360.0F;
		while (this.field_70177_z - this.field_70126_B < -180.0F)
			this.field_70126_B -= 360.0F;
		while (this.field_70177_z - this.field_70126_B >= 180.0F)
			this.field_70126_B += 360.0F;
	}
	@Override
	protected void func_70088_a() {}


	@SideOnly(Side.CLIENT)
	@Override
	public boolean func_70112_a(double p_70112_1_)
	{
		double d1 = this.func_174813_aQ().func_72320_b() * 4.0D;
		d1 *= 64.0D;
		return p_70112_1_ < d1 * d1;
	}


	@Override
	public void func_70071_h_()
	{
		EntityPlayer player = null;
//		if(this.getControllingPassenger() instanceof EntityPlayer)
//			player = ((EntityPlayer)this.getControllingPassenger());
		List<Entity> list = this.func_184188_bt();
		if(!list.isEmpty() && list.get(0) instanceof EntityPlayer)
			player = (EntityPlayer)list.get(0);

		if(this.field_70173_aa==1&&!field_70170_p.field_72995_K)
		{
			IELogger.debug("init tick at "+System.currentTimeMillis());
			if(player instanceof EntityPlayerMP)
				ImmersiveEngineering.packetHandler.sendTo(new MessageSkyhookSync(this), (EntityPlayerMP)player);
		}
		super.func_70071_h_();
		//		if(this.ticksExisted>40)
		//			this.setDead();
		//		if(world.isRemote)
		//			return;
		if(subPoints!=null && targetPoint<subPoints.length-1)
		{
			double dist = subPoints[targetPoint].func_72438_d(new Vec3d(field_70165_t,field_70163_u,field_70161_v));
			IELogger.debug("dist: "+dist);
			if(dist<=0)
			{
				this.field_70165_t = subPoints[targetPoint].field_72450_a;
				this.field_70163_u = subPoints[targetPoint].field_72448_b;
				this.field_70161_v = subPoints[targetPoint].field_72449_c;
				targetPoint++;
				if (player instanceof EntityPlayerMP)
					ImmersiveEngineering.packetHandler.sendTo(new MessageSkyhookSync(this), (EntityPlayerMP)player);
				IELogger.debug("next vertex: "+targetPoint);
				return;
			}
			float speed = 2f;
			if(player!=null && !player.func_184607_cu().func_190926_b()&&player.func_184607_cu().func_77973_b() instanceof ItemSkyhook)
				speed = ((ItemSkyhook)player.func_184607_cu().func_77973_b()).getSkylineSpeed(player.func_184607_cu());
			Vec3d moveVec = SkylineHelper.getSubMovementVector(new Vec3d(field_70165_t, field_70163_u, field_70161_v), subPoints[targetPoint], speed);
			field_70159_w = moveVec.field_72450_a;//*speed;
			field_70181_x = moveVec.field_72448_b;//*speed;
			field_70179_y = moveVec.field_72449_c;//*speed;
		}

		if(target!=null&&targetPoint==subPoints.length-1)
		{
			TileEntity end = this.field_70170_p.func_175625_s(target);
			IImmersiveConnectable iicEnd = ApiUtils.toIIC(end, field_70170_p);
			if(iicEnd==null)
			{
				this.func_70106_y();
				return;
			}
			Vec3d vEnd = new Vec3d(target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
			vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));


			double gDist = vEnd.func_72438_d(new Vec3d(field_70165_t, field_70163_u, field_70161_v));
			IELogger.debug("distance to goal: "+gDist);
			if(gDist<=.3)
			{
				reachedTarget(end);
				return;
			}
			else if(gDist>5)
			{
				func_70106_y();
				return;
			}
		}
		this.field_70165_t += this.field_70159_w;
		this.field_70163_u += this.field_70181_x;
		this.field_70161_v += this.field_70179_y;
		float f1 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
		this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0D / Math.PI) + 90.0F;

		for (this.field_70125_A = (float)(Math.atan2((double)f1, this.field_70181_x) * 180.0D / Math.PI) - 90.0F; this.field_70125_A - this.field_70127_C < -180.0F; this.field_70127_C -= 360.0F);

		while (this.field_70125_A - this.field_70127_C >= 180.0F)
			this.field_70127_C += 360.0F;
		while (this.field_70177_z - this.field_70126_B < -180.0F)
			this.field_70126_B -= 360.0F;
		while (this.field_70177_z - this.field_70126_B >= 180.0F)
			this.field_70126_B += 360.0F;

		this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2F;
		this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2F;

		if (this.func_70090_H())
		{
			for (int j = 0; j < 4; ++j)
			{
				float f3 = 0.25F;
				this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
			}
		}

		if(player!=null)
		{
			double dx = this.field_70165_t-this.field_70169_q;
			double dy = this.field_70163_u-this.field_70167_r;
			double dz = this.field_70161_v-this.field_70166_s;
			int distTrvl = Math.round(MathHelper.func_76133_a(dx*dx + dy*dy + dz*dz) * 100.0F);
//			if(distTrvl>0)
//				player.addStat(IEAchievements.statDistanceSkyhook, distTrvl);
			if (!field_70170_p.field_72995_K&&SkylineHelper.isInBlock(player, field_70170_p))
			{
//				setDead();
//				player.setPosition(posX-3*dx, posY-3*dy+getMountedYOffset(),posZ-3*dz);
			}

			//TODO
//			if(player instanceof EntityPlayerMP)
//				if(((EntityPlayerMP)player).getStatFile().func_150870_b(IEAchievements.statDistanceSkyhook)>100000)
//					player.triggerAchievement(IEAchievements.skyhookPro);
		}

		this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
	}

	public void reachedTarget(TileEntity end)
	{
		this.func_70106_y();
		IELogger.debug("last tick at "+System.currentTimeMillis());
		List<Entity> list = this.func_184188_bt();
		if(list.isEmpty() || !(list.get(0) instanceof EntityPlayer))
			return;
//		if(!(this.getControllingPassenger() instanceof EntityPlayer))
//			return;
//		EntityPlayer player = (EntityPlayer)this.getControllingPassenger();
		EntityPlayer player = (EntityPlayer)list.get(0);
		ItemStack hook = player.func_184607_cu();
		if(hook.func_190926_b() || !(hook.func_77973_b() instanceof ItemSkyhook))
			return;
		Connection line = SkylineHelper.getTargetConnection(field_70170_p, player, connection);
		if(line!=null)
		{
			player.func_184598_c(player.func_184600_cs());
//					setItemInUse(hook, hook.getItem().getMaxItemUseDuration(hook));
			SkylineHelper.spawnHook(player, end, line);
			//					ChunkCoordinates cc0 = line.end==target?line.start:line.end;
			//					ChunkCoordinates cc1 = line.end==target?line.end:line.start;
			//					double dx = cc0.posX-cc1.posX;
			//					double dy = cc0.posY-cc1.posY;
			//					double dz = cc0.posZ-cc1.posZ;
			//
			//					EntityZiplineHook zip = new EntityZiplineHook(world, target.posX+.5,target.posY+.5,target.posZ+.5, line, cc0);
			//					zip.motionX = dx*.05f;
			//					zip.motionY = dy*.05f;
			//					zip.motionZ = dz*.05f;
			//					if(!world.isRemote)
			//						world.spawnEntity(zip);
			//					ItemSkyHook.existingHooks.put(this.riddenByEntity.getCommandSenderName(), zip);
			//					this.riddenByEntity.mountEntity(zip);
		}
		else
		{
			player.field_70159_w = field_70159_w;
			player.field_70181_x = field_70181_x;
			player.field_70179_y = field_70179_y;
			IELogger.debug("player motion: "+player.field_70159_w+","+player.field_70181_x+","+player.field_70179_y);
		}
	}

	@Override
	public Vec3d func_70040_Z()
	{
		float f1;
		float f2;
		float f3;
		float f4;

		//		if (1 == 1.0F)
		//		{
		f1 = MathHelper.func_76134_b(-this.field_70177_z * 0.017453292F - (float)Math.PI);
		f2 = MathHelper.func_76126_a(-this.field_70177_z * 0.017453292F - (float)Math.PI);
		f3 = -MathHelper.func_76134_b(-this.field_70125_A * 0.017453292F);
		f4 = MathHelper.func_76126_a(-this.field_70125_A * 0.017453292F);
		return new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
		//		}
		//		else
		//		{
		//			f1 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 1;
		//			f2 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 1;
		//			f3 = MathHelper.cos(-f2 * 0.017453292F - (float)Math.PI);
		//			f4 = MathHelper.sin(-f2 * 0.017453292F - (float)Math.PI);
		//			float f5 = -MathHelper.cos(-f1 * 0.017453292F);
		//			float f6 = MathHelper.sin(-f1 * 0.017453292F);
		//			return Vec3.createVectorHelper((double)(f4 * f5), (double)f6, (double)(f3 * f5));
		//		}
	}

	@Override
	@Nullable
	public Entity func_184179_bs()
	{
		return null;
//		List<Entity> list = this.getPassengers();
//		return list.isEmpty() ? null : (Entity)list.get(0);
	}
	@Override
	public boolean shouldRiderSit()
	{
		return false;
	}

	@Override
	public boolean func_82150_aj()
	{
		return true;	
	}
	@Override
	public boolean func_90999_ad()
	{
		return false;	
	}
	@Override
	public boolean func_96092_aw()
	{
		return false;
	}

	@Override
	public double func_70042_X()
	{
		return -2;
	}

	@Override
	protected void func_70014_b(NBTTagCompound nbt)
	{
	}

	@Override
	protected void func_70037_a(NBTTagCompound nbt)
	{
	}

	@Override
	public float func_70111_Y()
	{
		return 0.0F;
	}
	@Override
	public float func_70013_c()
	{
		return 1.0F;
	}
	@SideOnly(Side.CLIENT)
	@Override
	public int func_70070_b()
	{
		return 15728880;
	}
	@Override
	public boolean func_70067_L()
	{
		return false;
	}
	@Override
	public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_)
	{
		this.func_70106_y();
		return true;
		//		return false;
	}
}
