/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler.IBullet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRevolvershotHoming extends EntityRevolvershot
{
	public int trackCountdown = 5;
	public double redirectionSpeed = .25;
	public EntityLivingBase targetOverride;
	public EntityRevolvershotHoming(World world)
	{
		super(world);
	}

	public EntityRevolvershotHoming(World world, double x, double y, double z, double ax, double ay, double az, IBullet type)
	{
		super(world, x, y, z, ax, ay, az, type);
	}

	public EntityRevolvershotHoming(World world, EntityLivingBase living, double ax, double ay, double az, IBullet type, ItemStack stack)
	{
		super(world, living, ax, ay, az, type, stack);
	}

	@Override
	public void func_70071_h_()
	{
		super.func_70071_h_();

		if(!field_70170_p.field_72995_K && this.field_70173_aa>trackCountdown)
		{
			EntityLivingBase target = getTarget();
			if(target!=null)
			{
				Vec3d newMotion = new Vec3d(
						field_70159_w*(1-redirectionSpeed)+ (target.field_70165_t-this.field_70165_t)*redirectionSpeed,
						field_70181_x*(1-redirectionSpeed)+ ((target.field_70163_u+target.field_70131_O/2)-this.field_70163_u)*redirectionSpeed,
						field_70179_y*(1-redirectionSpeed)+ (target.field_70161_v-this.field_70161_v)*redirectionSpeed).func_72432_b();

				this.field_70159_w = newMotion.field_72450_a;
				this.field_70181_x = newMotion.field_72448_b;
				this.field_70179_y = newMotion.field_72449_c;
			}
		}
	}

	public EntityLivingBase getTarget()
	{
		if(targetOverride!=null && !targetOverride.field_70128_L)
			return targetOverride;
		double r = 20D;
		AxisAlignedBB aabb = new AxisAlignedBB(field_70165_t-r,field_70163_u-r,field_70161_v-r, field_70165_t+r,field_70163_u+r,field_70161_v+r);
		EntityLivingBase target = null;
		for(Object o: field_70170_p.func_72872_a(EntityLivingBase.class, aabb))
			if(o instanceof EntityLivingBase && !o.equals(this.shootingEntity))
				if(target==null || ((EntityLivingBase)o).func_70068_e(this)<target.func_70068_e(this))
					target = (EntityLivingBase)o;
		return target;
	}
}
