/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler.IBullet;
import blusunrize.immersiveengineering.common.util.Utils;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityRevolvershotFlare extends EntityRevolvershot implements ILightProvider
{
	boolean shootUp = false;
	public int colour = -1;
	private static final DataParameter<Integer> dataMarker_colour = EntityDataManager.func_187226_a(EntityRevolvershotFlare.class, DataSerializers.field_187192_b);
	private BlockPos lightPos;

	public EntityRevolvershotFlare(World world)
	{
		super(world);
		this.setTickLimit(400);
	}

	public EntityRevolvershotFlare(World world, double x, double y, double z, double ax, double ay, double az, IBullet type)
	{
		super(world, x, y, z, ax, ay, az, type);
		this.setTickLimit(400);
	}

	public EntityRevolvershotFlare(World world, EntityLivingBase living, double ax, double ay, double az, IBullet type, ItemStack stack)
	{
		super(world, living, ax, ay, az, type, stack);
		this.setTickLimit(400);
	}

	@Override
	protected void func_70088_a()
	{
		super.func_70088_a();
		this.field_70180_af.func_187214_a(dataMarker_colour, Integer.valueOf(-1));
	}

	public void setColourSynced()
	{
		this.field_70180_af.func_187227_b(dataMarker_colour, colour);
	}
	public int getColourSynced()
	{
		return this.field_70180_af.func_187225_a(dataMarker_colour);
	}
	public int getColour()
	{
		return colour;
	}

	@Override
	public void func_70071_h_()
	{
		super.func_70071_h_();
		if(colour<0)
			colour = getColourSynced();
		if(field_70170_p.field_72995_K && field_70173_aa%1==0)
		{
			float r = (getColour()>>16&255)/255f;
			float g = (getColour()>>8&255)/255f;
			float b = (getColour()&255)/255f;
			ImmersiveEngineering.proxy.spawnRedstoneFX(field_70170_p, field_70165_t,field_70163_u,field_70161_v, 0,0,0, 1, r,g,b);
			if(field_70173_aa>40)
				for(int i=0; i<20; i++)
				{
					Vec3d v = new Vec3d(Utils.RAND.nextDouble()-.5,Utils.RAND.nextDouble()-.5,Utils.RAND.nextDouble()-.5);
					ImmersiveEngineering.proxy.spawnRedstoneFX(field_70170_p, field_70165_t+v.field_72450_a,field_70163_u+v.field_72448_b,field_70161_v+v.field_72449_c, v.field_72450_a/10,v.field_72448_b/10,v.field_72449_c/10, 1, r,g,b);
				}
		}
		if(field_70173_aa==40)
		{
			field_70159_w = 0;
			field_70181_x = -.1;
			field_70179_y = 0;
			float r = (getColour()>>16&255)/255f;
			float g = (getColour()>>8&255)/255f;
			float b = (getColour()&255)/255f;
			for(int i=0; i<80; i++)
			{
				Vec3d v = new Vec3d((Utils.RAND.nextDouble()-.5)*i>40?2:1,(Utils.RAND.nextDouble()-.5)*i>40?2:1,(Utils.RAND.nextDouble()-.5)*i>40?2:1);
				ImmersiveEngineering.proxy.spawnRedstoneFX(field_70170_p, field_70165_t+v.field_72450_a,field_70163_u+v.field_72448_b,field_70161_v+v.field_72449_c, v.field_72450_a/10,v.field_72448_b/10,v.field_72449_c/10, 1, r,g,b);
			}

			lightPos = this.func_180425_c();
			for(int i=0; i<128; i++)
				if(field_70170_p.func_175623_d(lightPos))
					lightPos = lightPos.func_177977_b();
				else
				{
					lightPos = lightPos.func_177981_b(6);
					break;
				}
		}
	}

	@Override
	protected void onImpact(RayTraceResult mop)
	{
		if(field_70173_aa<=40)
		{
			if(!this.field_70170_p.field_72995_K)
				if(mop.field_72308_g != null)
				{
					if(!mop.field_72308_g.func_70045_F())
						mop.field_72308_g.func_70015_d(8);
				}
				else if(mop.func_178782_a()!=null)
				{
					BlockPos pos = mop.func_178782_a().func_177972_a(mop.field_178784_b);
					if(this.field_70170_p.func_175623_d(pos))
						this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
				}
			float r = (getColour()>>16&255)/255f;
			float g = (getColour()>>8&255)/255f;
			float b = (getColour()&255)/255f;
			for(int i=0; i<80; i++)
			{
				Vec3d v = new Vec3d((Utils.RAND.nextDouble()-.5)*i>40?2:1,(Utils.RAND.nextDouble()-.5)*i>40?2:1,(Utils.RAND.nextDouble()-.5)*i>40?2:1);
				ImmersiveEngineering.proxy.spawnRedstoneFX(field_70170_p, field_70165_t+v.field_72450_a,field_70163_u+v.field_72448_b,field_70161_v+v.field_72449_c, v.field_72450_a/10,v.field_72448_b/10,v.field_72449_c/10, 1, r,g,b);
			}
		}
		this.func_70106_y();
	}

	@Nullable
	@Optional.Method(modid="albedo")
	@SideOnly(Side.CLIENT)
	@Override
	public Light provideLight()
	{
		float r = (getColour()>>16&255)/255f;
		float g = (getColour()>>8&255)/255f;
		float b = (getColour()&255)/255f;
		if(lightPos!=null)
			return Light.builder().pos(lightPos).radius(16).color(r, g, b).build();
		return Light.builder().pos(this).radius(1).color(r, g, b).build();
	}
}
