/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.BulletHandler.IBullet;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageBirthdayParty;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.*;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

public class EntityRevolvershot extends Entity
{
	private int xTile = -1;
	private int yTile = -1;
	private int zTile = -1;
	private Block inTile;
	private int inData;
	private boolean inGround;
	public EntityLivingBase shootingEntity;
	private int ticksInGround;
	private int ticksInAir;
	private float movementDecay = 0;
	private float gravity = 0;

	private int tickLimit=40;
	String bulletType;
	public boolean bulletElectro = false;
	public ItemStack bulletPotion = ItemStack.field_190927_a;

	private static final DataParameter<String> dataMarker_shooter = EntityDataManager.func_187226_a(EntityRevolvershot.class, DataSerializers.field_187194_d);

	public EntityRevolvershot(World world)
	{
		super(world);
		this.func_70105_a(.125f,.125f);
	}

	public EntityRevolvershot(World world, double x, double y, double z, double ax, double ay, double az, IBullet type)
	{
		super(world);
		this.func_70105_a(0.125F, 0.125F);
		this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
		this.func_70107_b(x, y, z);
		this.bulletType = BulletHandler.findRegistryName(type);
	}

	public EntityRevolvershot(World world, EntityLivingBase living, double ax, double ay, double az, IBullet type, ItemStack stack)
	{
		this(world, living, ax, ay, az, BulletHandler.findRegistryName(type),stack);
	}
	public EntityRevolvershot(World world, EntityLivingBase living, double ax, double ay, double az, String type, ItemStack stack)
	{
		super(world);
		this.shootingEntity = living;
		setShooterSynced();
		this.func_70105_a(0.125F, 0.125F);
		this.func_70012_b(living.field_70165_t+ax, living.field_70163_u+living.func_70047_e()+ay, living.field_70161_v+az, living.field_70177_z, living.field_70125_A);
		this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
		//		this.yOffset = 0.0F;
		this.field_70159_w = this.field_70181_x = this.field_70179_y = 0.0D;
		this.bulletType = type;
	}

	public void setTickLimit(int limit)
	{
		this.tickLimit=limit;
	}

	public void setMovementDecay(float f)
	{
		this.movementDecay=f;
	}

	public void setGravity(float f)
	{
		this.gravity=f;
	}


	@SideOnly(Side.CLIENT)
	@Override
	public boolean func_70112_a(double p_70112_1_)
	{
		double d1 = this.func_174813_aQ().func_72320_b() * 4.0D;
		d1 *= 64.0D;
		return p_70112_1_ < d1 * d1;
	}

	@Override
	protected void func_70088_a()
	{
		this.field_70180_af.func_187214_a(dataMarker_shooter, "");
	}

	public void setShooterSynced()
	{
		this.field_70180_af.func_187227_b(dataMarker_shooter, this.shootingEntity.func_70005_c_());
	}
	public EntityLivingBase getShooterSynced()
	{
		return this.field_70170_p.func_72924_a(this.field_70180_af.func_187225_a(dataMarker_shooter));
	}
	public Entity getShooter()
	{
		return shootingEntity;
	}

	@Override
	public void func_70071_h_()
	{
		if(this.getShooter() == null && this.field_70170_p.field_72995_K)
			this.shootingEntity = getShooterSynced();

		if(!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L))
			this.func_70106_y();
		else
		{
			BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
			IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
			Block block = iblockstate.func_177230_c();

			if(iblockstate.func_185904_a() != Material.field_151579_a)
			{
				AxisAlignedBB axisalignedbb = iblockstate.func_185890_d(this.field_70170_p, blockpos);

				if (axisalignedbb != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)))
				{
					this.inGround = true;
				}
			}

			super.func_70071_h_();

			if(this.inGround)
			{
				int j = block.func_176201_c(iblockstate);

				if(block==this.inTile && j==this.inData)
				{
					++this.ticksInGround;

					if (this.ticksInGround >= 1200)
					{
						this.func_70106_y();
					}
				}
				else
				{
					this.inGround = false;
					this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2F);
					this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2F);
					this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2F);
					this.ticksInGround = 0;
					this.ticksInAir = 0;
				}
			}
			else
				++this.ticksInAir;

			if(ticksInAir>=tickLimit)
			{
				this.onExpire();
				this.func_70106_y();
				return;
			}

			Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
			Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
			RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
			vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
			vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);

			if (movingobjectposition != null)
				vec31 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);

			Entity entity = null;
			List<Entity> list = this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0D));
			double d0 = 0.0D;

			for (int i = 0; i < list.size(); ++i)
			{
				Entity entity1 = list.get(i);
				if (entity1.func_70067_L() && (!entity1.func_70028_i(this.shootingEntity)))
				{
					float f = 0.3F;
					AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(f);
					RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);

					if (movingobjectposition1 != null)
					{
						double d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f);
						if (d1 < d0 || d0 == 0.0D)
						{
							entity = entity1;
							d0 = d1;
						}
					}
				}
			}

			if (entity != null)
				movingobjectposition = new RayTraceResult(entity);

			if (movingobjectposition != null)
				this.onImpact(movingobjectposition);

			this.field_70165_t += this.field_70159_w;
			this.field_70163_u += this.field_70181_x;
			this.field_70161_v += this.field_70179_y;
			float f1 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
			this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0D / Math.PI) + 90.0F;

			for (this.field_70125_A = (float)(Math.atan2((double)f1, this.field_70181_x) * 180.0D / Math.PI) - 90.0F; this.field_70125_A - this.field_70127_C < -180.0F; this.field_70127_C -= 360.0F);

			while (this.field_70125_A - this.field_70127_C >= 180.0F)
				this.field_70127_C += 360.0F;
			while (this.field_70177_z - this.field_70126_B < -180.0F)
				this.field_70126_B -= 360.0F;
			while (this.field_70177_z - this.field_70126_B >= 180.0F)
				this.field_70126_B += 360.0F;

			this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2F;
			this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2F;

			float decay = movementDecay;
			if(this.func_70090_H())
			{
				float f3 = 0.25F;
				for(int j = 0; j < 4; ++j)
					this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
				decay *= .6;
			}

			if(decay!=0)
			{
				this.field_70159_w *= decay;
				this.field_70181_x *= decay;
				this.field_70179_y *= decay;
			}
			if(gravity!=0)
				this.field_70181_x -= gravity;

			if(field_70173_aa%4==0)
				this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0D, 0.0D, 0.0D);
			this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
		}
	}

	protected void onImpact(RayTraceResult mop)
	{
		boolean headshot = false;
		if(mop.field_72308_g instanceof EntityLivingBase)
			headshot = Utils.isVecInEntityHead((EntityLivingBase) mop.field_72308_g, new Vec3d(field_70165_t, field_70163_u, field_70161_v));

		if(this.bulletType != null)
		{
			IBullet bullet = BulletHandler.getBullet(bulletType);
			if(bullet != null)
				bullet.onHitTarget(field_70170_p, mop, this.shootingEntity, this, headshot);
			if(headshot && mop.field_72308_g instanceof EntityAgeable && ((EntityAgeable)mop.field_72308_g).func_70631_g_() && ((EntityLivingBase)mop.field_72308_g).func_110143_aJ()<=0)
			{
				if(this.shootingEntity instanceof EntityPlayer)
					Utils.unlockIEAdvancement((EntityPlayer)this.shootingEntity, "main/secret_birthdayparty");
				field_70170_p.func_184148_a(null, field_70165_t,field_70163_u,field_70161_v, IESounds.birthdayParty, SoundCategory.PLAYERS, 1.0F, 1.2F / (this.field_70146_Z.nextFloat() * 0.2F + 0.9F));
				ImmersiveEngineering.packetHandler.sendToDimension(new MessageBirthdayParty((EntityLivingBase)mop.field_72308_g), field_70170_p.field_73011_w.getDimension());
			}
		}
		if(!this.field_70170_p.field_72995_K)
		{
//			if(bulletType==3)
//				world.createExplosion(shootingEntity, posX, posY, posZ, 2, false);
			this.secondaryImpact(mop);
		}
		this.func_70106_y();
	}


	public void secondaryImpact(RayTraceResult mop)
	{
		if(bulletElectro && mop.field_72308_g instanceof EntityLivingBase)
		{
			IBullet bullet = BulletHandler.getBullet(bulletType);
			float percentualDrain = .15f/(bullet==null?1:bullet.getProjectileCount(shootingEntity instanceof EntityPlayer?(EntityPlayer)this.shootingEntity:null));
			((EntityLivingBase)mop.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d,15,4));
			for(EntityEquipmentSlot slot : EntityEquipmentSlot.values())
			{
				ItemStack stack = ((EntityLivingBase)mop.field_72308_g).func_184582_a(slot);
				if(EnergyHelper.isFluxItem(stack) && EnergyHelper.getEnergyStored(stack)>0)
				{
					int drain = (int)Math.max(EnergyHelper.getEnergyStored(stack),EnergyHelper.getMaxEnergyStored(stack)*percentualDrain);
					int hasDrained = 0;
					while(hasDrained<drain)
					{
						int actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false);
						if(actualDrain<=0)
							break;
						hasDrained += actualDrain;
					}
				}
			}
		}

//		if(bulletType==6)
//		{
//			Vec3d v = new Vec3d(-motionX, -motionY, -motionZ);
//			int split = 6;
//			for(int i=0; i<split; i++)
//			{
//				float angle = i * (360f/split);
//				Matrix4 matrix = new Matrix4();
//				matrix.rotate(angle, v.xCoord,v.yCoord,v.zCoord);
//				Vec3d vecDir = new Vec3d(0, 1, 0);
//				vecDir = matrix.apply(vecDir);
//
//				EntityWolfpackShot bullet = new EntityWolfpackShot(world, this.shootingEntity, vecDir.xCoord*1.5,vecDir.yCoord*1.5,vecDir.zCoord*1.5, this.bulletType, null);
//				if(mop.entityHit instanceof EntityLivingBase)
//					bullet.targetOverride = (EntityLivingBase)mop.entityHit;
//				bullet.setPosition(posX+vecDir.xCoord, posY+vecDir.yCoord, posZ+vecDir.zCoord);
//				bullet.motionX = vecDir.xCoord*.375;
//				bullet.motionY = vecDir.yCoord*.375;
//				bullet.motionZ = vecDir.zCoord*.375;
//				world.spawnEntity(bullet);
//			}
//		}
//		if(bulletType==8 && bulletPotion!=null && bulletPotion.getItem() instanceof ItemPotion)
//		{
//			PotionType potionType = PotionUtils.getPotionFromItem(bulletPotion);
//			List<PotionEffect> effects = PotionUtils.getEffectsFromStack(bulletPotion);
//			if(effects!=null)
//				if(bulletPotion.getItem() instanceof ItemLingeringPotion)
//				{
//					EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.world, this.posX, this.posY, this.posZ);
//					entityareaeffectcloud.setOwner(shootingEntity);
//					entityareaeffectcloud.setRadius(3.0F);
//					entityareaeffectcloud.setRadiusOnUse(-0.5F);
//					entityareaeffectcloud.setWaitTime(10);
//					entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
//					entityareaeffectcloud.setPotion(potionType);
//					for(PotionEffect potioneffect : effects)
//						entityareaeffectcloud.addEffect(new PotionEffect(potioneffect.getPotion(), potioneffect.getDuration(), potioneffect.getAmplifier()));
//					this.world.spawnEntity(entityareaeffectcloud);
//				}
//				else if(bulletPotion.getItem() instanceof ItemSplashPotion)
//				{
//					List<EntityLivingBase> livingEntities = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expand(4.0D, 2.0D, 4.0D));
//					if(livingEntities!=null && !livingEntities.isEmpty())
//						for(EntityLivingBase living : livingEntities)
//							if(living.canBeHitWithPotion())
//							{
//								double dist = this.getDistanceSqToEntity(living);
//								if(dist<16D)
//								{
//									double dist2 = 1-Math.sqrt(dist)/4D;
//									if(living == mop.entityHit)
//										dist2 = 1D;
//									for(PotionEffect p : effects)
//										if(p.getPotion().isInstant())
//											p.getPotion().affectEntity(this, this.shootingEntity, living,  p.getAmplifier(), dist2);
//										else
//										{
//											int j = (int)(dist2*p.getDuration()+.5D);
//											if(j>20)
//												living.addPotionEffect(new PotionEffect(p.getPotion(),j, p.getAmplifier()));
//										}
//								}
//							}
//
//				}
//				else if(mop.entityHit instanceof EntityLivingBase)
//					for(PotionEffect p : effects)
//					{
//						if(p.getDuration()<1)
//							p = new PotionEffect(p.getPotion(),1);
//						((EntityLivingBase)mop.entityHit).addPotionEffect(p);
//					}
//			world.playEvent(2002, new BlockPos(this), PotionType.getID(potionType));
//		}
	}
	public void onExpire()
	{

	}

	protected float getMotionFactor()
	{
		return 0.95F;
	}

	@Override
	//	public void writeToNBT(NBTTagCompound nbt)
	protected void func_70014_b(NBTTagCompound nbt)
	{
		//		super.writeToNBT(nbt);
		nbt.func_74777_a("xTile", (short)this.xTile);
		nbt.func_74777_a("yTile", (short)this.yTile);
		nbt.func_74777_a("zTile", (short)this.zTile);
		nbt.func_74774_a("inTile", (byte)Block.func_149682_b(this.inTile));
		nbt.func_74768_a("inData", this.inData);
		nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
		nbt.func_74782_a("direction", this.func_70087_a(this.field_70159_w, this.field_70181_x, this.field_70179_y));
		nbt.func_74778_a("bulletType", this.bulletType);
		if(!bulletPotion.func_190926_b())
			nbt.func_74782_a("bulletPotion", bulletPotion.func_77955_b(new NBTTagCompound()));
		if(this.shootingEntity!=null)
			nbt.func_74778_a("shootingEntity", this.shootingEntity.func_70005_c_());
	}

	@Override
	//	public void readFromNBT(NBTTagCompound nbt)
	protected void func_70037_a(NBTTagCompound nbt)
	{
		//		super.readFromNBT(nbt);
		this.xTile = nbt.func_74765_d("xTile");
		this.yTile = nbt.func_74765_d("yTile");
		this.zTile = nbt.func_74765_d("zTile");
		this.inTile = Block.func_149729_e(nbt.func_74771_c("inTile") & 255);
		this.inData = nbt.func_74762_e("inData");
		this.inGround = nbt.func_74771_c("inGround") == 1;
		this.bulletType = nbt.func_74779_i("bulletType");
		if(nbt.func_74764_b("bulletPotion"))
			this.bulletPotion= new ItemStack(nbt.func_74775_l("bulletPotion"));

		if (nbt.func_150297_b("direction", 9))
		{
			NBTTagList nbttaglist = nbt.func_150295_c("direction", 6);
			this.field_70159_w = nbttaglist.func_150308_e(0);
			this.field_70181_x = nbttaglist.func_150308_e(1);
			this.field_70179_y = nbttaglist.func_150308_e(2);
		}
		else
		{
			this.func_70106_y();
		}

		if(this.field_70170_p!=null)
			this.shootingEntity = this.field_70170_p.func_72924_a(nbt.func_74779_i("shootingEntity"));
	}

	@Override
	public float func_70111_Y()
	{
		return 1.0F;
	}
	@Override
	public float func_70013_c()
	{
		return 1.0F;
	}
	@SideOnly(Side.CLIENT)
	@Override
	public int func_70070_b()
	{
		return 15728880;
	}
	@Override
	public boolean func_70067_L()
	{
		return false;
	}
	@Override
	public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_)
	{
		return false;
	}
}
