/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.RailgunHandler.RailgunProjectileProperties;
import blusunrize.immersiveengineering.common.Config.IEConfig.Tools;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

import net.minecraft.entity.projectile.EntityArrow.PickupStatus;

public class EntityRailgunShot extends EntityIEProjectile
{
	private ItemStack ammo = ItemStack.field_190927_a;
	private static final DataParameter<ItemStack> dataMarker_ammo = EntityDataManager.func_187226_a(EntityRailgunShot.class, DataSerializers.field_187196_f);
	private RailgunProjectileProperties ammoProperties;

	public EntityRailgunShot(World world)
	{
		super(world);
		this.func_70105_a(.5f, .5f);
		this.field_70251_a = PickupStatus.ALLOWED;
	}
	public EntityRailgunShot(World world, double x, double y, double z, double ax, double ay, double az, ItemStack ammo)
	{
		super(world, x,y,z, ax,ay,az);
		this.func_70105_a(.5f, .5f);
		this.ammo = ammo;
		this.setAmmoSynced();
		this.field_70251_a = PickupStatus.ALLOWED;
	}
	public EntityRailgunShot(World world, EntityLivingBase living, double ax, double ay, double az, ItemStack ammo)
	{
		super(world, living, ax, ay, az);
		this.func_70105_a(.5f, .5f);
		this.ammo = ammo;
		this.setAmmoSynced();
		this.field_70251_a = PickupStatus.ALLOWED;
	}
	@Override
	protected void func_70088_a()
	{
		super.func_70088_a();
		this.field_70180_af.func_187214_a(dataMarker_ammo, ItemStack.field_190927_a);
	}

	@Override
	protected ItemStack func_184550_j()
	{
		return ammo;
	}

	public void setAmmoSynced()
	{
		if(!this.getAmmo().func_190926_b())
			this.field_70180_af.func_187227_b(dataMarker_ammo, getAmmo());
	}
	public ItemStack getAmmoSynced()
	{
		return this.field_70180_af.func_187225_a(dataMarker_ammo);
	}
	public ItemStack getAmmo()
	{
		return ammo;
	}
	public RailgunProjectileProperties getAmmoProperties()
	{
		if(ammoProperties==null && !ammo.func_190926_b())
			ammoProperties = RailgunHandler.getProjectileProperties(ammo);
		return ammoProperties;
	}

	@Override
	public double getGravity()
	{
		return .005*(getAmmoProperties()!=null?getAmmoProperties().gravity:1);
	}

	@Override
	public int getMaxTicksInGround()
	{
		return 500;
	}

	@Override
	public void func_70030_z()
	{
		// For testign Desync
		//		if(world instanceof WorldServer)
		//			((WorldServer)world).func_147487_a("flame", posX,posY,posZ, 0, 0,0,0, 1);
		//		else
		//			world.spawnParticle("smoke", posX, posY, posZ, 0, 0, 0);
		if(this.getAmmo().func_190926_b() && this.field_70170_p.field_72995_K)
			this.ammo = getAmmoSynced();
		super.func_70030_z();
	}

	@Override
	public void onImpact(RayTraceResult mop)
	{
		if(!this.field_70170_p.field_72995_K && !getAmmo().func_190926_b())
		{
			if(mop.field_72308_g!=null)
			{
				if(getAmmoProperties()!=null)
				{
					if(!getAmmoProperties().overrideHitEntity(mop.field_72308_g, getShooter()))
						mop.field_72308_g.func_70097_a(IEDamageSources.causeRailgunDamage(this, getShooter()), (float)getAmmoProperties().damage*Tools.railgun_damage);
				}
			}
		}
	}

//	@Override
//    public void onCollideWithPlayer(EntityPlayer player)
//    {
//        if(!this.world.isRemote && this.inGround && this.getAmmo()!=null)
//            if(player.inventory.addItemStackToInventory(this.getAmmo().copy()))
//            {
//                this.playSound("random.pop", 0.2F, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7F + 1.0F) * 2.0F);
//                this.setDead();
//            }
//    }


	@Override
	public void func_70014_b(NBTTagCompound nbt)
	{
		super.func_70014_b(nbt);
		if(!this.ammo.func_190926_b())
			nbt.func_74782_a("ammo", this.ammo.func_77955_b(new NBTTagCompound()));
	}

	@Override
	public void func_70037_a(NBTTagCompound nbt)
	{
		super.func_70037_a(nbt);
		this.ammo = new ItemStack(nbt.func_74775_l("ammo"));
	}
}
