/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.*;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import net.minecraft.entity.projectile.EntityArrow.PickupStatus;

public abstract class EntityIEProjectile extends EntityArrow//Yes I have to extend arrow or else it's all weird and broken >_>
{
	protected int blockX = -1;
	protected int blockY = -1;
	protected int blockZ = -1;
	protected Block inBlock;
	protected int inMeta;
	public boolean inGround;
	public int ticksInGround;
	public int ticksInAir;

	private int tickLimit=40;
	private static final DataParameter<String> dataMarker_shooter = EntityDataManager.func_187226_a(EntityIEProjectile.class, DataSerializers.field_187194_d);

	public EntityIEProjectile(World world)
	{
		super(world);
		this.func_70105_a(.125f,.125f);
		this.field_70251_a = PickupStatus.DISALLOWED;
	}
	public EntityIEProjectile(World world, double x, double y, double z, double ax, double ay, double az)
	{
		super(world);
		this.func_70105_a(0.125F, 0.125F);
		this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
		this.func_70107_b(x, y, z);
		this.field_70251_a = PickupStatus.DISALLOWED;
	}
	public EntityIEProjectile(World world, EntityLivingBase living, double ax, double ay, double az)
	{
		super(world);
		this.func_70105_a(0.125F, 0.125F);
		this.func_70012_b(living.field_70165_t, living.field_70163_u+living.func_70047_e(), living.field_70161_v, living.field_70177_z, living.field_70125_A);
		this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
		this.field_70159_w = this.field_70181_x = this.field_70179_y = 0.0D;
		this.field_70159_w = ax;
		this.field_70181_x = ay;
		this.field_70179_y = az;
		this.field_70250_c = living;
		this.setShooterSynced();
		//		this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0F * (float)Math.PI) * 0.16F);
		//		this.posY -= 0.10000000149011612D;
		//		this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0F * (float)Math.PI) * 0.16F);
		//		this.setPosition(this.posX, this.posY, this.posZ);
		//		this.motionX = (double)(-MathHelper.sin(this.rotationYaw / 180.0F * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0F * (float)Math.PI));
		//		this.motionZ = (double)(MathHelper.cos(this.rotationYaw / 180.0F * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0F * (float)Math.PI));
		//		this.motionY = (double)(-MathHelper.sin(this.rotationPitch / 180.0F * (float)Math.PI));

		this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 2*1.5F, 1.0F);
		this.field_70251_a = PickupStatus.DISALLOWED;
	}

	@Override
	protected void func_70088_a()
	{
		super.func_70088_a();
		this.field_70180_af.func_187214_a(dataMarker_shooter, "");
	}


	public void setTickLimit(int limit)
	{
		this.tickLimit=limit;
	}

	public void setShooterSynced()
	{
		this.field_70180_af.func_187227_b(dataMarker_shooter, this.field_70250_c.func_70005_c_());
	}
	public EntityLivingBase getShooterSynced()
	{
		String s = this.field_70180_af.func_187225_a(dataMarker_shooter);
		if(s != null)
			return this.field_70170_p.func_72924_a(s);
		return null;
	}
	public Entity getShooter()
	{
		return field_70250_c;
	}

	@Override
	protected ItemStack func_184550_j()
	{
		return ItemStack.field_190927_a;
	}

	@Override
	public void func_70071_h_()
	{
		if(this.getShooter() == null && this.field_70170_p.field_72995_K)
			this.field_70250_c = getShooterSynced();

		this.func_70030_z();

		BlockPos blockpos = new BlockPos(this.blockX, this.blockY, this.blockZ);
		IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
		Block block = iblockstate.func_177230_c();

		if(iblockstate.func_185904_a() != Material.field_151579_a)
		{
			AxisAlignedBB axisalignedbb = block.func_180646_a(iblockstate, this.field_70170_p, blockpos);
			if(axisalignedbb != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)))
				this.inGround = true;
		}

		if(this.inGround)
		{
			int j = block.func_176201_c(iblockstate);
			if(block==this.inBlock && j==this.inMeta)
			{
				++this.ticksInGround;
				if (this.ticksInGround>=getMaxTicksInGround())
					this.func_70106_y();
			}
			else
			{
				this.inGround = false;
				this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2F);
				this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2F);
				this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2F);
				this.ticksInGround = 0;
				this.ticksInAir = 0;
			}
		}
		else
		{
			++this.ticksInAir;

			if(ticksInAir>=tickLimit)
			{
				this.func_70106_y();
				return;
			}

			Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
			Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
			RayTraceResult mop = this.field_70170_p.func_147447_a(currentPos, nextPos, false,true,false);

			currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);

			if(mop != null)
				nextPos = new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
			else
				nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);

			if(mop==null || mop.field_72308_g==null)
			{
				Entity entity = null;
				List list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1), (e)->e.func_70067_L());
				double d0 = 0.0D;
				for (int i = 0; i < list.size(); ++i)
				{
					Entity entity1 = (Entity)list.get(i);
					if(entity1.func_70067_L() && (!entity1.func_70028_i(this.field_70250_c) || this.ticksInAir>5))
					{
						float f = 0.3F;
						AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
						RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(currentPos, nextPos);

						if (movingobjectposition1 != null)
						{
							double d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f);
							if (d1 < d0 || d0 == 0.0D)
							{
								entity = entity1;
								d0 = d1;
							}
						}
					}
				}
				if(entity!=null)
					mop = new RayTraceResult(entity);
			}

			if(mop!=null)
			{
				if(!this.func_70027_ad() && this.canIgnite() && mop.field_72308_g!=null && mop.field_72308_g.func_70027_ad())
					this.func_70015_d(3);
				if(mop.field_72308_g!=null)
				{
					boolean allowHit = true;
					if(this.field_70250_c instanceof EntityPlayer && mop.field_72308_g instanceof EntityPlayer)
						allowHit = ((EntityPlayer)this.field_70250_c).func_96122_a((EntityPlayer)mop.field_72308_g);
					if(allowHit)
						this.onImpact(mop);
					this.func_70106_y();
				}
				else if(mop.field_72313_a== RayTraceResult.Type.BLOCK)
				{
					this.onImpact(mop);
					this.blockX = mop.func_178782_a().func_177958_n();
					this.blockY = mop.func_178782_a().func_177956_o();
					this.blockZ = mop.func_178782_a().func_177952_p();
					IBlockState state = this.field_70170_p.func_180495_p(mop.func_178782_a());
					this.inBlock = state.func_177230_c();
					this.inMeta = inBlock.func_176201_c(state);
					this.field_70159_w = mop.field_72307_f.field_72450_a - this.field_70165_t;
					this.field_70181_x = mop.field_72307_f.field_72448_b - this.field_70163_u;
					this.field_70179_y = mop.field_72307_f.field_72449_c - this.field_70161_v;
					float f2 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
					this.field_70165_t -= this.field_70159_w / (double)f2 * 0.05000000074505806D;
					this.field_70163_u -= this.field_70181_x / (double)f2 * 0.05000000074505806D;
					this.field_70161_v -= this.field_70179_y / (double)f2 * 0.05000000074505806D;
					//						this.posX = movingobjectposition.hitVec.xCoord;
					//						this.posY = movingobjectposition.hitVec.yCoord;
					//						this.posZ = movingobjectposition.hitVec.zCoord;
					//						this.setPosition(this.posX, this.posY, this.posZ);

					this.inGround = true;
					if(this.inBlock.func_149688_o(state) != Material.field_151579_a)
						this.inBlock.func_180634_a(this.field_70170_p, mop.func_178782_a(), state, this);
					//						return;
				}
			}

			this.field_70165_t += this.field_70159_w;
			this.field_70163_u += this.field_70181_x;
			this.field_70161_v += this.field_70179_y;

			float motion = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
			this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0D / Math.PI);

			for (this.field_70125_A = (float)(Math.atan2(this.field_70181_x, (double)motion) * 180.0D / Math.PI); this.field_70125_A - this.field_70127_C < -180.0F; this.field_70127_C -= 360.0F);
			while (this.field_70125_A - this.field_70127_C >= 180.0F)
				this.field_70127_C += 360.0F;
			while (this.field_70177_z - this.field_70126_B < -180.0F)
				this.field_70126_B -= 360.0F;
			while (this.field_70177_z - this.field_70126_B >= 180.0F)
				this.field_70126_B += 360.0F;
			this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2F;
			this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2F;


			float movementDecay = getMotionDecayFactor();

			if(this.func_70090_H())
			{
				for(int j = 0; j < 4; ++j)
				{
					float f3 = 0.25F;
					this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
				}
				movementDecay *= 0.8F;
			}

			this.field_70159_w *= movementDecay;
			this.field_70181_x *= movementDecay;
			this.field_70179_y *= movementDecay;
			this.field_70181_x -= getGravity();
			this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
			this.func_145775_I();
		}
	}

	@Override
	public void func_70100_b_(EntityPlayer p_70100_1_)
	{
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean func_70112_a(double p_70112_1_)
	{
		double d1 = this.func_174813_aQ().func_72320_b() * 4.0D;
		d1 *= 64.0D;
		return p_70112_1_ < d1 * d1;
	}

	public double getGravity()
	{
		return 0.05F;
	}

	public boolean canIgnite()
	{
		return false;
	}

	public int getMaxTicksInGround()
	{
		return 100;
	}

	public abstract void onImpact(RayTraceResult mop);

	protected float getMotionDecayFactor()
	{
		return 0.99F;
	}

	@Override
	public void func_70014_b(NBTTagCompound nbt)
	{
		super.func_70014_b(nbt);
		nbt.func_74777_a("xTile", (short)this.blockX);
		nbt.func_74777_a("yTile", (short)this.blockY);
		nbt.func_74777_a("zTile", (short)this.blockZ);
		nbt.func_74774_a("inTile", (byte)Block.func_149682_b(this.inBlock));
		nbt.func_74774_a("inMeta", (byte)this.inMeta);
		nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
		if(this.field_70250_c!=null)
			nbt.func_74778_a("shootingEntity", this.field_70250_c.func_70005_c_());

	}

	@Override
	public void func_70037_a(NBTTagCompound nbt)
	{
		super.func_70037_a(nbt);
		this.blockX = nbt.func_74765_d("xTile");
		this.blockY = nbt.func_74765_d("yTile");
		this.blockZ = nbt.func_74765_d("zTile");
		this.inBlock = Block.func_149729_e(nbt.func_74771_c("inTile") & 255);
		this.inGround = nbt.func_74771_c("inGround") == 1;
		if(this.field_70170_p!=null)
			this.field_70250_c = this.field_70170_p.func_72924_a(nbt.func_74779_i("shootingEntity"));
	}

	@Override
	public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_)
	{
		return false;
	}
}
