/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.util.IEExplosion;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityIEExplosive extends EntityTNTPrimed
{
	float explosionPower;
	boolean explosionSmoke = true;
	boolean explosionFire = false;
	float explosionDropChance;
	public IBlockState block;
	String name;

	private static final DataParameter<Optional<IBlockState>> dataMarker_block = EntityDataManager.func_187226_a(EntityIEExplosive.class, DataSerializers.field_187197_g);
	private static final DataParameter<Integer> dataMarker_fuse = EntityDataManager.func_187226_a(EntityIEExplosive.class, DataSerializers.field_187192_b);

	public EntityIEExplosive(World world)
	{
		super(world);
	}
	public EntityIEExplosive(World world, double x, double y, double z, EntityLivingBase igniter, IBlockState blockstate, float explosionPower)
	{
		super(world, x, y, z, igniter);
		this.explosionPower = explosionPower;
		this.block = blockstate;
		this.explosionDropChance = 1/explosionPower;
		this.setBlockSynced();
	}
	public EntityIEExplosive(World world, BlockPos pos, EntityLivingBase igniter, IBlockState blockstate, float explosionPower)
	{
		this(world, pos.func_177958_n()+.5, pos.func_177956_o()+.5, pos.func_177952_p()+.5, igniter, blockstate, explosionPower);
	}

	public EntityIEExplosive setSmoking(boolean smoke)
	{
		this.explosionSmoke = smoke;
		return this;
	}
	public EntityIEExplosive setFlaming(boolean fire)
	{
		this.explosionFire = fire;
		return this;
	}
	public EntityIEExplosive setDropChance(float chance)
	{
		this.explosionDropChance = chance;
		return this;
	}

	@Override
	protected void func_70088_a()
	{
		super.func_70088_a();
		this.field_70180_af.func_187214_a(dataMarker_block, Optional.absent());
		this.field_70180_af.func_187214_a(dataMarker_fuse, Integer.valueOf(0));
	}

	public void setBlockSynced()
	{
		if(this.block!=null)
		{
			this.field_70180_af.func_187227_b(dataMarker_block, Optional.of(this.block));
			this.field_70180_af.func_187227_b(dataMarker_fuse, this.func_184536_l());
		}
	}
	public void getBlockSynced()
	{
		this.block = this.field_70180_af.func_187225_a(dataMarker_block).orNull();
		this.func_184534_a(this.field_70180_af.func_187225_a(dataMarker_fuse));
	}

	@Override
	public String func_70005_c_()
	{
		if(this.block!=null && name==null)
		{
			ItemStack s = new ItemStack(this.block.func_177230_c(),1,this.block.func_177230_c().func_176201_c(this.block));
			if(!s.func_190926_b() && s.func_77973_b()!= Items.field_190931_a)
				name = s.func_82833_r();
		}
		if(name!=null)
			return name;
		return super.func_70005_c_();
	}

	@Override
	protected void func_70014_b(NBTTagCompound tagCompound)
	{
		super.func_70014_b(tagCompound);
		tagCompound.func_74776_a("explosionPower", explosionPower);
		tagCompound.func_74757_a("explosionSmoke", explosionSmoke);
		tagCompound.func_74757_a("explosionFire", explosionFire);
		if(this.block!=null)
			tagCompound.func_74768_a("block",Block.func_176210_f(this.block));
	}
	@Override
	protected void func_70037_a(NBTTagCompound tagCompound)
	{
		super.func_70037_a(tagCompound);
		explosionPower = tagCompound.func_74760_g("explosionPower");
		explosionSmoke = tagCompound.func_74767_n("explosionSmoke");
		explosionFire = tagCompound.func_74767_n("explosionFire");
		if(tagCompound.func_74764_b("block"))
			this.block = Block.func_176220_d(tagCompound.func_74762_e("block"));
	}


	@Override
	public void func_70071_h_()
	{
		if(field_70170_p.field_72995_K && this.block==null)
			this.getBlockSynced();

		this.field_70169_q = this.field_70165_t;
		this.field_70167_r = this.field_70163_u;
		this.field_70166_s = this.field_70161_v;
		this.field_70181_x -= 0.03999999910593033D;
		this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
		this.field_70159_w *= 0.9800000190734863D;
		this.field_70181_x *= 0.9800000190734863D;
		this.field_70179_y *= 0.9800000190734863D;

		if(this.field_70122_E)
		{
			this.field_70159_w *= 0.699999988079071D;
			this.field_70179_y *= 0.699999988079071D;
			this.field_70181_x *= -0.5D;
		}
		int newFuse = this.func_184536_l()-1;
		this.func_184534_a(newFuse);
		if(newFuse--<=0)
		{
			this.func_70106_y();

			if(!this.field_70170_p.field_72995_K)
			{
				Explosion explosion = new IEExplosion(field_70170_p, this, field_70165_t,field_70163_u+(field_70131_O/16f),field_70161_v, explosionPower, explosionFire, explosionSmoke).setDropChance(explosionDropChance);
				if(!ForgeEventFactory.onExplosionStart(field_70170_p, explosion))
				{
					explosion.func_77278_a();
					explosion.func_77279_a(true);
				}
			}
		}
		else
		{
			this.func_70072_I();
			this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5D, this.field_70161_v, 0.0D, 0.0D, 0.0D);
		}
	}
}
