/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.items.ItemFluorescentTube;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFluorescentTube extends Entity implements ITeslaEntity
{
	private static final DataParameter<Boolean> dataMarker_active = EntityDataManager.func_187226_a(EntityFluorescentTube.class, DataSerializers.field_187198_h);
	private static final DataParameter<Float> dataMarker_r = EntityDataManager.func_187226_a(EntityFluorescentTube.class, DataSerializers.field_187193_c);
	private static final DataParameter<Float> dataMarker_g = EntityDataManager.func_187226_a(EntityFluorescentTube.class, DataSerializers.field_187193_c);
	private static final DataParameter<Float> dataMarker_b = EntityDataManager.func_187226_a(EntityFluorescentTube.class, DataSerializers.field_187193_c);
	private static final DataParameter<Float> dataMarker_angleHorizontal = EntityDataManager.func_187226_a(EntityFluorescentTube.class, DataSerializers.field_187193_c);
	
	private int timer = 0;
	public boolean active = false;
	public float[] rgb;
	boolean firstTick = true;
	public float angleHorizontal = 0;
	public float tubeLength = 1.5F;

	public EntityFluorescentTube(World world, ItemStack tube, float angleVert)
	{
		this(world);
		field_70177_z = angleVert;
		rgb = ItemFluorescentTube.getRGB(tube);
	}
	public EntityFluorescentTube(World world)
	{
		super(world);
		func_70105_a(tubeLength/2, 1+tubeLength/2);
	}


	@Override
	public void func_70071_h_()
	{
		super.func_70071_h_();
		//movement logic
		this.field_70169_q = this.field_70165_t;
		this.field_70167_r = this.field_70163_u;
		this.field_70166_s = this.field_70161_v;
		this.field_70181_x -= 0.03999999910593033D;
		this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
		this.field_70159_w *= 0.9800000190734863D;
		this.field_70181_x *= 0.9800000190734863D;
		this.field_70179_y *= 0.9800000190734863D;

		if (this.field_70122_E)
		{
			this.field_70159_w *= 0.699999988079071D;
			this.field_70179_y *= 0.699999988079071D;
			this.field_70181_x *= -0.5D;
		}
		if (firstTick&&!field_70170_p.field_72995_K&&rgb!=null)
		{
			field_70180_af.func_187227_b(dataMarker_r, rgb[0]);
			field_70180_af.func_187227_b(dataMarker_g, rgb[1]);
			field_70180_af.func_187227_b(dataMarker_b, rgb[2]);
			field_70180_af.func_187227_b(dataMarker_angleHorizontal, angleHorizontal);
			firstTick = false;
		}
		// tube logic
		if (timer>0&&!field_70170_p.field_72995_K)
		{
			timer--;
			if (timer<=0)
				field_70180_af.func_187227_b(dataMarker_active, false);
		}
		if (field_70170_p.field_72995_K)
		{
			active = field_70180_af.func_187225_a(dataMarker_active);
			rgb = new float[]{field_70180_af.func_187225_a(dataMarker_r),
					field_70180_af.func_187225_a(dataMarker_g),
					field_70180_af.func_187225_a(dataMarker_b)};
			angleHorizontal = field_70180_af.func_187225_a(dataMarker_angleHorizontal);
		}
	}
	@Override
	protected void func_70088_a()
	{
		field_70180_af.func_187214_a(dataMarker_r, 1F);
		field_70180_af.func_187214_a(dataMarker_g, 1F);
		field_70180_af.func_187214_a(dataMarker_b, 1F);
		field_70180_af.func_187214_a(dataMarker_active, false);
		field_70180_af.func_187214_a(dataMarker_angleHorizontal, 0F);
	}

	@Override
	public void func_70037_a(NBTTagCompound nbt)
	{
		NBTTagCompound comp = nbt.func_74775_l("nbt");
		rgb = new float[]{comp.func_74760_g("r"), comp.func_74760_g("g"), comp.func_74760_g("b")};
		angleHorizontal = nbt.func_74760_g("angleHor");

	}

	@Override
	public void func_70014_b(NBTTagCompound nbt)
	{
		NBTTagCompound comp = new NBTTagCompound();
		comp.func_74776_a("r", rgb[0]);
		comp.func_74776_a("g", rgb[1]);
		comp.func_74776_a("b", rgb[2]);
		nbt.func_74782_a("nbt", comp);
		nbt.func_74776_a("angleHor", angleHorizontal);
	}

	@Override
	public boolean func_70097_a(DamageSource source, float amount)
	{
		if (!field_70128_L&&!field_70170_p.field_72995_K)
		{
			ItemStack tube = new ItemStack(IEContent.itemFluorescentTube);
			ItemFluorescentTube.setRGB(tube, rgb);
			EntityItem ent = new EntityItem(field_70170_p, field_70165_t, field_70163_u, field_70161_v, tube);
			field_70170_p.func_72838_d(ent);
			func_70106_y();
		}
		return super.func_70097_a(source, amount);
	}

	@Override
	public boolean func_70067_L()
	{
		return !field_70128_L;
	}
	@Override
	public AxisAlignedBB func_174813_aQ()
	{
		return super.func_174813_aQ();
	}
	@Override
	public void onHit(TileEntity te, boolean lowPower)
	{
		if(te instanceof TileEntityTeslaCoil && ((TileEntityTeslaCoil)te).energyStorage.extractEnergy(1, false) > 0)
		{
			timer = 35;
			field_70180_af.func_187227_b(dataMarker_active, true);
		}
	}
	@Override
	public EnumActionResult func_184199_a(EntityPlayer player, Vec3d targetVec3, EnumHand hand)
	{
		if(Utils.isHammer(player.func_184586_b(hand)))
		{
			angleHorizontal+=(player.func_70093_af()?10:1);
			angleHorizontal%=360;
			field_70180_af.func_187227_b(dataMarker_angleHorizontal, angleHorizontal);
			return EnumActionResult.SUCCESS;
		}
		return super.func_184199_a(player, targetVec3, hand);
	}
}
