/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler.ChemthrowerEffect;
import blusunrize.immersiveengineering.common.util.IEFluid;
import com.google.common.base.Optional;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.RayTraceResult.Type;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;


@net.minecraftforge.fml.common.Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityChemthrowerShot extends EntityIEProjectile implements ILightProvider
{
	private FluidStack fluid;
	private static final DataParameter<Optional<FluidStack>> dataMarker_fluid = EntityDataManager.func_187226_a(EntityChemthrowerShot.class, IEFluid.OPTIONAL_FLUID_STACK);

	public EntityChemthrowerShot(World world)
	{
		super(world);
	}
	public EntityChemthrowerShot(World world, double x, double y, double z, double ax, double ay, double az, FluidStack fluid)
	{
		super(world, x,y,z, ax,ay,az);
		this.fluid = fluid;
		this.setFluidSynced();
	}
	public EntityChemthrowerShot(World world, EntityLivingBase living, double ax, double ay, double az, FluidStack fluid)
	{
		super(world, living, ax, ay, az);
		this.fluid = fluid;
		this.setFluidSynced();
	}
	@Override
	protected void func_70088_a()
	{
		super.func_70088_a();
		this.field_70180_af.func_187214_a(dataMarker_fluid, Optional.absent());
	}

	public void setFluidSynced()
	{
		if(this.getFluid()!=null)
			this.field_70180_af.func_187227_b(dataMarker_fluid, Optional.of(this.getFluid()));
	}
	public FluidStack getFluidSynced()
	{
		return this.field_70180_af.func_187225_a(dataMarker_fluid).orNull();
	}
	public FluidStack getFluid()
	{
		return fluid;
	}

	@Override
	public double getGravity()
	{
		if(getFluid()!=null)
		{
			FluidStack fluidStack = getFluid();
			boolean isGas = fluidStack.getFluid().isGaseous(fluidStack)||ChemthrowerHandler.isGas(fluidStack.getFluid());
			return (isGas?.025f:.05F) * (fluidStack.getFluid().getDensity(fluidStack)<0?-1:1);
		}
		return super.getGravity();
	}

	@Override
	public boolean canIgnite()
	{
		return ChemthrowerHandler.isFlammable(getFluid()==null?null:getFluid().getFluid());
	}

	@Override
	public void func_70030_z()
	{
		if(this.getFluid() == null && this.field_70170_p.field_72995_K)
			this.fluid = getFluidSynced();
		IBlockState state = field_70170_p.func_180495_p(new BlockPos(field_70165_t,field_70163_u,field_70161_v));
		Block b = state.func_177230_c();
		if(b!=null && this.canIgnite() && (state.func_185904_a()==Material.field_151581_o||state.func_185904_a()==Material.field_151587_i))
			this.func_70015_d(6);
		super.func_70030_z();
	}
	@Override
	public void func_70015_d(int seconds)
	{
		if(!canIgnite())
			return;
		super.func_70015_d(seconds);
	}

	@Override
	public void onImpact(RayTraceResult mop)
	{
		if(!this.field_70170_p.field_72995_K && getFluid()!=null)
		{
			FluidStack fluidStack = getFluid();
			Fluid fluid = fluidStack.getFluid();
			ChemthrowerEffect effect = ChemthrowerHandler.getEffect(fluid);
			boolean fire = fluid.getTemperature(fluidStack)>1000;
			if(effect!=null)
			{
				ItemStack thrower = ItemStack.field_190927_a;
				EntityPlayer shooter = (EntityPlayer)this.getShooter();
				if(shooter!=null)
					thrower = shooter.func_184586_b(EnumHand.MAIN_HAND);

				if(mop.field_72313_a== Type.ENTITY&&mop.field_72308_g instanceof EntityLivingBase)
					effect.applyToEntity((EntityLivingBase)mop.field_72308_g, shooter, thrower, fluidStack);
				else if(mop.field_72313_a== Type.BLOCK)
					effect.applyToBlock(field_70170_p, mop, shooter, thrower, fluidStack);
			}
			else if(mop.field_72308_g!=null && fluid.getTemperature(fluidStack)>500)
			{
				int tempDiff = fluid.getTemperature(fluidStack)-300;
				int damage = Math.abs(tempDiff)/500;
				if(mop.field_72308_g.func_70097_a(DamageSource.field_76371_c, damage))
					mop.field_72308_g.field_70172_ad = (int)(mop.field_72308_g.field_70172_ad*.75);
			}
			if(mop.field_72308_g!=null)
			{
				int f = this.func_70027_ad()?this.field_190534_ay: fire?3: 0;
				if(f>0)
				{
					mop.field_72308_g.func_70015_d(f);
					if(mop.field_72308_g.func_70097_a(DamageSource.field_76372_a, 2))
						mop.field_72308_g.field_70172_ad = (int)(mop.field_72308_g.field_70172_ad*.75);
				}
			}
		}
	}

	@Nullable
	@Override
	public Light provideLight()
	{
		FluidStack fluidStack = getFluid();
		if(fluidStack!=null)
		{
			int light = this.func_70027_ad()?15:fluidStack.getFluid().getLuminosity(fluidStack);
			if(light>0)
				return Light.builder().pos(this).radius(.05f*light).color(1,1,1).build();
		}
		return null;
	}


	@Override
	@SideOnly(Side.CLIENT)
	public int func_70070_b()
	{
		FluidStack fluidStack = getFluid();
		if(fluidStack!=null)
		{
			int light = this.func_70027_ad()?15: fluidStack.getFluid().getLuminosity(fluidStack);
			int superBrightness = super.func_70070_b();
			light = (superBrightness&(0xff<<20))|(light<<4);
			if(light > 0)
				return Math.max(light, superBrightness);
		}
		return super.func_70070_b();
	}

	@Override
	public float func_70013_c()
	{
		FluidStack fluidStack = getFluid();
		if(fluidStack!=null)
		{
			int light = this.func_70027_ad()?15: fluidStack.getFluid().getLuminosity(fluidStack);
			if(light > 0)
				return Math.max(light, super.func_70013_c());
		}
		return super.func_70013_c();
	}

//	@Override
//	protected void writeEntityToNBT(NBTTagCompound nbt)
//	{
//		super.writeEntityToNBT(nbt);
//		if(this.fluid!=null)
//			nbt.setString("fluid", this.fluid.getName());
//	}
//
//	@Override
//	protected void readEntityFromNBT(NBTTagCompound nbt)
//	{
//		super.readEntityFromNBT(nbt);
//		this.fluid = FluidRegistry.getFluid(nbt.getString("fluid"));
//	}
}
