/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemSpeedloader;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeSpeeloader extends ShapedOreRecipe
{
	public RecipeSpeeloader()
	{
		super(null, new ItemStack(IEContent.itemSpeedloader), CraftingHelper.parseShaped("BBB", "BSB", "BBB", 'S', IEContent.itemSpeedloader, 'B', BulletHandler.getBulletStack("casull")));
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting matrix)
	{
		ItemStack speedloader = matrix.func_70301_a(4);

		if(!speedloader.func_190926_b() && speedloader.func_77973_b() instanceof ItemSpeedloader && ((ItemSpeedloader)speedloader.func_77973_b()).isEmpty(speedloader))
		{
			ItemStack out = speedloader.func_77946_l();
			NonNullList<ItemStack> fill = NonNullList.func_191197_a(8, ItemStack.field_190927_a);
			for(int i = 0; i < 8; i++)
			{
				int j = i >= 4?i+1: i;
				fill.set(i, Utils.copyStackWithAmount(matrix.func_70301_a(j),1));
			}
			((ItemSpeedloader)out.func_77973_b()).setContainedItems(out, fill);
			return out;
		}
		else
			return ItemStack.field_190927_a;
	}
}
