/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.oredict.ShapelessOreRecipe;

import java.util.ArrayList;
import java.util.Iterator;

public class RecipeShapelessIngredient extends ShapelessOreRecipe
{
	int nbtCopyTargetSlot = -1;
	int toolDamageSlot = -1;

	public RecipeShapelessIngredient(ResourceLocation group, ItemStack result, Object... recipe)
	{
		super(group, result, wrapIngredients(recipe));
	}
	public RecipeShapelessIngredient(ResourceLocation group, ItemStack result, NonNullList<Ingredient> input)
	{
		super(group, input, result);
	}
	private static Object[] wrapIngredients(Object... recipe)
	{
		Object[] out = new Object[recipe.length];
		for(int i=0; i<recipe.length; i++)
			if(recipe[i] instanceof IngredientStack)
				out[i] = new IngredientIngrStack((IngredientStack)recipe[i]);
			else
				out[i] = recipe[i];
		return out;
	}

	public RecipeShapelessIngredient setNBTCopyTargetRecipe(int slot)
	{
		this.nbtCopyTargetSlot = slot;
		return this;
	}

	public RecipeShapelessIngredient setToolDamageRecipe(int slot)
	{
		this.toolDamageSlot = slot;
		return this;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting matrix)
	{
		if(nbtCopyTargetSlot >= 0 && nbtCopyTargetSlot < func_192400_c().size())
			for(int i = 0; i < matrix.func_70302_i_(); i++)
			{
				ItemStack slot = matrix.func_70301_a(i);
				if(func_192400_c().get(nbtCopyTargetSlot).apply(slot))
				{
					ItemStack out = output.func_77946_l();
					if(!matrix.func_70301_a(nbtCopyTargetSlot).func_190926_b() && matrix.func_70301_a(nbtCopyTargetSlot).func_77942_o())
						out.func_77982_d(matrix.func_70301_a(nbtCopyTargetSlot).func_77978_p().func_74737_b());
					return out;
				}
			}
		return super.func_77572_b(matrix);
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
	{
		NonNullList<ItemStack>  remains = super.func_179532_b(inv);
		for(int i = 0; i < remains.size(); i++)
		{
			ItemStack s = inv.func_70301_a(i);
			ItemStack remain = remains.get(i);
			if(toolDamageSlot >= 0 && toolDamageSlot < func_192400_c().size())
			{
				ItemStack tool = ItemStack.field_190927_a;
				if(remain.func_190926_b() && !s.func_190926_b() && func_192400_c().get(toolDamageSlot).apply(s))
					tool = s.func_77946_l();
				else if(!remain.func_190926_b() && func_192400_c().get(toolDamageSlot).apply(remain))
					tool = remain;
				if(!tool.func_190926_b() && tool.func_77973_b().func_77645_m())
				{
					tool.func_77964_b(tool.func_77952_i() + 1);
					if(tool.func_77952_i() > tool.func_77958_k())
						tool = ItemStack.field_190927_a;
					remains.set(i, tool);
				}
			}
			if(!s.func_190926_b() && remain.func_190926_b() && s.func_77973_b() instanceof UniversalBucket)
			{
				ItemStack empty = ((UniversalBucket) s.func_77973_b()).getEmpty();
				if(!empty.func_190926_b())
					remains.set(i, empty.func_77946_l());
			}
		}
		return remains;
	}

	@Override
	public boolean func_77569_a(InventoryCrafting matrix, World world)
	{
		ArrayList<Ingredient> required = new ArrayList(func_192400_c());

		for(int i = 0; i < matrix.func_70302_i_(); i++)
		{
			ItemStack slot = matrix.func_70301_a(i);
			if(!slot.func_190926_b())
			{
				boolean inRecipe = false;
				Iterator<Ingredient> iterator = required.iterator();
				while(iterator.hasNext())
				{
					Ingredient next = iterator.next();
					if(next.apply(slot))
					{
						inRecipe = true;
						iterator.remove();
						break;
					}
				}
				if(!inRecipe)
					return false;
			}
		}
		return required.isEmpty();
	}
}
