/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper.ShapedPrimer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.ShapedOreRecipe;

import java.util.regex.Pattern;

public class RecipeShapedIngredient extends ShapedOreRecipe
{
	NonNullList<Ingredient> ingredientsQuarterTurn;
	NonNullList<Ingredient> ingredientsEighthTurn;
	int[] nbtCopyTargetSlot = null;
	Pattern nbtCopyPredicate = null;
	int lastMatch = 0;
	public RecipeShapedIngredient(ResourceLocation group, ItemStack result, Object... recipe)
	{
		super(group, result, wrapIngredients(recipe));
	}
	public RecipeShapedIngredient(ResourceLocation group, ItemStack result, ShapedPrimer primer)
	{
		super(group, result, primer);
	}

	private static Object[] wrapIngredients(Object... recipe)
	{
		Object[] out = new Object[recipe.length];
		for(int i=0; i<recipe.length; i++)
			if(recipe[i] instanceof IngredientStack)
				out[i] = new IngredientIngrStack((IngredientStack)recipe[i]);
			else
				out[i] = recipe[i];
		return out;
	}

	public RecipeShapedIngredient allowQuarterTurn()
	{
		ingredientsQuarterTurn = NonNullList.func_191197_a(func_192400_c().size(), Ingredient.field_193370_a);
		int maxH = (height - 1);
		for(int h = 0; h < height; h++)
			for(int w = 0; w < width; w++)
				ingredientsQuarterTurn.set(w * height + (maxH - h), func_192400_c().get(h * width + w));
		return this;
	}

	static int[] eighthTurnMap = {3, -1, -1, 3, 0, -3, 1, 1, -3};

	public RecipeShapedIngredient allowEighthTurn()
	{
		if(width != 3 || height != 3)//Recipe won't allow 8th turn when not a 3x3 square
			return this;
		ingredientsEighthTurn = NonNullList.func_191197_a(func_192400_c().size(), Ingredient.field_193370_a);
		int maxH = (height - 1);
		for(int h = 0; h < height; h++)
			for(int w = 0; w < width; w++)
			{
				int i = h * width + w;
				ingredientsEighthTurn.set(i + eighthTurnMap[i], func_192400_c().get(i));
			}
		return this;
	}

	public RecipeShapedIngredient setNBTCopyTargetRecipe(int... slot)
	{
		this.nbtCopyTargetSlot = slot;
		return this;
	}
	public RecipeShapedIngredient setNBTCopyPredicate(String pattern)
	{
		this.nbtCopyPredicate = Pattern.compile(pattern);
		return this;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting matrix)
	{
		if(nbtCopyTargetSlot != null)
		{
			ItemStack out = output.func_77946_l();
			NBTTagCompound tag = out.func_77942_o()?out.func_77978_p():new NBTTagCompound();
			for(int targetSlot : nbtCopyTargetSlot)
			{
				ItemStack s = matrix.func_70301_a(targetSlot);
				if(!s.func_190926_b() && s.func_77942_o())
					tag = ItemNBTHelper.combineTags(tag, s.func_77978_p(), nbtCopyPredicate);
			}
			if(!tag.func_82582_d())
				out.func_77982_d(tag);
			return out;
		}
		else
			return super.func_77572_b(matrix);
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) //getRecipeLeftovers
	{
		NonNullList<ItemStack> remains = ForgeHooks.defaultRecipeGetRemainingItems(inv);
		for(int i = 0; i < height*width; i++)
		{
			ItemStack s = inv.func_70301_a(i);
			NonNullList<Ingredient> matchedIngr = lastMatch==1?ingredientsQuarterTurn: lastMatch==2?ingredientsEighthTurn: this.input;
			if(matchedIngr.get(i) instanceof IngredientFluidStack)
			{
				if(!s.func_190926_b())
					remains.set(i, Utils.copyStackWithAmount(s, 1));
				IFluidHandlerItem handler = FluidUtil.getFluidHandler(remains.get(i));
				if(handler!=null)
				{
					FluidStack fluid = ((IngredientFluidStack)matchedIngr.get(i)).getFluid();
					handler.drain(fluid.amount, true);
					remains.set(i, handler.getContainer());
				}
			}
		}
		return remains;
	}

	@Override
	protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror)
	{
		if(checkMatchDo(inv, func_192400_c(), startX, startY, mirror, false))
		{
			lastMatch = 0;
			return true;
		}
		else if(ingredientsQuarterTurn != null && checkMatchDo(inv, ingredientsQuarterTurn, startX, startY, mirror, true))
		{
			lastMatch = 1;
			return true;
		}
		else if(ingredientsEighthTurn != null && checkMatchDo(inv, ingredientsEighthTurn, startX, startY, mirror, false))
		{
			lastMatch = 2;
			return true;
		}
		return false;
	}

	protected boolean checkMatchDo(InventoryCrafting inv, NonNullList<Ingredient> ingredients, int startX, int startY, boolean mirror, boolean rotate)
	{
		for(int x = 0; x < MAX_CRAFT_GRID_WIDTH; x++)
			for(int y = 0; y < MAX_CRAFT_GRID_HEIGHT; y++)
			{
				int subX = x - startX;
				int subY = y - startY;
				Ingredient target = Ingredient.field_193370_a;

				if(!rotate)
				{
					if(subX >= 0 && subY >= 0 && subX < width && subY < height)
						if(mirror)
							target = ingredients.get(width - subX - 1 + subY * width);
						else
							target = ingredients.get(subX + subY * width);
				} else
				{
					if(subX >= 0 && subY >= 0 && subX < height && subY < width)
						if(mirror)
							target = ingredients.get(height - subX - 1 + subY * width);
						else
							target = ingredients.get(subY + subX * height);
				}

				ItemStack slot = inv.func_70463_b(x, y);
//				if((target == null) != (slot.isEmpty()))
//					return false;
//				else if(target != null && !target.apply(slot))
//					return false;
				if(!target.apply(slot))
					return false;
			}
		return true;
	}
}
