/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RecipeShaderBags extends net.minecraftforge.registries.IForgeRegistryEntry.Impl<IRecipe> implements IRecipe
{
	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world)
	{
		ItemStack stack = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(stack.func_190926_b())
				{
					if(IEContent.itemShaderBag.equals(stackInSlot.func_77973_b()) && ItemNBTHelper.hasKey(stackInSlot, "rarity"))
						stack = stackInSlot;
					else
						return false;
//					if(IEContent.itemShader.equals(stackInSlot.getItem()) && ItemNBTHelper.hasKey(stackInSlot, "shader_name"))
//						stack = stackInSlot;
				}
				else
					return false;
		}
		return !stack.func_190926_b();
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv)
	{
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
			{
				ItemStack output = new ItemStack(IEContent.itemShaderBag,IEContent.itemShaderBag.equals(stackInSlot.func_77973_b())?2:1);
				EnumRarity next = ShaderRegistry.getLowerRarity(stackInSlot.func_77953_t());
				if(next!=null)
				{
					ItemNBTHelper.setString(output, "rarity", next.toString());
					return output;
				}
			}
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean func_194133_a(int width, int height)
	{
		return width>=2 && height>=2;
	}

	@Override
	public ItemStack func_77571_b()
	{
		return new ItemStack(IEContent.itemShaderBag,2);
	}

    @Override
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
    {
        return ForgeHooks.defaultRecipeGetRemainingItems(inv);
    }
}
