/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.IEContent;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeRevolver extends net.minecraftforge.registries.IForgeRegistryEntry.Impl<IRecipe> implements IRecipe
{
	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world)
	{
		ItemStack revolver = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
			{
				if(revolver.func_190926_b() && OreDictionary.itemMatches(new ItemStack(IEContent.itemRevolver,1,OreDictionary.WILDCARD_VALUE), stackInSlot, false) && stackInSlot.func_77952_i()!=1)
					revolver = stackInSlot;
				else
					return false;
			}
		}
		return !revolver.func_190926_b();
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv)
	{
		ItemStack revolver = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
			{
				if(revolver.func_190926_b() && OreDictionary.itemMatches(new ItemStack(IEContent.itemRevolver,1,OreDictionary.WILDCARD_VALUE), stackInSlot, false) && stackInSlot.func_77952_i()!=1)
					revolver = stackInSlot.func_77946_l();
				else
					return ItemStack.field_190927_a;
			}
		}
		return revolver;
	}

	@Override
	public boolean func_194133_a(int width, int height)
	{
		return width>=2 && height>=2;
	}

	@Override
	public ItemStack func_77571_b()
	{
		return ItemStack.field_190927_a;
	}

    @Override
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
    {
        return ForgeHooks.defaultRecipeGetRemainingItems(inv);
    }
}
