/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RecipePowerpack extends net.minecraftforge.registries.IForgeRegistryEntry.Impl<IRecipe> implements IRecipe
{
	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world)
	{
		ItemStack powerpack = ItemStack.field_190927_a;
		ItemStack armor = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(powerpack.func_190926_b() && IEContent.itemPowerpack.equals(stackInSlot.func_77973_b()))
					powerpack = stackInSlot;
				else if(armor.func_190926_b() && isValidArmor(stackInSlot))
					armor = stackInSlot;
				else
					return false;
		}
		if(!powerpack.func_190926_b() && !armor.func_190926_b() && !ItemNBTHelper.hasKey(armor, Lib.NBT_Powerpack))
			return true;
		else return !armor.func_190926_b()&&ItemNBTHelper.hasKey(armor, Lib.NBT_Powerpack)&&powerpack.func_190926_b();
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv)
	{
		ItemStack powerpack = ItemStack.field_190927_a;
		ItemStack armor = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(powerpack.func_190926_b() && IEContent.itemPowerpack.equals(stackInSlot.func_77973_b()))
					powerpack = stackInSlot;
				else if(armor.func_190926_b() && isValidArmor(stackInSlot))
					armor = stackInSlot;
		}

		if(!powerpack.func_190926_b() && !armor.func_190926_b() && !ItemNBTHelper.hasKey(armor, Lib.NBT_Powerpack))
		{
			ItemStack output = armor.func_77946_l();
			ItemNBTHelper.setItemStack(output, Lib.NBT_Powerpack, powerpack.func_77946_l());

			return output;
		}
		else if(!armor.func_190926_b() && ItemNBTHelper.hasKey(armor, Lib.NBT_Powerpack))
		{
			ItemStack output = armor.func_77946_l();
			ItemNBTHelper.remove(output, Lib.NBT_Powerpack);
			return output;
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean func_194133_a(int width, int height)
	{
		return width>=2 && height>=2;
	}

	@Override
	public ItemStack func_77571_b()
	{
		return new ItemStack(IEContent.itemPowerpack,1,0);
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
	{
		NonNullList<ItemStack> remaining = ForgeHooks.defaultRecipeGetRemainingItems(inv);
		for(int i=0;i<remaining.size();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b() && ItemNBTHelper.hasKey(stackInSlot, Lib.NBT_Powerpack))
				remaining.set(i, ItemNBTHelper.getItemStack(stackInSlot, Lib.NBT_Powerpack));
		}
		return remaining;
	}

	private boolean isValidArmor(ItemStack stack)
	{
		if(!(stack.func_77973_b() instanceof ItemArmor) || ((ItemArmor)stack.func_77973_b()).field_77881_a!=EntityEquipmentSlot.CHEST)
			return false;
		if (stack.func_77973_b()==IEContent.itemPowerpack)
			return false;
		String regName = stack.func_77973_b().getRegistryName().toString();
		for(String s : Config.IEConfig.Tools.powerpack_whitelist)
			if(regName.equals(s))
				return true;
		for(String s : Config.IEConfig.Tools.powerpack_blacklist)
			if(regName.equals(s))
				return false;
		return true;
	}
}
