/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RecipePotionBullets extends net.minecraftforge.registries.IForgeRegistryEntry.Impl<IRecipe> implements IRecipe
{
	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world)
	{
		ItemStack bullet = ItemStack.field_190927_a;
		ItemStack potion = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(bullet.func_190926_b() && IEContent.itemBullet.equals(stackInSlot.func_77973_b()) && "potion".equals(ItemNBTHelper.getString(stackInSlot, "bullet")))
					bullet = stackInSlot;
				else if(potion.func_190926_b() && stackInSlot.func_77973_b() instanceof ItemPotion)
					potion = stackInSlot;
				else
					return false;
		}
		return !bullet.func_190926_b() && !potion.func_190926_b();
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv)
	{
		ItemStack bullet = ItemStack.field_190927_a;
		ItemStack potion = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(bullet.func_190926_b() && IEContent.itemBullet.equals(stackInSlot.func_77973_b()) && "potion".equals(ItemNBTHelper.getString(stackInSlot, "bullet")))
					bullet = stackInSlot;
				else if(potion.func_190926_b() && stackInSlot.func_77973_b() instanceof ItemPotion)
					potion = stackInSlot;
		}
		ItemStack newBullet = Utils.copyStackWithAmount(bullet, 1);
		ItemNBTHelper.setItemStack(newBullet, "potion", potion.func_77946_l());
		return newBullet;
	}

	@Override
	public boolean func_194133_a(int width, int height)
	{
		return width>=2 && height>=2;
	}

	@Override
	public ItemStack func_77571_b()
	{
		return BulletHandler.getBulletStack("potion");
	}

    @Override
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
    {
        return ForgeHooks.defaultRecipeGetRemainingItems(inv);
    }
}
