/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RecipeJerrycan extends net.minecraftforge.registries.IForgeRegistryEntry.Impl<IRecipe> implements IRecipe
{
	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world)
	{
		ItemStack jerrycan = ItemStack.field_190927_a;
		ItemStack container = ItemStack.field_190927_a;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(jerrycan.func_190926_b() && IEContent.itemJerrycan.equals(stackInSlot.func_77973_b()) && FluidUtil.getFluidContained(stackInSlot)!=null)
					jerrycan = stackInSlot;
				else if(container.func_190926_b() && FluidUtil.getFluidHandler(stackInSlot)!=null)
					container = stackInSlot;
				else
					return false;
		}
		if(!jerrycan.func_190926_b() && !container.func_190926_b())
		{
			IFluidHandler handler = FluidUtil.getFluidHandler(container);
			FluidStack fs = handler.drain(Integer.MAX_VALUE, false);
			return fs==null||(fs.amount < handler.getTankProperties()[0].getCapacity()&&fs.isFluidEqual(FluidUtil.getFluidContained(jerrycan)));
		}
		return false;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv)
	{
		ItemStack jerrycan = ItemStack.field_190927_a;
		ItemStack container = ItemStack.field_190927_a;
		FluidStack fs = null;
		for(int i=0;i<inv.func_70302_i_();i++)
		{
			ItemStack stackInSlot = inv.func_70301_a(i);
			if(!stackInSlot.func_190926_b())
				if(jerrycan.func_190926_b() && IEContent.itemJerrycan.equals(stackInSlot.func_77973_b()) && FluidUtil.getFluidContained(stackInSlot)!=null)
				{
					jerrycan = stackInSlot;
					fs = FluidUtil.getFluidContained(jerrycan);
				}
				else if(container.func_190926_b() && FluidUtil.getFluidHandler(stackInSlot)!=null)
					container = stackInSlot;
		}
		if(fs!=null && !container.func_190926_b())
		{
			ItemStack newContainer = Utils.copyStackWithAmount(container, 1);
			IFluidHandler handler = FluidUtil.getFluidHandler(newContainer);
			int accepted = handler.fill(fs, false);
			if(accepted>0)
			{
				handler.fill(fs, true);
//				FluidUtil.getFluidHandler(jerrycan).drain(accepted,true);
				ItemNBTHelper.setInt(jerrycan, "jerrycanDrain", accepted);
			}
			return newContainer;
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean func_194133_a(int width, int height)
	{
		return width>=2 && height>=2;
	}

	@Override
	public ItemStack func_77571_b()
	{
		return ItemStack.field_190927_a;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv)
	{
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
//		for(int i=0;i<inv.getSizeInventory();i++)
//		{
//			ItemStack stackInSlot = inv.getStackInSlot(i);
//			if(stackInSlot!=null)
//				if(jerrycan==null && IEContent.itemJerrycan.equals(stackInSlot.getItem()) && ItemNBTHelper.hasKey(stackInSlot, "fluid"))
//
//		return new ItemStack[]
	}
}
