/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.*;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import com.google.common.collect.Lists;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.ArrayList;

public class TileEntityWoodenPost extends TileEntityIEBase implements IPostBlock, IFaceShape, IHasDummyBlocks, IHasObjProperty, IBlockBounds, IHammerInteraction
{
	public static ArrayList<? extends Enum> postMetaProperties = Lists.newArrayList(BlockTypes_WoodenDevice1.POST, BlockTypes_MetalDecoration2.ALUMINUM_POST, BlockTypes_MetalDecoration2.STEEL_POST);

	public byte dummy;

	public static boolean _Immovable()
	{
		return true;
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		dummy = nbt.func_74771_c("dummy");
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74774_a("dummy", dummy);
	}

	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;
	@SideOnly(Side.CLIENT)
	@Override
	public AxisAlignedBB getRenderBoundingBox()
	{
		return new AxisAlignedBB(func_174877_v().func_177982_a(-1,0,-1),func_174877_v().func_177982_a(1,4,1));
	}

	static ArrayList<String> emptyDisplayList = new ArrayList();
	@Override
	public ArrayList<String> compileDisplayList()
	{
		if(dummy!=0)
			return emptyDisplayList;
		ArrayList<String> list = new ArrayList();
		list.add("base");
		TileEntity te;
		for(int i=0; i<=2; i++)
		{
			te = field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,1+i,0));
			if(te instanceof TileEntityWoodenPost)//Stacked pieces
			{
				for(EnumFacing f : EnumFacing.field_176754_o)
					if(((TileEntityWoodenPost)te).hasConnection(f))
					{
						if(i==2)//Arms
						{
							TileEntityWoodenPost arm = (TileEntityWoodenPost)field_145850_b.func_175625_s(field_174879_c.func_177982_a(0,1+i,0).func_177972_a(f));
							boolean down = arm.hasConnection(EnumFacing.DOWN);
							if(down)
								list.add("arm_"+f.func_176742_j()+"_down");
							else
								list.add("arm_"+f.func_176742_j()+"_up");
						}
						else//Simple Connectors
							list.add("con_"+i+"_"+f.func_176742_j());
					}
			}
		}
		return list;
	}

	@Override
	public BlockFaceShape getFaceShape(EnumFacing side)
	{
		if(dummy==0)
			return side==EnumFacing.DOWN?BlockFaceShape.CENTER_BIG:BlockFaceShape.UNDEFINED;
		else if(dummy>=3)
			return (side==EnumFacing.UP||(dummy>3&&side==EnumFacing.DOWN))?BlockFaceShape.CENTER_BIG:BlockFaceShape.UNDEFINED;
		return BlockFaceShape.CENTER;
	}

	public boolean hasConnection(EnumFacing dir)
	{
		BlockPos pos = func_174877_v().func_177972_a(dir);
		if(dummy>0&&dummy<3)
		{
			IBlockState state = field_145850_b.func_180495_p(pos);
			for(Enum meta : postMetaProperties)
				if(state.func_177228_b().containsValue(meta))
					return false;
			AxisAlignedBB boundingBox = state.func_185900_c(field_145850_b, pos);
			double minX = boundingBox.field_72340_a;
			double maxX = boundingBox.field_72336_d;
			double minZ = boundingBox.field_72339_c;
			double maxZ = boundingBox.field_72334_f;
			boolean connect = dir==EnumFacing.NORTH?maxZ==1: dir==EnumFacing.SOUTH?minZ==0: dir==EnumFacing.WEST?maxX==1: minX==0;
			return connect && ((dir.func_176740_k()==Axis.Z && minX>0&&maxX<1)||(dir.func_176740_k()==Axis.X && minZ>0&&maxZ<1));
		}
		else if(dummy==3)
		{
			TileEntity te = field_145850_b.func_175625_s(pos);
			return (te instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)te).dummy-3==dir.ordinal());
		}
		else if(dummy>3)
		{
			if(field_145850_b.func_175623_d(pos))
				return false;
			IBlockState state = field_145850_b.func_180495_p(pos);
			AxisAlignedBB boundingBox = state.func_185900_c(field_145850_b, pos);
			return dir==EnumFacing.UP?boundingBox.field_72338_b==0: dir == EnumFacing.DOWN && boundingBox.field_72337_e == 1;
		}
		return false;
	}

	@Override
	public float[] getBlockBounds()
	{
		if(dummy==0)
			return new float[]{.25f,0,.25f, .75f,1,.75f};
		if(dummy<=2)
			return new float[]{hasConnection(EnumFacing.WEST)?0:.375f,0,hasConnection(EnumFacing.NORTH)?0:.375f, hasConnection(EnumFacing.EAST)?1:.625f,1,hasConnection(EnumFacing.SOUTH)?1:.625f};
		if(dummy==3)
			return new float[]{hasConnection(EnumFacing.WEST)?0:.3125f,0,hasConnection(EnumFacing.NORTH)?0:.3125f, hasConnection(EnumFacing.EAST)?1:.6875f,1,hasConnection(EnumFacing.SOUTH)?1:.6875f};

		float down = hasConnection(EnumFacing.DOWN)?0:.4375f;
		float up = down>0?1:.5625f;
		if(dummy-3==2)
			return new float[]{.3125f,down,.3125f, .6875f,up,1};
		if(dummy-3==3)
			return new float[]{.3125f,down,0, .6875f,up,.6875f};
		if(dummy-3==4)
			return new float[]{.3125f,down,.3125f, 1,up,.6875f};
		if(dummy-3==5)
			return new float[]{0,down,.3125f, .6875f,up,.6875f};
		return null;
	}

	@Override
	public boolean isDummy()
	{
		return dummy!=0;
	}
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		for(int i=1; i<=3; i++)
		{
			field_145850_b.func_175656_a(pos.func_177982_a(0,i,0), state);
			((TileEntityWoodenPost)field_145850_b.func_175625_s(pos.func_177982_a(0,i,0))).dummy = (byte)i;
			field_145850_b.func_175641_c(pos.func_177982_a(0, i, 0), func_145838_q(), 255, 0);
		}
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		if(dummy<=3)
			for(int i=0; i<=3; i++)
			{
				if(field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,-dummy,0).func_177982_a(0,i,0)) instanceof TileEntityWoodenPost)
					field_145850_b.func_175698_g(func_174877_v().func_177982_a(0,-dummy,0).func_177982_a(0,i,0));
				if(i==3)
				{
					TileEntity te;
					for(EnumFacing facing : EnumFacing.field_176754_o)
					{
						te = field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,-dummy,0).func_177982_a(0,i,0).func_177972_a(facing));
						if(te instanceof TileEntityWoodenPost && ((TileEntityWoodenPost) te).dummy==(3+facing.ordinal()))
							field_145850_b.func_175698_g(func_174877_v().func_177982_a(0,-dummy,0).func_177982_a(0,i,0).func_177972_a(facing));
					}
				}
			}
	}

	@Override
	public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ)
	{
		if(this.dummy==3 && side.func_176740_k()!=Axis.Y)
		{
			BlockPos offsetPos = func_174877_v().func_177972_a(side);
			//No Arms if space is blocked
			if(!field_145850_b.func_175623_d(offsetPos))
				return false;
			//No Arms if perpendicular arms exist
			TileEntity perpendicular = field_145850_b.func_175625_s(func_174877_v().func_177972_a(side.func_176746_e()));
			if(perpendicular instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)perpendicular).dummy-3==side.func_176746_e().ordinal())
				return false;
			perpendicular = field_145850_b.func_175625_s(func_174877_v().func_177972_a(side.func_176735_f()));
			if(perpendicular instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)perpendicular).dummy-3==side.func_176735_f().ordinal())
				return false;

			field_145850_b.func_175656_a(offsetPos, field_145850_b.func_180495_p(func_174877_v()));
			((TileEntityWoodenPost)field_145850_b.func_175625_s(offsetPos)).dummy = (byte)(3+side.ordinal());
			this.markBlockForUpdate(offsetPos, null);
			this.markBlockForUpdate(func_174877_v().func_177982_a(0,-3,0), null);
		}
		else if(this.dummy>3)
		{
			EnumFacing f = EnumFacing.func_82600_a(dummy-3).func_176734_d();
			this.field_145850_b.func_175698_g(func_174877_v());
			this.markBlockForUpdate(func_174877_v().func_177972_a(f).func_177982_a(0,-3,0), null);
		}
		return false;
	}

	@Override
	public boolean canConnectTransformer(IBlockAccess world, BlockPos pos)
	{
		return this.dummy > 0 && this.dummy <= 3;
	}
}
