/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IComparatorOverride;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ITileDrop;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class TileEntityWoodenCrate extends TileEntityIEBase implements IIEInventory, IGuiTile, ITileDrop, IComparatorOverride, ILootContainer
{
	NonNullList<ItemStack> inventory = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
	public ResourceLocation lootTable;
	public String name;
	private NBTTagList enchantments;

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		if(nbt.func_74764_b("name"))
			this.name = nbt.func_74779_i("name");
		if(nbt.func_74764_b("enchantments"))
			this.enchantments = nbt.func_150295_c("enchantments", 10);
		if(!descPacket)
		{
			if(nbt.func_150297_b("lootTable", 8))
				this.lootTable = new ResourceLocation(nbt.func_74779_i("lootTable"));
			else
				inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 27);
		}
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		if(this.name!=null)
			nbt.func_74778_a("name", this.name);
		if(this.enchantments!=null && this.enchantments.func_74745_c()>0)
			nbt.func_74782_a("enchantments", this.enchantments);
		if(!descPacket)
		{
			if(lootTable!=null)
				nbt.func_74778_a("lootTable",lootTable.toString());
			else
				writeInv(nbt, false);
		}
	}
	public void writeInv(NBTTagCompound nbt, boolean toItem)
	{
		boolean write = false;
		NBTTagList invList = new NBTTagList();
		for(int i=0; i<this.inventory.size(); i++)
			if(!this.inventory.get(i).func_190926_b())
			{
				if(toItem)
					write = true;
				NBTTagCompound itemTag = new NBTTagCompound();
				itemTag.func_74774_a("Slot", (byte)i);
				this.inventory.get(i).func_77955_b(itemTag);
				invList.func_74742_a(itemTag);
			}
		if(!toItem || write)
			nbt.func_74782_a("inventory", invList);
	}

	@Override
	@Nullable
	public ITextComponent func_145748_c_()
	{
		return name!=null?new TextComponentString(name) : new TextComponentTranslation(func_145832_p()==0?"tile.immersiveengineering.wooden_device0.crate.name":"tile.immersiveengineering.wooden_device0.reinforced_crate.name");
	}

	@Override
	public boolean canOpenGui()
	{
		return true;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_WoodenCrate;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		return this;
	}
	@Override
	public void onGuiOpened(EntityPlayer player, boolean clientside)
	{
		if(this.lootTable!=null && !clientside)
		{
			LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
			this.lootTable = null;
			Random random;
			LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)this.field_145850_b);
			if(player != null)
				contextBuilder.func_186469_a(player.func_184817_da());
			LootContext context = contextBuilder.func_186471_a();
			Random rand = new Random();

			List<ItemStack> list = loottable.func_186462_a(rand, context);
			List<Integer> listSlots = Lists.newArrayList();
			for(int i=0; i<inventory.size(); i++)
				if(inventory.get(i).func_190926_b())
					listSlots.add(Integer.valueOf(i));
			Collections.shuffle(listSlots, rand);
			if(listSlots.isEmpty())
				return;
			Utils.shuffleLootItems(list, listSlots.size(), rand);
			for(ItemStack itemstack : list)
			{
				int slot = listSlots.remove(listSlots.size() - 1).intValue();
				inventory.set(slot, itemstack);
			}
			this.func_70296_d();
		}
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return IEApi.isAllowedInCrate(stack);
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return 64;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
		this.func_70296_d();
	}

	@Override
	public ItemStack getTileDrop(EntityPlayer player, IBlockState state)
	{
		ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
		NBTTagCompound tag = new NBTTagCompound();
		writeInv(tag, true);
		if(!tag.func_82582_d())
			stack.func_77982_d(tag);
		if(this.name!=null)
			stack.func_151001_c(this.name);
		if(enchantments!=null && enchantments.func_74745_c()>0)
			ItemNBTHelper.getTag(stack).func_74782_a("ench", enchantments);
		return stack;
	}
	@Override
	public void readOnPlacement(EntityLivingBase placer, ItemStack stack)
	{
		if(stack.func_77942_o())
		{
			readCustomNBT(stack.func_77978_p(), false);
			if(stack.func_82837_s())
				this.name = stack.func_82833_r();
			enchantments = stack.func_77986_q();
		}
	}
	@Override
	public boolean preventInventoryDrop()
	{
		return true;
	}

	@Override
	public int getComparatorInputOverride()
	{
		return Utils.calcRedstoneFromInventory(this);
	}

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if(capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return true;
		return super.hasCapability(capability, facing);
	}
	IItemHandler insertionHandler = new IEInventoryHandler(27,this);
	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return (T)insertionHandler;
		return super.getCapability(capability, facing);
	}

	@Override
	public ResourceLocation func_184276_b()
	{
		return this.lootTable;
	}
}
