/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHasDummyBlocks;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHasObjProperty;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.ArrayList;

public class TileEntityWatermill extends TileEntityIEBase implements ITickable, IDirectionalTile, IHasDummyBlocks, IHasObjProperty
{
	public EnumFacing facing = EnumFacing.NORTH;
	public int[] offset={0,0};
	public float rotation=0;
	private Vec3d rotationVec = null;
	public boolean canTurn = false;
	public boolean multiblock = false;
	public float prevRotation = 0;
	private boolean formed = true;
	public double perTick;

//	@Override
//	public boolean hasFastRenderer()
//	{
//		return true;
//	}

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(offset[0]!=0||offset[1]!=0||field_145850_b==null)
			return;
		if(isBlocked())
		{
			canTurn=false;
			return;
		}
		else
			canTurn = multiblock||getRotationVec().func_72433_c() != 0;

		if(field_145850_b.func_82737_E()%64==((func_174877_v().func_177958_n()^func_174877_v().func_177952_p())&63))
		{
			rotationVec=null;
		}
		prevRotation = rotation;

		TileEntity acc = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177972_a(facing.func_176734_d()));
		if(!multiblock&&acc instanceof IRotationAcceptor)
		{
			double power = getPower();
			int l=1;
			TileEntity tileEntity = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177967_a(facing, l));
			while (l<3
					&& canUse(tileEntity))
			{
				power += ((TileEntityWatermill)tileEntity).getPower();
				l++;
				tileEntity = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177967_a(facing, l));
			}

			perTick = 1f/1440 * power/l;
			canTurn = perTick!=0;
			rotation += perTick;
			rotation %= 1;
			for(int l2=1; l2<l; l2++)
			{
				tileEntity = field_145850_b.func_175625_s(func_174877_v().func_177967_a(facing, l2));
				if(tileEntity instanceof TileEntityWatermill)
				{
					((TileEntityWatermill)tileEntity).rotation = rotation;
					((TileEntityWatermill)tileEntity).canTurn = canTurn;
					((TileEntityWatermill)tileEntity).perTick = perTick;
					((TileEntityWatermill)tileEntity).multiblock = true;
				}
			}

			if(!field_145850_b.field_72995_K)
			{
				IRotationAcceptor dynamo = (IRotationAcceptor)acc;
				//				if((facing.getAxis()==Axis.Z)&&dynamo.facing!=2&&dynamo.facing!=3)
				//					return;
				//				else if((facing.getAxis()==Axis.X)&&dynamo.facing!=4&&dynamo.facing!=5)
				//					return;
				dynamo.inputRotation(Math.abs(power*.75), facing.func_176734_d());
			}
		}
		else if(!multiblock)
		{
			perTick = 1f/1440 * getPower();
			canTurn = perTick!=0;
			rotation += perTick;
			rotation %= 1;
		}
		if(multiblock)
			multiblock=false;
	}
	private boolean canUse(@Nullable TileEntity tileEntity)
	{
		return tileEntity instanceof TileEntityWatermill
				&& ((TileEntityWatermill)tileEntity).offset[0]==0
				&& ((TileEntityWatermill)tileEntity).offset[1]==0
				&& ( ((TileEntityWatermill)tileEntity).facing==facing || ((TileEntityWatermill)tileEntity).facing==facing.func_176734_d() )
				&& !((TileEntityWatermill)tileEntity).isBlocked()
				&&!((TileEntityWatermill)tileEntity).multiblock;
	}

	public boolean isBlocked()
	{
		if(field_145850_b==null)
			return true;
		for(EnumFacing fdY : new EnumFacing[]{EnumFacing.UP,EnumFacing.DOWN})
			for(EnumFacing fdW : facing.func_176740_k()==Axis.Z?new EnumFacing[]{EnumFacing.EAST,EnumFacing.WEST}: new EnumFacing[]{EnumFacing.SOUTH,EnumFacing.NORTH})
			{
				BlockPos pos = func_174877_v().func_177967_a(fdW,2).func_177967_a(fdY,2);
				IBlockState state = field_145850_b.func_180495_p(pos);
				if(state==null)
					return false;
				if(state.isSideSolid(field_145850_b, pos, fdW.func_176734_d()))
					return true;
				if(state.isSideSolid(field_145850_b, pos, fdY.func_176734_d()))
					return true;
			}
		return false;
	}

	public double getPower()
	{
		return facing.func_176740_k()==Axis.Z?-getRotationVec().field_72450_a:getRotationVec().field_72449_c;
	}
	public void resetRotationVec()
	{
		rotationVec=null;
	}
	public Vec3d getRotationVec()
	{
		if(rotationVec==null)
		{
			rotationVec = new Vec3d(0, 0, 0);
			Vec3d dirHoz = getHorizontalVec();
			Vec3d dirVer = getVerticalVec();
			rotationVec = Utils.addVectors(rotationVec, dirHoz);
			rotationVec = Utils.addVectors(rotationVec, dirVer);
			//			world.addBlockEvent(xCoord, yCoord, zCoord, getBlockType(), (int)((float)rotationVec.xCoord*10000f), (int)((float)rotationVec.zCoord*10000f));
		}
		return rotationVec;
	}

	Vec3d getHorizontalVec()
	{
		Vec3d dir = new Vec3d(0, 0, 0);
		boolean faceZ = facing.ordinal()<=3;
		dir = Utils.addVectors(dir, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(faceZ?1:0), +3, -(faceZ?0:1))));
		dir = Utils.addVectors(dir, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(0, +3, 0)));
		dir = Utils.addVectors(dir, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(+(faceZ?1:0), +3, +(faceZ?0:1))));

		dir = Utils.addVectors(dir, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(faceZ?2:0), +2, -(faceZ?0:2))));
		dir = Utils.addVectors(dir, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(+(faceZ?2:0), +2, +(faceZ?0:2))));

		dir = dir.func_178788_d(Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(faceZ?2:0), -2, -(faceZ?0:2))));
		dir = dir.func_178788_d(Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(+(faceZ?2:0), -2, +(faceZ?0:2))));
		dir = dir.func_178788_d(Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(faceZ?1:0), -3, -(faceZ?0:1))));
		dir = dir.func_178788_d(Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(0, -3, 0)));
		dir = dir.func_178788_d(Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(+(faceZ?1:0), -3, +(faceZ?0:1))));

		return dir;
	}
	Vec3d getVerticalVec()
	{
		Vec3d dir = new Vec3d(0, 0, 0);

		Vec3d dirNeg = new Vec3d(0, 0, 0);
		dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(facing.func_176740_k()==Axis.Z?2:0), 2,-(facing.func_176740_k()==Axis.Z?0:2))));
		dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(facing.func_176740_k()==Axis.Z?3:0), 1,-(facing.func_176740_k()==Axis.Z?0:3))));
		dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(facing.func_176740_k()==Axis.Z?3:0), 0,-(facing.func_176740_k()==Axis.Z?0:3))));
		dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(facing.func_176740_k()==Axis.Z?3:0),-1,-(facing.func_176740_k()==Axis.Z?0:3))));
		dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a(-(facing.func_176740_k()==Axis.Z?2:0),-2,-(facing.func_176740_k()==Axis.Z?0:2))));
		Vec3d dirPos = new Vec3d(0, 0, 0);
		dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a((facing.func_176740_k()==Axis.Z?2:0), 2,(facing.func_176740_k()==Axis.Z?0:2))));
		dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a((facing.func_176740_k()==Axis.Z?3:0), 1,(facing.func_176740_k()==Axis.Z?0:3))));
		dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a((facing.func_176740_k()==Axis.Z?3:0), 0,(facing.func_176740_k()==Axis.Z?0:3))));
		dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a((facing.func_176740_k()==Axis.Z?3:0),-1,(facing.func_176740_k()==Axis.Z?0:3))));
		dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(field_145850_b, func_174877_v().func_177982_a((facing.func_176740_k()==Axis.Z?2:0),-2,(facing.func_176740_k()==Axis.Z?0:2))));
		if(facing.func_176740_k()==Axis.Z)
			dir = dir.func_72441_c(dirNeg.field_72448_b-dirPos.field_72448_b,0,0);
		else
			dir = dir.func_72441_c(0,0,dirNeg.field_72448_b-dirPos.field_72448_b);
		return dir;
	}

	public static boolean _Immovable()
	{
		return true;
	}

	@Override
	public boolean func_145842_c(int id, int arg)
	{
		rotationVec = new Vec3d(id/10000f, 0, arg/10000f);
		return true;
	}
	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		prevRotation = nbt.func_74760_g("prevRotation");
		offset = nbt.func_74759_k("offset");
		rotation = nbt.func_74760_g("rotation");

		if(offset==null||offset.length<2)
			offset=new int[]{0,0};
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74768_a("facing", facing.ordinal());
		nbt.func_74776_a("prevRotation", prevRotation);
		nbt.func_74783_a("offset", offset);
		nbt.func_74776_a("rotation", rotation);
	}

	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;
	@SideOnly(Side.CLIENT)
	@Override
	public AxisAlignedBB getRenderBoundingBox()
	{
		if(renderAABB==null)
			if(offset[0]==0&&offset[1]==0)
				renderAABB = new AxisAlignedBB(func_174877_v().func_177958_n()-(facing.func_176740_k()==Axis.Z?2:0),func_174877_v().func_177956_o()-2,func_174877_v().func_177952_p()-(facing.func_176740_k()==Axis.Z?0:2), func_174877_v().func_177958_n()+(facing.func_176740_k()==Axis.Z?3:0),func_174877_v().func_177956_o()+3,func_174877_v().func_177952_p()+(facing.func_176740_k()==Axis.Z?0:3));
			else
				renderAABB = new AxisAlignedBB(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p(), func_174877_v().func_177958_n()+1,func_174877_v().func_177956_o()+1,func_174877_v().func_177952_p()+1);
		return renderAABB;
	}
	@Override
	public double func_145833_n()
	{
		return super.func_145833_n()* IEConfig.increasedTileRenderdistance;
		//		if(Config.getBoolean("increasedTileRenderdistance"))
		//			return super.getMaxRenderDistanceSquared()*1.5;
		//		return super.getMaxRenderDistanceSquared();
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;	
	}
	@Override
	public int getFacingLimitation()
	{
		return 6;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return true;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}

	@Override
	public boolean isDummy()
	{
		return offset[0]!=0||offset[1]!=0;
	}
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		for(int hh=-2; hh<=2; hh++)
			for(int ww=-2; ww<=2; ww++)
				if((hh>-2&&hh<2)||(ww>-2&&ww<2))
				{
					BlockPos pos2 = pos.func_177982_a(facing.func_176740_k()==Axis.Z?ww:0, hh, facing.func_176740_k()==Axis.Z?0:ww);
					field_145850_b.func_175656_a(pos2, state);
					TileEntityWatermill dummy = (TileEntityWatermill)field_145850_b.func_175625_s(pos2);
					dummy.facing = facing;
					dummy.offset = new int[]{ww,hh};
				}
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		if (!formed)
			return;
		BlockPos initPos = pos.func_177982_a(facing.func_176740_k()==Axis.Z?-offset[0]:0, -offset[1], facing.func_176740_k()==Axis.X?-offset[0]:0);
		for(int hh=-2; hh<=2; hh++)
			for(int ww=-2; ww<=2; ww++)
				if((hh>-2&&hh<2)||(ww>-2&&ww<2))
				{
					BlockPos pos2 = initPos.func_177982_a(facing.func_176740_k()==Axis.Z?ww:0, hh, facing.func_176740_k()==Axis.X?ww:0);
					TileEntity te = field_145850_b.func_175625_s(pos2);
					if(te instanceof TileEntityWatermill)
					{
						((TileEntityWatermill) te).formed = false;
						field_145850_b.func_175698_g(pos2);
					}
				}
	}

	static ArrayList<String> emptyDisplayList = new ArrayList();
	@Override
	public ArrayList<String> compileDisplayList()
	{
		return emptyDisplayList;
	}
}
