/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

import java.util.ArrayList;

public class TileEntitySorter extends TileEntityIEBase implements IGuiTile
{
	public SorterInventory filter;
	public int[] sideFilter = {0,0,0,0,0,0};//OreDict,nbt,fuzzy
	public static final int filterSlotsPerSide = 8;
	private boolean isRouting = false;


	public TileEntitySorter()
	{
		filter = new SorterInventory(this);
	}


	public ItemStack routeItem(EnumFacing inputSide, ItemStack stack, boolean simulate)
	{
		if(!field_145850_b.field_72995_K)
		{
			Integer[][] validOutputs = getValidOutputs(inputSide, stack, true, false);

			if(validOutputs[0].length>0)
			{
				int rand = Utils.RAND.nextInt(validOutputs[0].length);
				stack = this.outputItemToInv(stack, EnumFacing.func_82600_a(validOutputs[0][rand]), simulate);
				if(!stack.func_190926_b())
					for(int i=0; i<validOutputs[0].length; i++)
						if(i!=rand)
						{
							stack = this.outputItemToInv(stack, EnumFacing.func_82600_a(validOutputs[0][i]), simulate);
							if(stack.func_190926_b())
								return ItemStack.field_190927_a;
						}

			}
			if(!stack.func_190926_b() && validOutputs[1].length>0)
			{
				if(!simulate)
				{
					int rand = Utils.RAND.nextInt(validOutputs[1].length);
					EnumFacing fd = EnumFacing.func_82600_a(validOutputs[1][rand]);
					EntityItem ei = new EntityItem(field_145850_b, func_174877_v().func_177958_n()+.5+fd.func_82601_c(), func_174877_v().func_177956_o()+.5+fd.func_96559_d(), func_174877_v().func_177952_p()+.5+fd.func_82599_e(), stack.func_77946_l());
					ei.field_70159_w = (0.075F * fd.func_82601_c());
					ei.field_70181_x = 0.025000000372529D;
					ei.field_70179_y = (0.075F * fd.func_82599_e());
					this.field_145850_b.func_72838_d(ei);
				}
				return ItemStack.field_190927_a;
			}
			if(validOutputs[2].length>0)
			{
				int rand = Utils.RAND.nextInt(validOutputs[2].length);
				stack = this.outputItemToInv(stack, EnumFacing.func_82600_a(validOutputs[2][rand]), simulate);
				if(!stack.func_190926_b())
					for(int i=0; i<validOutputs[2].length; i++)
						if(i!=rand)
						{
							stack = this.outputItemToInv(stack, EnumFacing.func_82600_a(validOutputs[2][i]), simulate);
							if(stack.func_190926_b())
								return ItemStack.field_190927_a;
						}

			}
			if(!stack.func_190926_b() && validOutputs[3].length>0)
			{
				if(!simulate)
				{
					int rand = Utils.RAND.nextInt(validOutputs[3].length);
					EnumFacing fd = EnumFacing.func_82600_a(validOutputs[1][rand]);
					EntityItem ei = new EntityItem(field_145850_b, func_174877_v().func_177958_n()+.5+fd.func_82601_c(), func_174877_v().func_177956_o()+.5+fd.func_96559_d(), func_174877_v().func_177952_p()+.5+fd.func_82599_e(), stack.func_77946_l());
					ei.field_70159_w = (0.075F * fd.func_82601_c());
					ei.field_70181_x = 0.025000000372529D;
					ei.field_70179_y = (0.075F * fd.func_82599_e());
					this.field_145850_b.func_72838_d(ei);
				}
				return ItemStack.field_190927_a;
			}
		}
		return stack;
	}

	public boolean doOredict(int side)
	{
		if(side>=0 && side<this.sideFilter.length)
			return (this.sideFilter[side]&1)!=0;
		return false;
	}
	public boolean doNBT(int side)
	{
		if(side>=0 && side<this.sideFilter.length)
			return (this.sideFilter[side]&2)!=0;
		return false;
	}
	public boolean doFuzzy(int side)
	{
		if(side>=0 && side<this.sideFilter.length)
			return (this.sideFilter[side]&4)!=0;
		return false;
	}

	@Override
	public boolean canOpenGui()
	{
		return true;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_Sorter;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		return this;
	}

	@Override
	public void receiveMessageFromClient(NBTTagCompound message)
	{
		if(message.func_74764_b("sideConfig"))
			this.sideFilter = message.func_74759_k("sideConfig");
	}

	public Integer[][] getValidOutputs(EnumFacing inputSide, ItemStack stack, boolean allowUnmapped, boolean allowThrowing)
	{
		if(isRouting || stack.func_190926_b())
			return new Integer[][]{{},{},{},{}};
		this.isRouting = true;
		ArrayList<Integer> validFilteredInvOuts = new ArrayList<Integer>(6);
		ArrayList<Integer> validFilteredEntityOuts = new ArrayList<Integer>(6);
		ArrayList<Integer> validUnfilteredInvOuts = new ArrayList<Integer>(6);
		ArrayList<Integer> validUnfilteredEntityOuts = new ArrayList<Integer>(6);
		for(EnumFacing side : EnumFacing.values())
			if(side!=inputSide)
			{
				boolean unmapped = true;
				boolean allowed = false;
				filterIteration:
				{
					for(ItemStack filterStack : filter.filters[side.ordinal()])
						if(!filterStack.func_190926_b())
						{
							unmapped = false;

							boolean b = OreDictionary.itemMatches(filterStack, stack, true);

							if(!b && doFuzzy(side.ordinal()))
								b = filterStack.func_77973_b().equals(stack.func_77973_b());

							if(!b && doOredict(side.ordinal()))
								for (String name:OreDictionary.getOreNames())
									if (Utils.compareToOreName(stack, name)&&Utils.compareToOreName(filterStack, name))
									{
										b = true;
										break;
									}

							if(doNBT(side.ordinal()))
								b &= Utils.compareItemNBT(filterStack, stack);
							if(b)
							{
								allowed=true;
								break filterIteration;
							}

						}
				}
				if(allowed)
				{
					TileEntity inventory = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177972_a(side));
					if(Utils.canInsertStackIntoInventory(inventory, stack, side.func_176734_d()))
						validFilteredInvOuts.add(side.ordinal());
					else if(allowThrowing)
						validFilteredEntityOuts.add(side.ordinal());
				}
				else if(allowUnmapped&&unmapped)
				{
					TileEntity inventory = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177972_a(side));
					if(Utils.canInsertStackIntoInventory(inventory, stack, side.func_176734_d()))
						validUnfilteredInvOuts.add(side.ordinal());
					else if(allowThrowing)
						validUnfilteredEntityOuts.add(side.ordinal());
				}
			}
		this.isRouting = false;

		return new Integer[][]{
				validFilteredInvOuts.toArray(new Integer[validFilteredInvOuts.size()]),
				validFilteredEntityOuts.toArray(new Integer[validFilteredEntityOuts.size()]),
				validUnfilteredInvOuts.toArray(new Integer[validUnfilteredInvOuts.size()]),
				validUnfilteredEntityOuts.toArray(new Integer[validUnfilteredEntityOuts.size()])
		};
	}


	//	public void outputItem(ItemStack stack, EnumFacing side)
	//	{
	//		TileEntity inventory = this.world.getTileEntity(getPos().offset(side));
	//		stack = Utils.insertStackIntoInventory(inventory, stack, side.getOpposite());
	//		if(stack != null)
	//		{
	//			EntityItem ei = new EntityItem(world, getPos().getX()+.5+side.getFrontOffsetX(), getPos().getY()+.5+side.getFrontOffsetY(), getPos().getZ()+.5+side.getFrontOffsetZ(), stack.copy());
	//			ei.motionX = (0.075F * side.getFrontOffsetX());
	//			ei.motionY = 0.025000000372529D;
	//			ei.motionZ = (0.075F * side.getFrontOffsetZ());
	//			this.world.spawnEntity(ei);
	//		}
	//	}
	public ItemStack outputItemToInv(ItemStack stack, EnumFacing side, boolean simulate)
	{
		TileEntity inventory = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177972_a(side));
		return Utils.insertStackIntoInventory(inventory, stack, side.func_176734_d(), simulate);
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		sideFilter = nbt.func_74759_k("sideFilter");
		if(!descPacket)
		{
			NBTTagList filterList = nbt.func_150295_c("filter", 10);
			filter = new SorterInventory(this);
			filter.readFromNBT(filterList);


		}
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74783_a("sideFilter", sideFilter);
		if(!descPacket)
		{
			NBTTagList filterList = new NBTTagList();
			filter.writeToNBT(filterList);
			nbt.func_74782_a("filter", filterList);
		}
	}


	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if(capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing!=null)
			return true;
		return super.hasCapability(capability, facing);
	}
	IItemHandler[] insertionHandlers = {
			new SorterInventoryHandler(this,EnumFacing.DOWN),
			new SorterInventoryHandler(this,EnumFacing.UP),
			new SorterInventoryHandler(this,EnumFacing.NORTH),
			new SorterInventoryHandler(this,EnumFacing.SOUTH),
			new SorterInventoryHandler(this,EnumFacing.WEST),
			new SorterInventoryHandler(this,EnumFacing.EAST)};

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing!=null)
			return (T)insertionHandlers[facing.ordinal()];
		return super.getCapability(capability, facing);
	}

	public static class SorterInventoryHandler implements IItemHandlerModifiable
	{
		TileEntitySorter sorter;
		EnumFacing side;
		public SorterInventoryHandler(TileEntitySorter sorter, EnumFacing side)
		{
			this.sorter = sorter;
			this.side = side;
		}

		@Override
		public int getSlots()
		{
			return 1;
		}
		@Override
		public ItemStack getStackInSlot(int slot)
		{
			return ItemStack.field_190927_a;
		}

		@Override
		public ItemStack insertItem(int slot, ItemStack stack, boolean simulate)
		{
			return sorter.routeItem(this.side, stack, simulate);
		}

		@Override
		public ItemStack extractItem(int slot, int amount, boolean simulate)
		{
			return ItemStack.field_190927_a;
		}

		@Override
		public int getSlotLimit(int slot) {
			return 64;
		}

		@Override
		public void setStackInSlot(int slot, ItemStack stack)
		{
		}
	}


	public static class SorterInventory implements IInventory
	{
		public ItemStack[][] filters = new ItemStack[6][filterSlotsPerSide];
		final TileEntitySorter tile;

		public SorterInventory(TileEntitySorter tile)
		{
			this.tile = tile;
			func_174888_l();
		}

		@Override
		public int func_70302_i_()
		{
			return 6*filterSlotsPerSide;
		}

		@Override
		public boolean func_191420_l() {
			for (int i = 0; i < 6; ++i) {
				for (int j = 0; j < filterSlotsPerSide; ++j) {
					if (!filters[i][j].func_190926_b()) {
						return false;
					}
				}
			}
			return true;
		}

		@Override
		public ItemStack func_70301_a(int slot)
		{
			return filters[slot/filterSlotsPerSide][slot%filterSlotsPerSide];
		}

		@Override
		public ItemStack func_70298_a(int slot, int amount)
		{
			ItemStack stack = func_70301_a(slot);
			if(!stack.func_190926_b())
				if(stack.func_190916_E() <= amount)
					func_70299_a(slot, null);
				else
				{
					stack = stack.func_77979_a(amount);
					if(stack.func_190916_E() == 0)
						func_70299_a(slot, null);
				}
			return stack;
		}
		@Override
		public ItemStack func_70304_b(int slot)
		{
			ItemStack stack = func_70301_a(slot);
			if (!stack.func_190926_b())
				func_70299_a(slot, null);
			return stack;
		}
		@Override
		public void func_70299_a(int slot, ItemStack stack)
		{
			filters[slot/filterSlotsPerSide][slot%filterSlotsPerSide] = stack;
			if (!stack.func_190926_b() && stack.func_190916_E() > func_70297_j_())
				stack.func_190920_e(func_70297_j_());
		}
		@Override
		public void func_174888_l()
		{
			for(int i=0; i<filters.length; i++)
				for(int j=0; j<filters[i].length; j++)
					filters[i][j] = ItemStack.field_190927_a;
		}

		@Override
		public String func_70005_c_()
		{
			return "IESorterLayout";
		}
		@Override
		public boolean func_145818_k_()
		{
			return false;
		}
		@Override
		public ITextComponent func_145748_c_()
		{
			return new TextComponentString(func_70005_c_());
		}

		@Override
		public int func_70297_j_()
		{
			return 1;
		}

		@Override
		public boolean func_70300_a(EntityPlayer player)
		{
			return true;
		}

		@Override
		public void func_174889_b(EntityPlayer player){}
		@Override
		public void func_174886_c(EntityPlayer player){}

		@Override
		public boolean func_94041_b(int slot, ItemStack stack)
		{
			return true;
		}
		@Override
		public void func_70296_d()
		{
			this.tile.func_70296_d();
		}

		public void writeToNBT(NBTTagList list)
		{
			for(int i=0; i<this.filters.length; i++)
				for(int j=0; j<this.filters[i].length; j++)
					if(!this.filters[i][j].func_190926_b())
					{
						NBTTagCompound itemTag = new NBTTagCompound();
						itemTag.func_74774_a("Slot", (byte)(i*filterSlotsPerSide+j));
						this.filters[i][j].func_77955_b(itemTag);
						list.func_74742_a(itemTag);
					}

		}
		public void readFromNBT(NBTTagList list)
		{
			for (int i=0; i<list.func_74745_c(); i++)
			{
				NBTTagCompound itemTag = list.func_150305_b(i);
				int slot = itemTag.func_74771_c("Slot") & 255;
				if(slot>=0 && slot<func_70302_i_())
					this.filters[slot/filterSlotsPerSide][slot%filterSlotsPerSide] = new ItemStack(itemTag);
			}
		}


		@Override
		public int func_174887_a_(int id)
		{
			return 0;
		}
		@Override
		public void func_174885_b(int id, int value)
		{
		}
		@Override
		public int func_174890_g()
		{
			return 0;
		}
	}

	@Override
	public boolean func_145842_c(int id, int arg)
	{
		return id == 0;
	}
}
