/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHasDummyBlocks;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityModWorkbench extends TileEntityIEBase implements IIEInventory, IDirectionalTile, IHasDummyBlocks, IGuiTile
{
	NonNullList<ItemStack> inventory = NonNullList.func_191197_a(1, ItemStack.field_190927_a);
	EnumFacing facing = EnumFacing.NORTH;
	public boolean dummy = false;
	public int dummyOffset=0;

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		dummy = nbt.func_74767_n("dummy");
		dummyOffset = nbt.func_74762_e("dummyOffset");
		//		if(!descPacket)
		//		{
		//read inv
		inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 1);
		//		}
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74768_a("facing", facing.ordinal());
		nbt.func_74757_a("dummy", dummy);
		nbt.func_74768_a("dummyOffset", dummyOffset);
		//		if(!descPacket)
		//		{
		nbt.func_74782_a("inventory", Utils.writeInventory(inventory));
		//		}
	}

	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;
	@SideOnly(Side.CLIENT)
	@Override
	public AxisAlignedBB getRenderBoundingBox()
	{
		if(renderAABB==null)
			renderAABB = new AxisAlignedBB(func_174877_v().func_177958_n()-1,func_174877_v().func_177956_o(),func_174877_v().func_177952_p()-1, func_174877_v().func_177958_n()+2,func_174877_v().func_177956_o()+2,func_174877_v().func_177952_p()+2);
		return renderAABB;
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return this.inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return true;
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return 1;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}

	@Override
	public void receiveMessageFromClient(NBTTagCompound message)
	{
		if(!inventory.get(0).func_190926_b() && inventory.get(0).func_77973_b() instanceof IConfigurableTool)
			for(String key : message.func_150296_c())
			{
				if(key.startsWith("b_"))
					((IConfigurableTool) inventory.get(0).func_77973_b()).applyConfigOption(inventory.get(0), key.substring(2), message.func_74767_n(key));
				else if(key.startsWith("f_"))
					((IConfigurableTool) inventory.get(0).func_77973_b()).applyConfigOption(inventory.get(0), key.substring(2), message.func_74760_g(key));
			}
	}

	@Override
	public boolean isDummy()
	{
		return this.dummy;
	}
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		EnumFacing dummyDir = facing.func_176740_k()==Axis.X?(hitZ<.5?EnumFacing.NORTH:EnumFacing.SOUTH):(hitX<.5?EnumFacing.WEST:EnumFacing.EAST);
		boolean mirror = false;
		BlockPos dummyPos = pos.func_177972_a(dummyDir);
		if(!field_145850_b.func_180495_p(dummyPos).func_177230_c().func_176200_f(field_145850_b, dummyPos))
		{
			dummyDir = dummyDir.func_176734_d();
			dummyPos = pos.func_177972_a(dummyDir);
		}
		mirror = dummyDir!=facing.func_176746_e();
		dummyOffset=mirror?-1:1;
		if(mirror)
			this.dummy = true;
		field_145850_b.func_175656_a(dummyPos, state);
		TileEntityModWorkbench tileEntityDummy = ((TileEntityModWorkbench)field_145850_b.func_175625_s(dummyPos));
		tileEntityDummy.facing = this.facing;
		tileEntityDummy.dummy = !mirror;
		tileEntityDummy.dummyOffset=mirror?-1:1;
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		EnumFacing dummyDir = dummy?facing.func_176735_f():facing.func_176746_e();
		field_145850_b.func_175698_g(pos.func_177972_a(dummyDir));
	}

	@Override
	public boolean canOpenGui()
	{
		return true;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_Workbench;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		if(!dummy)
			return this;
		EnumFacing dummyDir = dummy?facing.func_176735_f():facing.func_176746_e();
		TileEntity tileEntityModWorkbench = field_145850_b.func_175625_s(field_174879_c.func_177972_a(dummyDir));
		if(tileEntityModWorkbench instanceof TileEntityModWorkbench)
			return tileEntityModWorkbench;
		return null;
	}
}
