/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.BlockIEBase.IELadderBlock;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalDecoration1;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class BlockWoodenDecoration extends IELadderBlock<BlockTypes_WoodenDecoration>
{
	public BlockWoodenDecoration()
	{
		super("wooden_decoration",Material.field_151575_d, PropertyEnum.func_177709_a("type", BlockTypes_WoodenDecoration.class), ItemBlockIEBase.class, BlockFence.field_176526_a,BlockFence.field_176527_M,BlockFence.field_176528_N,BlockFence.field_176525_b);
		this.func_149711_c(2.0F);
		this.func_149752_b(5.0F);
		this.setBlockLayer(BlockRenderLayer.CUTOUT);
		this.setAllNotNormalBlock();
		field_149786_r = 0;
	}

	@Override
	public boolean useCustomStateMapper()
	{
		return true;
	}
	@Override
	public String getCustomStateMapping(int meta, boolean itemBlock)
	{
		if(meta==0 && !itemBlock)
			return "fence";
		return null;
	}

	@Override
	public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing)
	{
		int meta = this.func_176201_c(world.func_180495_p(pos));
		if(meta==BlockTypes_WoodenDecoration.FENCE.getMeta())
		{
			IBlockState connector = world.func_180495_p(pos.func_177972_a(facing));
			return connector.func_177230_c() instanceof BlockMetalDecoration1&&this.func_176201_c(connector)==meta;
		}
		return super.canBeConnectedTo(world, pos, facing);
	}

	@Override
	public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		//		int meta = world.getBlockMetadata(x, y, z);
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_WoodenDecoration.FENCE.getMeta())
			return side==EnumFacing.UP;
		if(meta==BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta())
			return true;
		//		TileEntity te = world.getTileEntity(x, y, z);
		//		if(te instanceof TileEntityStructuralArm)
		//		{
		//			if(side==UP)
		//				return ((TileEntityStructuralArm)te).inverted;
		//			else if(side==DOWN)
		//				return !((TileEntityStructuralArm)te).inverted;
		//			else
		//				return ((TileEntityStructuralArm)te).facing==side.getOpposite().ordinal();
		//		}
		//		if(meta==META_radiator||meta==META_heavyEngineering||meta==META_generator||meta==META_lightEngineering||meta==META_sheetMetal)
		//			return true;
		//		if(te instanceof TileEntityWallmount)
		//		{
		//			if(side==UP)
		//				return ((TileEntityWallmount)te).inverted;
		//			else if(side==DOWN)
		//				return !((TileEntityWallmount)te).inverted;
		//			else
		//				return true;
		//		}
		return super.isSideSolid(state, world, pos, side);
	}

	@Override
	public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_WoodenDecoration.FENCE.getMeta())
			return side != EnumFacing.UP && side != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
		return BlockFaceShape.SOLID;
	}

	@Override
	public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta())
		{
			IBlockState state2 = world.func_180495_p(pos.func_177972_a(side));
			if(this.equals(state2.func_177230_c()))
			{
				int meta2 = this.func_176201_c(state2);
				return meta2!=BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta();
			}
		}
		return super.func_176225_a(state, world, pos, side);
	}


	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		state  = super.func_176221_a(state, world, pos);
		if(this.func_176201_c(state)==BlockTypes_WoodenDecoration.FENCE.getMeta())
			for(EnumFacing f : EnumFacing.field_176754_o)
				state = state.func_177226_a(f==EnumFacing.NORTH?BlockFence.field_176526_a:f==EnumFacing.SOUTH?BlockFence.field_176527_M:f==EnumFacing.WEST?BlockFence.field_176528_N:BlockFence.field_176525_b, Utils.canFenceConnectTo(world, pos, f, field_149764_J));
		return state;
	}

	//	@Override
//	public void setBlockBoundsBasedOnState(IBlockAccess world, BlockPos pos)
//	{
//		//		TileEntity tileEntity = world.getTileEntity(x, y, z);
//		IBlockState state = world.getBlockState(pos);
//		if(this.getMetaFromState(state)==BlockTypes_WoodenDecoration.FENCE.getMeta())
//			this.setBlockBounds(canConnectFenceTo(world,pos.add(-1,0,0))?0:.375f,0,canConnectFenceTo(world,pos.add(0,0,-1))?0:.375f, canConnectFenceTo(world,pos.add(1,0,0))?1:.625f,1,canConnectFenceTo(world,pos.add(0,0,1))?1:.625f);
//		//		else if(tileEntity instanceof TileEntityLantern)
//		//		{
//		//			int f = ((TileEntityLantern)tileEntity).facing ;
//		//			if(f<2)
//		//				this.setBlockBounds(.25f,f==1?0:.125f,.25f, .75f,f==1?.875f:1f,.75f);
//		//			else
//		//				this.setBlockBounds(f==5?0:.25f,0,f==3?0:.25f, f==4?1:.75f,.875f,f==2?1:.75f);
//		//		}
//		//		else if(tileEntity instanceof TileEntityConnectorStructural)
//		//		{
//		//			float length = .5f;
//		//			switch(((TileEntityConnectorStructural)tileEntity).facing )
//		//			{
//		//			case 0://UP
//		//				this.setBlockBounds(.25f,0,.25f,  .75f,length,.75f);
//		//				break;
//		//			case 1://DOWN
//		//				this.setBlockBounds(.25f,1-length,.25f,  .75f,1,.75f);
//		//				break;
//		//			case 2://SOUTH
//		//				this.setBlockBounds(.25f,.25f,0,  .75f,.75f,length);
//		//				break;
//		//			case 3://NORTH
//		//				this.setBlockBounds(.25f,.25f,1-length,  .75f,.75f,1);
//		//				break;
//		//			case 4://EAST
//		//				this.setBlockBounds(0,.25f,.25f,  length,.75f,.75f);
//		//				break;
//		//			case 5://WEST
//		//				this.setBlockBounds(1-length,.25f,.25f,  1,.75f,.75f);
//		//				break;
//		//			}
//		//		}
//		//		else if(tileEntity instanceof TileEntityWallmount)
//		//		{
//		//			TileEntityWallmount arm = (TileEntityWallmount)tileEntity;
//		//			int f = arm.facing;
//		//			if(arm.sideAttached>0)
//		//				this.setBlockBounds(f==4?0:f==5?.375f:.3125f,arm.inverted?.3125f:0,f==2?0:f==3?.375f:.3125f, f==5?1:f==4?.625f:.6875f,arm.inverted?1:.6875f,f==3?1:f==2?.625f:.6875f);
//		//			else
//		//				this.setBlockBounds(f==5?0:.3125f,arm.inverted?.375f:0,f==3?0:.3125f, f==4?1:.6875f,arm.inverted?1:.625f,f==2?1:.6875f);
//		//		}
//		else
//			this.setBlockBounds(0,0,0,1,1,1);
//	}

	@Override
	public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_)
	{
		state = state.func_185899_b(worldIn, pos);
		if(func_176201_c(state)==BlockTypes_WoodenDecoration.FENCE.getMeta())
		{
			func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185671_f);
			if(state.func_177229_b(BlockFence.field_176526_a))
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185668_C);
			if(state.func_177229_b(BlockFence.field_176525_b))
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185669_D);
			if(state.func_177229_b(BlockFence.field_176527_M))
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185672_g);
			if(state.func_177229_b(BlockFence.field_176528_N))
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185667_B);
		}
		else
			func_185492_a(pos, entityBox, collidingBoxes, new AxisAlignedBB(.0625f, 0, .0625f, .9375f, 1, .9375f));
	}
	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_WoodenDecoration.FENCE.getMeta())
			return new AxisAlignedBB(Utils.canFenceConnectTo(world,pos,EnumFacing.WEST,field_149764_J)?0:.375f,0,Utils.canFenceConnectTo(world,pos,EnumFacing.NORTH,field_149764_J)?0:.375f, Utils.canFenceConnectTo(world,pos,EnumFacing.EAST,field_149764_J)?1:.625f,1f,Utils.canFenceConnectTo(world,pos,EnumFacing.SOUTH,field_149764_J)?1:.625f);
		else if(meta==BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta())
			return field_185505_j;

		return super.func_185496_a(state, world, pos);
	}
	private static int getBoundingBoxIdx(IBlockState state)
	{
		int i = 0;
		if(state.func_177229_b(BlockFence.field_176526_a))
			i |= 1 << EnumFacing.NORTH.func_176736_b();
		if(state.func_177229_b(BlockFence.field_176525_b))
			i |= 1 << EnumFacing.EAST.func_176736_b();
		if(state.func_177229_b(BlockFence.field_176527_M))
			i |= 1 << EnumFacing.SOUTH.func_176736_b();
		if(state.func_177229_b(BlockFence.field_176528_N))
			i |= 1 << EnumFacing.WEST.func_176736_b();
		return i;
	}

	@Override
	public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity)
	{
		return world.func_180495_p(pos).func_177229_b(property)==BlockTypes_WoodenDecoration.SCAFFOLDING;
	}


	@Nullable
	@Override
	public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		if (state.func_177229_b(property) == BlockTypes_WoodenDecoration.FENCE)
			return PathNodeType.FENCE;
		else
			return super.getAiPathNodeType(state, world, pos);
	}
}
