/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockOverlayText;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IPlayerInteraction;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ITileDrop;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.DimensionManager;

import javax.annotation.Nullable;
import java.util.Locale;

public class TileEntityCoresample extends TileEntityIEBase implements IDirectionalTile, ITileDrop, IPlayerInteraction, IBlockOverlayText
{
	public ItemStack coresample = ItemStack.field_190927_a;
	public EnumFacing facing = EnumFacing.NORTH;

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		coresample = new ItemStack(nbt.func_74775_l("coresample"));
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74782_a("coresample", coresample.func_77955_b(new NBTTagCompound()));
		nbt.func_74768_a("facing", facing.ordinal());
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return true;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return true;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return true;
	}

	@Override
	public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ)
	{
		if(player.func_70093_af())
		{
			if(!func_145831_w().field_72995_K)
			{
				EntityItem entityitem = new EntityItem(func_145831_w(), func_174877_v().func_177958_n()+.5,func_174877_v().func_177956_o()+.5,func_174877_v().func_177952_p()+.5, getTileDrop(player, func_145831_w().func_180495_p(func_174877_v())));
				entityitem.func_174869_p();
				func_145831_w().func_175698_g(func_174877_v());
				func_145831_w().func_72838_d(entityitem);
			}
			return true;
		}
		else if(!heldItem.func_190926_b() && heldItem.func_77973_b()==Items.field_151098_aY && ItemNBTHelper.hasKey(coresample, "coords"))
		{
			if(!func_145831_w().field_72995_K)
			{
				MapData mapData = ((ItemMap)heldItem.func_77973_b()).func_77873_a(heldItem, player.func_130014_f_());
				if(mapData!=null)
				{
					int[] coords = ItemNBTHelper.getIntArray(coresample, "coords");
					String ident = "ie:coresample_"+coords[0]+";"+coords[1]+";"+coords[2];
					if(mapData.field_76203_h.containsKey(ident))
					{
						mapData.field_76203_h.remove(ident);
						return true;
					}
					double sampleX = coords[1]*16+8.5;
					double sampleZ = coords[2]*16+8.5;
					int mapScale = 1<<mapData.field_76197_d;
					float distX = (float)(sampleX-mapData.field_76201_a)/(float)mapScale;
					float distZ = (float)(sampleZ-mapData.field_76199_b)/(float)mapScale;
					byte mapX = (byte)((int)((double)(distX*2.0F)+0.5D));
					byte mapZ = (byte)((int)((double)(distZ*2.0F)+0.5D));
					byte b2 = (byte)8;

					if(distX >= -63&&distX <= 63&&distZ >= -63&&distZ <= 63)
						mapData.field_76203_h.put(ident, new MapDecoration(MapDecoration.Type.TARGET_POINT, mapX, mapZ, b2));
					else
						player.func_145747_a(new TextComponentTranslation(Lib.CHAT_INFO+"coresample.mapFail"));
				}
			}
			return true;
		}
		return false;
	}

	@Override
	@Nullable
	public ITextComponent func_145748_c_()
	{
		return coresample.func_82837_s()?new TextComponentString(coresample.func_82833_r()) : new TextComponentTranslation("item.immersiveengineering.coresample.name");
	}

	@Override
	public ItemStack getTileDrop(EntityPlayer player, IBlockState state)
	{
		return this.coresample;
	}
	@Override
	public void readOnPlacement(EntityLivingBase placer, ItemStack stack)
	{
		this.coresample = stack.func_77946_l();
	}
	@Override
	public boolean preventInventoryDrop()
	{
		return true;
	}

	private String[] overlay = null;
	@Override
	public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer)
	{
		if(coresample!=null && ItemNBTHelper.hasKey(coresample, "coords"))
		{
			if(overlay==null)
			{
				overlay = new String[3];
				int[] coords = ItemNBTHelper.getIntArray(coresample, "coords");
				overlay[0] = I18n.func_135052_a(Lib.CHAT_INFO+"coresample.noMineral");
				if(ItemNBTHelper.hasKey(coresample, "mineral"))
				{
					String mineral = ItemNBTHelper.getString(coresample, "mineral");
					String unloc = Lib.DESC_INFO+"mineral."+mineral;
					String loc = I18n.func_135052_a(unloc);
					overlay[0] = TextFormatting.GOLD+I18n.func_135052_a(Lib.CHAT_INFO+"coresample.mineral", (unloc.equals(loc)?mineral: loc));
				}

				World world = DimensionManager.getWorld(coords[0]);
				String s0 = (coords[1]*16)+", "+(coords[2]*16);
				String s1 = (coords[1]*16+16)+", "+(coords[2]*16+16);
				if(world!=null&&world.field_73011_w!=null)
				{
					String name = world.field_73011_w.func_186058_p().func_186065_b();
					if(name.toLowerCase(Locale.ENGLISH).startsWith("the "))
						name = name.substring(4);
					overlay[1] = name;
				}
				else
					overlay[1] = "Dimension "+coords[0];
				overlay[2] = I18n.func_135052_a(Lib.CHAT_INFO+"coresample.pos", s0, s1, "");
			}
			return overlay;
		}
		return new String[0];
	}
	@Override
	public boolean useNixieFont(EntityPlayer player, RayTraceResult mop)
	{
		return false;
	}
}
