/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IEProperties.PropertyBoolInverted;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IActiveState;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IProcessTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IUsesBooleanProperty;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCokeOven extends TileEntityMultiblockPart<TileEntityCokeOven> implements IIEInventory, IActiveState, IGuiTile, IProcessTile
{
	public FluidTank tank = new FluidTank(12000);
	NonNullList<ItemStack> inventory = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
	public int process = 0;
	public int processMax = 0;
	public boolean active = false;
	private static final int[] size = {3, 3, 3};
	public TileEntityCokeOven() {
		super(size);
	}
	@Override
	public PropertyBoolInverted getBoolProperty(Class<? extends IUsesBooleanProperty> inf)
	{
		return inf==IActiveState.class?IEProperties.BOOLEANS[0]:null;
	}
	@Override
	public boolean getIsActive()
	{
		return this.active;
	}
	@Override
	public boolean canOpenGui()
	{
		return formed;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_CokeOven;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		return master();
	}

	@Override
	public float[] getBlockBounds()
	{
		return null;
	}

	@Override
	public ItemStack getOriginalBlock()
	{
		return new ItemStack(IEContent.blockStoneDecoration,1,0);
	}

	@Override
	public boolean isDummy()
	{
		return offset[0]!=0||offset[1]!=0||offset[2]!=0;
	}

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(!field_145850_b.field_72995_K&&formed&&!isDummy())
		{
			boolean a = active;
			boolean b = false;
			if(process>0)
			{
				if(inventory.get(0).func_190926_b())
				{
					process=0;
					processMax=0;
				}
				else
				{
					CokeOvenRecipe recipe = getRecipe();
					if(recipe==null || recipe.time!=processMax)
					{
						process=0;
						processMax=0;
						active=false;
					}
					else
						process--;
				}
				this.markContainingBlockForUpdate(null);
			}
			else
			{
				if(active)
				{
					CokeOvenRecipe recipe = getRecipe();
					if(recipe!=null)
					{
						Utils.modifyInvStackSize(inventory, 0, -1);
						if(!inventory.get(1).func_190926_b())
							inventory.get(1).func_190917_f(recipe.output.func_77946_l().func_190916_E());
						else if(inventory.get(1).func_190926_b())
							inventory.set(1, recipe.output.func_77946_l());
						this.tank.fill(new FluidStack(IEContent.fluidCreosote,recipe.creosoteOutput), true);
					}
					processMax=0;
					active=false;
				}
				CokeOvenRecipe recipe = getRecipe();
				if(recipe!=null)
				{
					this.process=recipe.time;
					this.processMax=process;
					this.active=true;
				}
			}

			if(tank.getFluidAmount()>0 && tank.getFluid()!=null && (inventory.get(3).func_190926_b() || inventory.get(3).func_190916_E() + 1<= inventory.get(3).func_77976_d()))
			{
				ItemStack filledContainer = Utils.fillFluidContainer(tank, inventory.get(2), inventory.get(3), null);
				if(!filledContainer.func_190926_b())
				{
					if(!inventory.get(3).func_190926_b() && OreDictionary.itemMatches(inventory.get(3), filledContainer, true))
						inventory.get(3).func_190917_f(filledContainer.func_190916_E());
					else if(inventory.get(3).func_190926_b())
						inventory.set(3, filledContainer.func_77946_l());
					Utils.modifyInvStackSize(inventory, 2, -filledContainer.func_190916_E());
					b=true;
				}
			}

			if(a!=active || b)
			{
				this.func_70296_d();
				TileEntity tileEntity;
				for(int yy=-1;yy<=1;yy++)
					for(int xx=-1;xx<=1;xx++)
						for(int zz=-1;zz<=1;zz++)
						{
							tileEntity = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177982_a(xx, yy, zz));
							if(tileEntity!=null)
								tileEntity.func_70296_d();
							this.markBlockForUpdate(func_174877_v().func_177982_a(xx, yy, zz), null);
							field_145850_b.func_175641_c(func_174877_v().func_177982_a(xx, yy, zz), IEContent.blockStoneDevice, 1,active?1:0);
						}
			}
		}
	}
	public CokeOvenRecipe getRecipe()
	{
		CokeOvenRecipe recipe = CokeOvenRecipe.findRecipe(inventory.get(0));
		if(recipe==null)
			return null;

		if(inventory.get(1).func_190926_b() || (OreDictionary.itemMatches(inventory.get(1),recipe.output,false) && inventory.get(1).func_190916_E() + recipe.output.func_190916_E() <=getSlotLimit(1)) )
			if(tank.getFluidAmount()+recipe.creosoteOutput<=tank.getCapacity())
				return recipe;
		return null;
	}

	@Override
	public int[] getCurrentProcessesStep()
	{
		TileEntityCokeOven master = master();
		if(master!=this && master!=null)
			return master.getCurrentProcessesStep();
		return new int[]{processMax-process};
	}
	@Override
	public int[] getCurrentProcessesMax()
	{
		TileEntityCokeOven master = master();
		if(master!=this && master!=null)
			return master.getCurrentProcessesMax();
		return new int[]{processMax};
	}

	@Override
	public boolean func_145842_c(int id, int arg)
	{
		if(id==0)
			this.formed = arg==1;
		else if(id==1)
			this.active = arg==1;
		func_70296_d();
		this.markContainingBlockForUpdate(null);
		return true;
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		process = nbt.func_74762_e("process");
		processMax = nbt.func_74762_e("processMax");
		active = nbt.func_74767_n("active");

		tank.readFromNBT(nbt.func_74775_l("tank"));
		if(!descPacket)
		{
			inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 4);
		}
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74768_a("process", process);
		nbt.func_74768_a("processMax", processMax);
		nbt.func_74757_a("active", active);

		NBTTagCompound tankTag = tank.writeToNBT(new NBTTagCompound());
		nbt.func_74782_a("tank", tankTag);
		if(!descPacket)
		{
			nbt.func_74782_a("inventory", Utils.writeInventory(inventory));
		}
	}

	@Override
	public BlockPos getOrigin()
	{
		return func_174877_v().func_177982_a(-offset[0], -offset[1]-1, -offset[2]).func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176735_f());
	}

	@Override
	protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side)
	{
		TileEntityCokeOven master = master();
		if(master!=null)
			return new FluidTank[]{master.tank};
		return new FluidTank[0];
	}
	@Override
	protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource)
	{
		return false;
	}
	@Override
	protected boolean canDrainTankFrom(int iTank, EnumFacing side)
	{
		return true;
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		TileEntityCokeOven master = master();
		if (master!=null && master.formed && formed)
			return master.inventory;
		return this.inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		if(stack.func_190926_b())
			return false;
		if(slot==0)
			return CokeOvenRecipe.findRecipe(stack)!=null;
		if(slot==2)
			return Utils.isFluidRelatedItemStack(stack);
		return false;
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return 64;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
	}

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if(capability== CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return master()!=null;
		return super.hasCapability(capability, facing);
	}
	IItemHandler invHandler = new IEInventoryHandler(4,this,0, new boolean[]{true,false,true,false},new boolean[]{false,true,false,true});
	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability== CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
		{
			TileEntityCokeOven master = master();
			if(master==null)
				return null;
			return (T)master.invHandler;
		}
		return super.getCapability(capability, facing);
	}
}
