/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IEProperties.PropertyBoolInverted;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IActiveState;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IProcessTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IUsesBooleanProperty;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAlloySmelter extends TileEntityMultiblockPart<TileEntityAlloySmelter> implements IIEInventory, IActiveState, IGuiTile, IProcessTile
{
	NonNullList<ItemStack> inventory = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
	public int process = 0;
	public int processMax = 0;
	public boolean active = false;
	public int burnTime = 0;
	public int lastBurnTime = 0;
	private static final int[] size = {2, 2, 2};

	public TileEntityAlloySmelter()
	{
		super(size);
	}
	@Override
	public PropertyBoolInverted getBoolProperty(Class<? extends IUsesBooleanProperty> inf)
	{
		return inf==IActiveState.class?IEProperties.BOOLEANS[0]:null;
	}
	@Override
	public boolean getIsActive()
	{
		return this.active;
	}
	@Override
	public boolean canOpenGui()
	{
		return formed;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_AlloySmelter;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		return master();
	}

	@Override
	public float[] getBlockBounds()
	{
		return null;
	}

	@Override
	public ItemStack getOriginalBlock()
	{
		return new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.ALLOYBRICK.getMeta());
	}

	@Override
	public boolean isDummy()
	{
		return offset[0]!=0||offset[1]!=0||offset[2]!=0;
	}

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(!field_145850_b.field_72995_K&&formed&&!isDummy())
		{
			boolean a = active;

			if(burnTime>0)
			{
				boolean doneWork = false;
				if(process>0)
				{
					if(inventory.get(0).func_190926_b()||inventory.get(1).func_190926_b())
					{
						process=0;
						processMax=0;
					}
					else
					{
						AlloyRecipe recipe = getRecipe();
						if (recipe!=null&&recipe.time!=processMax)
						{
							processMax = 0;
							process = 0;
							active = false;
						}
						else
						{
							process--;
							doneWork = true;
							if (!active)
								active = true;
						}
					}
					markContainingBlockForUpdate(null);
				}
				burnTime--;

				if(process<=0)
				{
					if(processMax>0)
					{
						AlloyRecipe recipe = getRecipe();
						if(recipe!=null)
						{
							boolean flip = !recipe.input0.matchesItemStack(inventory.get(0));
							Utils.modifyInvStackSize(inventory, flip?1:0, -recipe.input0.inputSize);
							Utils.modifyInvStackSize(inventory, flip?0:1, -recipe.input1.inputSize);

							if(!inventory.get(3).func_190926_b())
								inventory.get(3).func_190917_f(recipe.output.func_77946_l().func_190916_E());
							else
								inventory.set(3, recipe.output.func_77946_l());
						}
						processMax=0;
					}
					AlloyRecipe recipe = getRecipe();
					if(recipe!=null)
					{
						this.process=recipe.time;
						if (!doneWork)
							process--;
						this.processMax=recipe.time;
						this.active=true;
					}
				}
			}
			else
			{
				if(active)
					active=false;
			}

			if(burnTime<=10 && getRecipe()!=null)
			{

				if(TileEntityFurnace.func_145954_b(inventory.get(2)))
				{
					lastBurnTime = TileEntityFurnace.func_145952_a(inventory.get(2));
					burnTime += lastBurnTime;
					Utils.modifyInvStackSize(inventory, 2, -1);
					markContainingBlockForUpdate(null);
				}
			}

			if(a!=active)
			{

				this.func_70296_d();
				TileEntity tileEntity;
				for(int yy=-1;yy<=1;yy++)
					for(int xx=-1;xx<=1;xx++)
						for(int zz=-1;zz<=1;zz++)
						{
							tileEntity = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177982_a(xx, yy, zz));
							if (tileEntity != null)
								tileEntity.func_70296_d();
							markBlockForUpdate(func_174877_v().func_177982_a(xx, yy, zz), null);
							field_145850_b.func_175641_c(func_174877_v().func_177982_a(xx, yy, zz), IEContent.blockStoneDevice, 1, active ? 1 : 0);
						}
			}
		}
	}
	public AlloyRecipe getRecipe()
	{
		AlloyRecipe recipe = AlloyRecipe.findRecipe(inventory.get(0), inventory.get(1));
		if(recipe==null)
			return null;
		if(inventory.get(3).func_190926_b() || (OreDictionary.itemMatches(inventory.get(3),recipe.output,true) && inventory.get(3).func_190916_E() + recipe.output.func_190916_E() <=getSlotLimit(3)))
			return recipe;
		return null;
	}

	@Override
	public int[] getCurrentProcessesStep()
	{
		TileEntityAlloySmelter master = master();
		if(master!=this && master!=null)
			return master.getCurrentProcessesStep();
		return new int[]{processMax-process};
	}
	@Override
	public int[] getCurrentProcessesMax()
	{
		TileEntityAlloySmelter master = master();
		if(master!=this && master!=null)
			return master.getCurrentProcessesMax();
		return new int[]{processMax};
	}

	@Override
	public boolean func_145842_c(int id, int arg)
	{
		if(id==0)
			this.formed = arg==1;
		else if(id==1)
			this.active = arg==1;
		func_70296_d();
		markContainingBlockForUpdate(null);
		return true;
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		process = nbt.func_74762_e("process");
		processMax = nbt.func_74762_e("processMax");
		active = nbt.func_74767_n("active");
		burnTime = nbt.func_74762_e("burnTime");
		lastBurnTime = nbt.func_74762_e("lastBurnTime");
		if(!descPacket)
		{
			inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 4);
		}
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74768_a("process", process);
		nbt.func_74768_a("processMax", processMax);
		nbt.func_74757_a("active", active);
		nbt.func_74768_a("burnTime", burnTime);
		nbt.func_74768_a("lastBurnTime", lastBurnTime);
		if(!descPacket)
		{
			nbt.func_74782_a("inventory", Utils.writeInventory(inventory));
		}
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return this.inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return slot==0||slot==1&&TileEntityFurnace.func_145954_b(stack);
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return 64;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
	}
	@Override
	protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side)
	{
		return new FluidTank[0];
	}
	@Override
	protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources)
	{
		return false;
	}
	@Override
	protected boolean canDrainTankFrom(int iTank, EnumFacing side)
	{
		return false;
	}

	@Override
	public BlockPos getOrigin()
	{
		return func_174877_v().func_177982_a(-offset[0], -offset[1], -offset[2]).func_177967_a(facing, -1).func_177972_a(facing.func_176735_f());
	}
}
