/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IIEMetaBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Random;

public class BlockIECrop<E extends Enum<E> & BlockIEBase.IBlockEnum> extends BlockBush implements IGrowable, IIEMetaBlock
{
	protected static IProperty[] tempProperties;
	protected static BlockRenderLayer currentRenderLayer;

	public final String name;
	public final PropertyEnum<E> property;
	public final E[] enumValues;

	public BlockIECrop(String name, PropertyEnum<E> mainProperty)
	{
		super(setTempProperties(Material.field_151585_k, mainProperty));
		this.name = name;
		this.property = mainProperty;
		this.enumValues = mainProperty.func_177699_b().getEnumConstants();
		this.func_180632_j(getInitDefaultState());
		this.func_149663_c(ImmersiveEngineering.MODID+"."+name);
		this.func_149675_a(true);
		this.func_149647_a(null);
		this.func_149711_c(0.0F);
		this.func_149672_a(SoundType.field_185850_c);
		this.func_149649_H();
//		ImmersiveEngineering.registerBlockByFullName(this, new ItemBlock(this), ImmersiveEngineering.MODID+":"+name);
		IEContent.registeredIEBlocks.add(this);
		IEContent.registeredIEItems.add(new ItemBlock(this));
	}

	@Override
	public String getIEBlockName()
	{
		return this.name;
	}
	@Override
	public Enum[] getMetaEnums()
	{
		return enumValues;
	}
	@Override
	public IBlockState getInventoryState(int meta)
	{
		IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(this.property, enumValues[meta]);
		return state;
	}
	@Override
	public IProperty getMetaProperty()
	{
		return this.property;
	}
	@Override
	public boolean useCustomStateMapper()
	{
		return false;
	}
	@Override
	public String getCustomStateMapping(int meta, boolean itemBlock)
	{
		return null;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public StateMapperBase getCustomMapper()
	{
		return null;
	}
	@Override
	public boolean appendPropertiesToState()
	{
		return true;
	}

	protected static Material setTempProperties(Material material, PropertyEnum<?> property)
	{
		tempProperties=new IProperty[1];
		tempProperties[0] = property;
		return material;
	}

	protected BlockStateContainer createNotTempBlockState()
	{
		IProperty[] array = new IProperty[1];
		array[0] = this.property;
		return new BlockStateContainer(this, array);
	}
	protected IBlockState getInitDefaultState()
	{
		IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(this.property, enumValues[0]);
		return state;
	}

	public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack)
	{
	}

	@Override
	protected BlockStateContainer func_180661_e()
	{
		return this.property!=null?createNotTempBlockState(): new BlockStateContainer(this, tempProperties);
	}
	@Override
	public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack)
	{
		super.func_180633_a(worldIn, pos, state, placer, stack);
	}
	@Override
	public int func_176201_c(IBlockState state)
	{
		return state.func_177229_b(this.property).getMeta();
	}
	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		return state;
	}
	@Override
	public IBlockState func_176203_a(int meta)
	{
		IBlockState state = this.func_176223_P().func_177226_a(this.property, fromMeta(meta));
		return state;
	}
	protected E fromMeta(int meta)
	{
		if(meta<0||meta>=enumValues.length)
			meta = 0;
		return enumValues[meta];
	}

	public int getMinMeta(int meta)
	{
		return meta<=4?0:5;
	}
	public int getMaxMeta(int meta)
	{
		return meta<=4?4:5;
	}
	@Override
	public boolean func_180671_f(World world, BlockPos pos, IBlockState state)
	{
		boolean b = super.func_180671_f(world, pos, state);
		if(this.func_176201_c(state)==5)
		{
			IBlockState stateBelow = world.func_180495_p(pos.func_177982_a(0,-1,0));
			b = stateBelow.func_177230_c().equals(this)&&this.func_176201_c(stateBelow)==getMaxMeta(0);
		}
		return b;
	}

	@Override
	protected boolean func_185514_i(IBlockState state)
	{
		return state.func_177230_c() == Blocks.field_150458_ak;
	}

	@Override
	public EnumPlantType getPlantType(net.minecraft.world.IBlockAccess world, BlockPos pos)
	{
		return EnumPlantType.Crop;
	}

	static final AxisAlignedBB box0 = new AxisAlignedBB(0,0,0, 1,.375f,1);
	static final AxisAlignedBB box1 = new AxisAlignedBB(0,0,0, 1,.625f,1);
	static final AxisAlignedBB box2 = new AxisAlignedBB(0,0,0, 1,.875f,1);
	@Override
	public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos)
	{
		int meta = this.func_176201_c(world.func_180495_p(pos));
		return meta==0?box0: meta==1?box1: meta==2?box2: field_185505_j;
	}
	@Override
	public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune)
	{
		int meta = this.func_176201_c(state);
		if(meta>=4)
		{
			for (int i=0; i<3+fortune; ++i)
				if(Utils.RAND.nextInt(8) <= meta)
					drops.add(new ItemStack(IEContent.itemMaterial,1,4));
			drops.add(new ItemStack(IEContent.itemSeeds,1,0));
		}
	}
	@Override
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos block)
	{
        super.onNeighborChange(world, pos, block);
		if(this.func_176201_c(world.func_180495_p(pos))<getMaxMeta(0))
            //FIXME: TEST THIS.
            if (world instanceof World)
                ((World)world).func_175685_c(pos.func_177982_a(0, 1, 0), this, true);
	}


	@Override
	public void func_180650_b (World world, BlockPos pos, IBlockState state, Random random)
	{
		this.func_176475_e(world, pos, state);
		int light = world.func_175699_k(pos);
		if(light >= 12)
		{
			int meta = this.func_176201_c(state);
			if(meta>4)
				return;
			float growth = this.getGrowthSpeed(world, pos, state, light);
			if(random.nextInt((int)(50F/growth)+1) == 0)
			{
				if(this.getMaxMeta(meta) != meta)
				{
					meta++;
					world.func_175656_a(pos, this.func_176203_a(meta));
				}
				if(meta>3 && world.func_175623_d(pos.func_177982_a(0,1,0)))
					world.func_175656_a(pos.func_177982_a(0,1,0), this.func_176203_a(meta+1));
			}
		}
	}
	float getGrowthSpeed(World world, BlockPos pos, IBlockState sate, int light)
	{
		float growth = 0.125f * (light - 11);
		if(world.func_175710_j(pos))
			growth += 2f;
		IBlockState soil = world.func_180495_p(pos.func_177982_a(0,-1,0));
		if(soil.func_177230_c().isFertile(world,pos.func_177982_a(0,-1,0)))
			growth *= 1.5f;
		return 1f + growth;
	}

	@Override
	public boolean func_176196_c(World worldIn, BlockPos pos)
	{
		IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
		return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, worldIn, pos.func_177977_b(), net.minecraft.util.EnumFacing.UP, this);
	}

	//isNotGrown
	@Override
	public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient)
	{
		int meta = this.func_176201_c(state);
		if(meta<getMaxMeta(meta))
			return true;
		else
			return meta==4 && !world.func_180495_p(pos.func_177982_a(0,1,0)).func_177230_c().equals(this);
	}
	//canBonemeal
	@Override
	public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state)
	{
		int meta = this.func_176201_c(state);
		if(meta<getMaxMeta(meta))
			return true;
		else
			return meta==4 && !world.func_180495_p(pos.func_177982_a(0,1,0)).func_177230_c().equals(this);
	}
	@Override
	public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state)
	{
		int meta = this.func_176201_c(state);
		if(meta<getMaxMeta(meta))
		{
			int span = getMaxMeta(meta)-meta;
			int newMeta = meta+rand.nextInt(span)+1;
			if(newMeta!=meta)
				world.func_175656_a(pos, this.func_176203_a(newMeta));
			meta = newMeta;
		}
		if(meta==4 && world.func_175623_d(pos.func_177982_a(0,1,0)))
			world.func_175656_a(pos.func_177982_a(0,1,0), this.func_176203_a(meta+1));
	}
}
