/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler.IMultiblock;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Set;

public class MultiblockFeedthrough implements IMultiblock
{
	public static MultiblockFeedthrough instance = new MultiblockFeedthrough();
	static ItemStack[][][] structure = new ItemStack[1][1][3];
	static{
		structure[0][0][0] = new ItemStack(IEContent.blockConnectors, 1);
		structure[0][0][1] = new ItemStack(Blocks.field_150342_X, 1).func_190924_f("tile.immersiveengineering.arb_solid.name");
		structure[0][0][2] = new ItemStack(IEContent.blockConnectors, 1);
	}
	@Override
	public ItemStack[][][] getStructureManual()
	{
		return structure;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean overwriteBlockRender(ItemStack stack, int iterator)
	{
		return false;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean canRenderFormedStructure()
	{
		return true;
	}

	private ItemStack renderStack;
	@Override
	@SideOnly(Side.CLIENT)
	public void renderFormedStructure()
	{
		if(renderStack==null||renderStack.func_190926_b())
			renderStack = new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.FEEDTHROUGH.getMeta());

		GlStateManager.func_179137_b(.5, .5, 1.5);
		GlStateManager.func_179114_b(-45, 0, 1, 0);
		GlStateManager.func_179114_b(-30, 1, 0, 0);
		GlStateManager.func_179139_a(1.75, 1.75, 1.75);

		GlStateManager.func_179129_p();
		ClientUtils.mc().func_175599_af().func_181564_a(renderStack, ItemCameraTransforms.TransformType.GUI);
		GlStateManager.func_179089_o();
	}

	@Override
	public IBlockState getBlockstateFromStack(int index, ItemStack stack)
	{
		IBlockState ret = IMultiblock.super.getBlockstateFromStack(index, stack);
		if (stack==structure[0][0][0])
			return ret.func_177226_a(IEProperties.FACING_ALL, EnumFacing.SOUTH);
		return ret;
	}

	@Override
	public float getManualScale()
	{
		return 12;
	}

	@Override
	public String getUniqueName()
	{
		return "IE:Feedthrough";
	}

	@Override
	public boolean isBlockTrigger(IBlockState state)
	{
		return WireApi.getWireType(state)!=null;
	}

	@Override
	public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player)
	{
		side = side.func_176734_d();
		IBlockState here = world.func_180495_p(pos).func_185899_b(world, pos);
		if (here.func_177229_b(IEProperties.FACING_ALL)!=side)
			return false;
		Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(world, pos);
		if (conns!=null&&!conns.isEmpty())
			return false;
		WireType wire = WireApi.getWireType(here);
		if (wire==null)//This shouldn't ever happen
			return false;
		BlockPos tmp = pos.func_177972_a(side);
		IBlockState middle = world.func_180495_p(tmp).func_185899_b(world, tmp);
		if (!middle.func_185917_h()||middle.func_177230_c().hasTileEntity(middle)||middle.func_185901_i()!= EnumBlockRenderType.MODEL)
			return false;
		tmp = pos.func_177967_a(side, 2);
		IBlockState otherConn = world.func_180495_p(tmp).func_185899_b(world, tmp);
		if (WireApi.getWireType(otherConn)!=wire)
			return false;
		if (otherConn.func_177229_b(IEProperties.FACING_ALL)!=side.func_176734_d())
			return false;
		conns = ImmersiveNetHandler.INSTANCE.getConnections(world, tmp);
		if (conns!=null&&!conns.isEmpty())
			return false;
		IBlockState state = IEContent.blockConnectors.func_176223_P().func_177226_a(IEContent.blockConnectors.property,
				BlockTypes_Connector.FEEDTHROUGH).func_177226_a(IEProperties.FACING_ALL, side);
		for (int i = 0;i<=2;i++)
		{
			tmp = pos.func_177967_a(side, i);
			world.func_175656_a(tmp, state);
			TileEntity te = world.func_175625_s(tmp);
			if (te instanceof TileEntityFeedthrough)
			{
				((TileEntityFeedthrough) te).reference = wire;
				((TileEntityFeedthrough) te).stateForMiddle = middle;
				((TileEntityFeedthrough) te).offset = i-1;
				world.func_175664_x(tmp);
			}

		}
		return true;
	}

	@Override
	public IngredientStack[] getTotalMaterials()
	{
		return new IngredientStack[]{
				new IngredientStack(new ItemStack(IEContent.blockConnectors, 2)),
				new IngredientStack(new ItemStack(Blocks.field_150342_X, 1).func_190924_f("Arbitrary solid block"))
		};
	}
}
